/*
 * Decompiled with CFR 0.152.
 */
package game;

import java.awt.Dimension;
import java.awt.Toolkit;
import menu.GameController;
import menu.GameSettings;
import navigationView.LabyrinthNavigationView;
import navigationView.SinglePlayerView;
import navigationView.ViewModel;
import rendering.thread.GameThread;
import rendering.thread.PeriodicExecutionService;
import rendering.thread.SingleScreenRenderThread;

public class Game {
    public void startGame(GameController gameController) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double width = screenSize.getWidth();
        int scaleFactor = (int)width / 750 + 1;
        GameSettings gameSettings = gameController.getGameSettings();
        ViewModel viewModel = new ViewModel(gameSettings, scaleFactor, false, null, false);
        viewModel.applyPlayerName(gameSettings.getPlayerName());
        LabyrinthNavigationView navigationView = new LabyrinthNavigationView(viewModel, true);
        SinglePlayerView singlePlayerView = new SinglePlayerView(navigationView, gameController);
        singlePlayerView.render();
        GameThread gameThread = new GameThread(navigationView, null, singlePlayerView);
        new PeriodicExecutionService(gameThread).start(ViewModel.getMillisecondsForStep(), 0L);
        SingleScreenRenderThread displayThread = new SingleScreenRenderThread(singlePlayerView);
        new PeriodicExecutionService(displayThread).start(5L, 0L);
    }
}

