/*
 * Decompiled with CFR 0.152.
 */
package game;

import java.net.DatagramSocket;
import menu.GameController;
import menu.RenderableFrame;
import navigationView.MultiplayerClientView;
import navigationView.MultiplayerClientViewColored;
import navigationView.MultiplayerClientViewSplitScreen;
import network.ClientConnection;
import rendering.thread.MultiplayerClientDatagramListenerThread;
import rendering.thread.MultiplayerClientListenerThread;
import rendering.thread.MultiplayerClientRenderThread;
import rendering.thread.PeriodicExecutionService;

public class NetworkClientGame {
    public void startGame(GameController gameController, ClientConnection connection, boolean isPreferredSplitScreen, boolean isHost) {
        RenderableFrame mainView = isPreferredSplitScreen && connection.getNumberOfPlayers() < 5 ? new MultiplayerClientViewSplitScreen(gameController, connection) : new MultiplayerClientViewColored(gameController, connection, isHost);
        mainView.renderInitially();
        MultiplayerClientListenerThread updateThread = new MultiplayerClientListenerThread((MultiplayerClientView)((Object)mainView), connection.getPlayer().getClient(), gameController.getGameCoordinatorApplicationState());
        updateThread.start();
        DatagramSocket datagramSocket = connection.getPlayer().getDatagramClient();
        if (datagramSocket != null) {
            MultiplayerClientDatagramListenerThread displayThread = new MultiplayerClientDatagramListenerThread((MultiplayerClientView)((Object)mainView), connection.getPlayer().getDatagramClient(), connection.getPlayer().getClient());
            displayThread.start();
        }
        MultiplayerClientRenderThread renderThread = new MultiplayerClientRenderThread((MultiplayerClientView)((Object)mainView));
        new PeriodicExecutionService(renderThread).start(5L, 0L);
    }
}

