/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.ShutdownGameCoordinator;
import java.awt.Dimension;
import java.util.ArrayList;
import menu.GameSettings;
import navigationView.KeyConfig;
import navigationView.LabyrinthNavigationView;
import navigationView.MultiplayerHostViewColored;
import navigationView.ViewModel;
import network.Player;
import network.ServerConnection;
import rendering.thread.MultiplayerHostListenerThread;
import rendering.thread.MultiplayerHostStepThread;
import rendering.thread.NetworkGameThread;
import rendering.thread.PeriodicExecutionService;

public class NetworkGameCoordinatorHostGame {
    private ShutdownGameCoordinator shutdownGameCoordinator;

    public NetworkGameCoordinatorHostGame(ShutdownGameCoordinator shutdownGameCoordinator) {
        this.shutdownGameCoordinator = shutdownGameCoordinator;
    }

    public void startGame(GameSettings gameSettings, ServerConnection connection) {
        Dimension screenSize = new Dimension(1920, 1080);
        double width = screenSize.getWidth();
        int scaleFactorLabyrinth = 3;
        double scaleFactorVictoryScreen = width / 1200.0;
        ArrayList<Player> playerList = connection.getPlayerList();
        ViewModel viewModel = new ViewModel(gameSettings, scaleFactorLabyrinth, gameSettings.isPreferNetworkSplitscreen(), null, true);
        ArrayList<LabyrinthNavigationView> viewList = new ArrayList<LabyrinthNavigationView>();
        ArrayList<String> playerNameList = new ArrayList<String>();
        for (Player player : playerList) {
            playerNameList.add(player.getName());
        }
        viewModel.setPlayerNameList(playerNameList);
        LabyrinthNavigationView gameControllingView = new LabyrinthNavigationView(viewModel, false);
        ArrayList<MultiplayerHostListenerThread> threadList = new ArrayList<MultiplayerHostListenerThread>();
        for (Player player : playerList) {
            ViewModel playerViewModel = new ViewModel(viewModel, gameSettings.isPreferNetworkSplitscreen(), player);
            playerViewModel.setPlayerNameList(playerNameList);
            LabyrinthNavigationView playerView = new LabyrinthNavigationView(playerViewModel, new KeyConfig(), scaleFactorVictoryScreen);
            viewList.add(playerView);
            MultiplayerHostListenerThread multiplayerHostListenerThread = new MultiplayerHostListenerThread(player, playerView, connection);
            multiplayerHostListenerThread.registerShutdownGameCoordinator(this.shutdownGameCoordinator);
            multiplayerHostListenerThread.setNavigationView(gameControllingView);
            multiplayerHostListenerThread.resendDisconnect();
            threadList.add(multiplayerHostListenerThread);
        }
        connection.waitForAllLobbies();
        boolean isSplitScreen = gameSettings.isPreferNetworkSplitscreen() && connection.getPlayerList().size() < 5;
        NetworkGameThread gameThread = new NetworkGameThread(viewList, connection, isSplitScreen);
        gameThread.setServerViewModel(viewModel);
        new PeriodicExecutionService(gameThread).registerShutdownGameCoordinator(this.shutdownGameCoordinator).start(ViewModel.getMillisecondsForStep(), 100L);
        MultiplayerHostViewColored mainView = new MultiplayerHostViewColored(viewList, null, connection, threadList);
        mainView.setMainView(gameControllingView);
        for (Thread thread : threadList) {
            thread.start();
        }
        MultiplayerHostStepThread hostStepThread = new MultiplayerHostStepThread(mainView, true);
        new PeriodicExecutionService(hostStepThread).registerShutdownGameCoordinator(this.shutdownGameCoordinator).start(5L, 100L);
    }
}

