/*
 * Decompiled with CFR 0.152.
 */
package game;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ArrayList;
import menu.GameController;
import menu.GameSettings;
import menu.RenderableFrame;
import navigationView.KeyConfig;
import navigationView.LabyrinthNavigationView;
import navigationView.MultiplayerHostView;
import navigationView.MultiplayerHostViewColored;
import navigationView.MultiplayerHostViewSplitScreen;
import navigationView.ViewModel;
import network.Player;
import network.ServerConnection;
import rendering.thread.MultiplayerHostListenerThread;
import rendering.thread.MultiplayerHostStepThread;
import rendering.thread.NetworkGameThread;
import rendering.thread.PeriodicExecutionService;

public class NetworkHostGame {
    public void startGame(GameController gameController, ServerConnection connection) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double width = screenSize.getWidth();
        int scaleFactorLabyrinth = 3;
        double scaleFactorVictoryScreen = width / 1200.0;
        GameSettings gameSettings = gameController.getGameSettings();
        gameSettings.setGuidedMode(true);
        ArrayList<Player> playerList = connection.getPlayerList();
        ViewModel viewModel = new ViewModel(gameSettings, scaleFactorLabyrinth, gameSettings.isPreferNetworkSplitscreen(), playerList.get(0), true);
        ArrayList<LabyrinthNavigationView> viewList = new ArrayList<LabyrinthNavigationView>();
        LabyrinthNavigationView localView = new LabyrinthNavigationView(viewModel, new KeyConfig(), scaleFactorVictoryScreen);
        viewList.add(localView);
        ArrayList<String> playerNameList = new ArrayList<String>();
        for (Player player : playerList) {
            playerNameList.add(player.getName());
        }
        viewModel.setPlayerNameList(playerNameList);
        ArrayList<MultiplayerHostListenerThread> threadList = new ArrayList<MultiplayerHostListenerThread>();
        for (int i = 1; i < playerList.size(); ++i) {
            ViewModel playerViewModel = new ViewModel(viewModel, gameSettings.isPreferNetworkSplitscreen(), playerList.get(i));
            playerViewModel.setPlayerNameList(playerNameList);
            LabyrinthNavigationView playerView = new LabyrinthNavigationView(playerViewModel, new KeyConfig(), scaleFactorVictoryScreen);
            viewList.add(playerView);
            MultiplayerHostListenerThread networkGameThread = new MultiplayerHostListenerThread(playerList.get(i), playerView, connection);
            threadList.add(networkGameThread);
            networkGameThread.setNavigationView(localView);
        }
        connection.waitForAllLobbies();
        boolean isSplitScreen = gameSettings.isPreferNetworkSplitscreen() && connection.getPlayerList().size() < 5;
        NetworkGameThread gameThread = new NetworkGameThread(viewList, connection, isSplitScreen);
        new PeriodicExecutionService(gameThread).start(ViewModel.getMillisecondsForStep(), 100L);
        RenderableFrame mainView = isSplitScreen ? new MultiplayerHostViewSplitScreen(viewList, gameController, connection, threadList) : new MultiplayerHostViewColored(viewList, gameController, connection, threadList);
        mainView.renderInitially();
        for (Thread thread : threadList) {
            thread.start();
        }
        MultiplayerHostStepThread displayThread = new MultiplayerHostStepThread((MultiplayerHostView)((Object)mainView), false);
        new PeriodicExecutionService(displayThread).start(5L, 100L);
    }
}

