/*
 * Decompiled with CFR 0.152.
 */
package game;

import java.awt.Dimension;
import java.awt.Toolkit;
import menu.GameController;
import menu.GameSettings;
import navigationView.KeyConfig;
import navigationView.LabyrinthNavigationView;
import navigationView.SplitScreenView;
import navigationView.ViewModel;
import rendering.thread.GameThread;
import rendering.thread.PeriodicExecutionService;
import rendering.thread.SplitScreenRenderThread;

public class SplitscreenGame {
    public void startGame(GameController gameController) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double width = screenSize.getWidth();
        int scaleFactorLabyrinth = (int)width / 750 + 1;
        double scaleFactorVictoryScreen = width / 1200.0;
        GameSettings gameSettings = gameController.getGameSettings();
        ViewModel viewModel = new ViewModel(gameSettings, scaleFactorLabyrinth, true, null, false);
        ViewModel viewModel2 = new ViewModel(viewModel, true, null);
        viewModel.applyPlayerName(gameSettings.getPlayerName());
        viewModel2.applyPlayerName(gameSettings.getPlayerTwoName());
        KeyConfig player1KeyConfig = new KeyConfig();
        KeyConfig player2KeyConfig = new KeyConfig();
        player1KeyConfig.setUp(87);
        player1KeyConfig.setDown(83);
        player1KeyConfig.setLeft(65);
        player1KeyConfig.setRight(68);
        player1KeyConfig.setAlternateDown(88);
        player1KeyConfig.setAlternateUp(87);
        player1KeyConfig.setAlternateLeft(65);
        player1KeyConfig.setAlternateRight(68);
        player1KeyConfig.setUpLeft(81);
        player1KeyConfig.setUpRight(69);
        player1KeyConfig.setDownLeft(89);
        player1KeyConfig.setDownRight(67);
        player2KeyConfig.setStart(70);
        LabyrinthNavigationView view = new LabyrinthNavigationView(viewModel, player1KeyConfig, scaleFactorVictoryScreen);
        LabyrinthNavigationView view2 = new LabyrinthNavigationView(viewModel2, player2KeyConfig, scaleFactorVictoryScreen);
        SplitScreenView mainView = new SplitScreenView(view, view2, gameController);
        mainView.render();
        GameThread gameThread = new GameThread(view, view2, mainView);
        GameThread gameThread2 = new GameThread(view2, view, mainView);
        new PeriodicExecutionService(gameThread).start(ViewModel.getMillisecondsForStep(), 0L);
        new PeriodicExecutionService(gameThread2).start(ViewModel.getMillisecondsForStep(), 0L);
        SplitScreenRenderThread displayThread = new SplitScreenRenderThread(mainView);
        new PeriodicExecutionService(displayThread).start(5L, 0L);
    }
}

