/*
 * Decompiled with CFR 0.152.
 */
package game.utils;

import game.GameLogicException;
import game.utils.LogHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import network.ReadWriteHelper;

public class IniFileParser {
    private static IniFileParser singleton;
    private int errorLevel = 0;
    private int debugLevel = 0;
    private boolean uploadOfflineScore = false;
    private String offlineScoreSecret = "";
    private String gameCoordinatorAddress = "127.0.0.1";

    public IniFileParser() {
    }

    public IniFileParser(String iniFilePath) {
        InputStream in = this.getClass().getResourceAsStream("/resources/" + iniFilePath);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line = reader.readLine();
            while (line != null) {
                String[] split = line.split(": ");
                if (split.length > 1) {
                    switch (split[0]) {
                        case "errorLogMode": {
                            this.errorLevel = Integer.parseInt(split[1]);
                            break;
                        }
                        case "debugLogMode": {
                            this.debugLevel = Integer.parseInt(split[1]);
                            break;
                        }
                        case "gameCoordinatorAddress": {
                            this.gameCoordinatorAddress = split[1];
                            break;
                        }
                        case "uploadOfflineScore": {
                            this.uploadOfflineScore = Integer.parseInt(split[1]) == 1;
                            break;
                        }
                        case "offlineScoreSecret": {
                            this.offlineScoreSecret = split[1];
                        }
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            singleton = new IniFileParser();
            LogHandler.notifyException(e);
            return;
        }
        ReadWriteHelper.debugTraffic = this.debugLevel > 0;
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public boolean isUploadOfflineScorePossible() {
        return this.uploadOfflineScore;
    }

    public String getOfflineScoreSecret() {
        return this.offlineScoreSecret;
    }

    public String getGameCoordinatorAddress() {
        return this.gameCoordinatorAddress;
    }

    public static IniFileParser getInstance() {
        if (singleton == null) {
            throw new GameLogicException("please specify client or server ini file");
        }
        return singleton;
    }

    public static void initializeIniFile(boolean isClient) {
        if (isClient) {
            singleton = new IniFileParser("configClient.ini");
            return;
        }
        singleton = new IniFileParser("configServer.ini");
    }
}

