/*
 * Decompiled with CFR 0.152.
 */
package game.utils;

import game.utils.IniFileParser;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Date;

public class LogHandler {
    private static LogHandler singleton;
    private int errorLevel;
    private int debugLevel;
    private PrintWriter errorPrintWriter;
    private PrintWriter debugPrintWriter;

    public LogHandler(int errorLevel, int debugLevel) {
        this.errorLevel = errorLevel;
        this.debugLevel = debugLevel;
    }

    public static void notifyException(Exception e) {
        LogHandler logHandler = LogHandler.getInstance();
        if (logHandler.errorLevel == 1) {
            e.printStackTrace();
        }
        if (logHandler.errorLevel == 2) {
            if (logHandler.errorPrintWriter == null) {
                try {
                    logHandler.errorPrintWriter = new PrintWriter("error.log");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    logHandler.errorLevel = 1;
                    fileNotFoundException.printStackTrace();
                    e.printStackTrace();
                }
            }
            logHandler.errorPrintWriter.print(new Date() + ": ");
            e.printStackTrace(logHandler.errorPrintWriter);
            logHandler.errorPrintWriter.flush();
        }
    }

    public static void notifyDebugMessage(String message) {
        LogHandler logHandler = LogHandler.getInstance();
        if (logHandler.debugLevel == 1) {
            System.out.println(message);
        }
        if (logHandler.debugLevel == 2) {
            if (logHandler.debugPrintWriter == null) {
                try {
                    logHandler.debugPrintWriter = new PrintWriter("debug.log");
                }
                catch (FileNotFoundException e) {
                    logHandler.debugLevel = 1;
                    LogHandler.notifyException(e);
                    System.out.println(message);
                }
            }
            logHandler.debugPrintWriter.println(message);
            logHandler.debugPrintWriter.flush();
        }
    }

    private static LogHandler getInstance() {
        if (singleton == null) {
            IniFileParser iniFileParser = IniFileParser.getInstance();
            singleton = new LogHandler(iniFileParser.getErrorLevel(), iniFileParser.getDebugLevel());
        }
        return singleton;
    }
}

