/*
 * Decompiled with CFR 0.152.
 */
package gameServer;

import gameServer.ClientState;
import java.io.IOException;
import java.net.Socket;
import java.util.Objects;

public class Client {
    private Socket socket;
    private int playerNumber;
    private String playerName;
    private ClientState clientState;

    public Client(Socket socket, int playerNumber) {
        this.socket = socket;
        this.playerNumber = playerNumber;
        this.clientState = ClientState.ENTRANCE;
    }

    public ClientState getClientState() {
        return this.clientState;
    }

    public void setClientState(ClientState clientState) {
        this.clientState = clientState;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public void disconnect() throws IOException {
        if (this.isConnected()) {
            this.socket.close();
        }
        this.clientState = ClientState.DISCONNECTED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Client)) {
            return false;
        }
        Client client = (Client)o;
        return this.playerNumber == client.playerNumber;
    }

    public int hashCode() {
        return Objects.hash(this.playerNumber);
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    public String getPlayerName() {
        return this.playerName;
    }
}

