/*
 * Decompiled with CFR 0.152.
 */
package gameServer.ClientSide;

import game.utils.LogHandler;
import gameServer.ClientSide.GameCoordinatorConnection;
import gameServer.ClientState;
import java.io.EOFException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import menu.OnlineLobbyFrame;
import network.ReadWriteHelper;
import network.SerializableNetworkObject;

public class GameCoordinatorClientListener
extends Thread {
    private GameCoordinatorConnection gameCoordinatorConnection;
    private OnlineLobbyFrame onlineLobbyFrame;
    private boolean running = true;
    private ClientState clientState;

    public GameCoordinatorClientListener(GameCoordinatorConnection gameCoordinatorConnection, OnlineLobbyFrame onlineLobbyFrame) {
        this.gameCoordinatorConnection = gameCoordinatorConnection;
        this.onlineLobbyFrame = onlineLobbyFrame;
    }

    public void stopThread() {
        this.running = false;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                String action;
                String[] split;
                Socket clientSocket = this.gameCoordinatorConnection.getClientSocket();
                SerializableNetworkObject serializableNetworkObject = ReadWriteHelper.readSocketObject(clientSocket);
                if (serializableNetworkObject == null) continue;
                if (serializableNetworkObject.getLobbyUpdateRecord() != null) {
                    this.onlineLobbyFrame.updateLobby(serializableNetworkObject.getLobbyUpdateRecord());
                }
                if (serializableNetworkObject.getCommand() == null || (split = serializableNetworkObject.getCommand().split(";")).length <= 0) continue;
                switch (action = split[0]) {
                    case "joinLobbySuccess": {
                        String[] namesArray;
                        if (split.length > 3 && split[1].equals("1")) {
                            namesArray = Arrays.copyOfRange(split, 3, split.length - 1);
                            this.onlineLobbyFrame.enterSelectedLobby(namesArray, Integer.parseInt(split[split.length - 1]));
                            break;
                        }
                        this.gameCoordinatorConnection.getClientConnection().disconnectPlayer(true);
                        break;
                    }
                    case "closeLobby": {
                        this.gameCoordinatorConnection.getClientConnection().disconnectPlayer(true);
                        break;
                    }
                    case "playerUpdate": {
                        String[] namesArray = Arrays.copyOfRange(split, 1, split.length - 1);
                        this.gameCoordinatorConnection.getClientConnection().updatePlayers(namesArray, Integer.parseInt(split[split.length - 1]));
                        break;
                    }
                    case "startGame": {
                        this.stopThread();
                        if (this.clientState == ClientState.LOBBY_HOST) {
                            return;
                        }
                        this.gameCoordinatorConnection.getClientConnection().startGame(false);
                        ReadWriteHelper.writeSocketMessage(this.gameCoordinatorConnection.getClientConnection().getPlayer().getClient(), "startGame;");
                        break;
                    }
                }
            }
            catch (EOFException | SocketException e) {
                if (this.onlineLobbyFrame.isShown() && this.running) {
                    LogHandler.notifyException(e);
                    this.onlineLobbyFrame.showDialog("Connection error. Please connect again");
                    this.onlineLobbyFrame.goBack();
                    this.stopThread();
                }
                return;
            }
            catch (Exception e) {
                LogHandler.notifyException(e);
                if (this.onlineLobbyFrame.isShown() && this.running) {
                    this.onlineLobbyFrame.showDialog("Connection error. Please connect again");
                    this.onlineLobbyFrame.goBack();
                }
                this.stopThread();
            }
        }
    }

    public void setClientState(ClientState clientState) {
        this.clientState = clientState;
    }

    public void updateLobbyFrame(OnlineLobbyFrame onlineLobbyFrame) {
        this.onlineLobbyFrame = onlineLobbyFrame;
    }

    public boolean isRunning() {
        return this.running;
    }
}

