/*
 * Decompiled with CFR 0.152.
 */
package gameServer.ClientSide;

import game.utils.IniFileParser;
import game.utils.LogHandler;
import gameServer.ScoreBoard.ScoreBoardRecord;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import network.ClientConnection;
import network.ReadWriteHelper;

public class GameCoordinatorConnection {
    private Socket clientSocket;
    private static String gameCoordinatorAddress;
    private static int gameCoordinatorPort;
    private ClientConnection clientConnection;
    private ArrayList<ScoreBoardRecord> scoreBoardRecordList;

    public boolean connect() {
        gameCoordinatorAddress = IniFileParser.getInstance().getGameCoordinatorAddress();
        try {
            this.clientSocket = new Socket(gameCoordinatorAddress, gameCoordinatorPort);
            this.clientSocket.setSoTimeout(600000);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean connect(int connectTimeout) {
        gameCoordinatorAddress = IniFileParser.getInstance().getGameCoordinatorAddress();
        try {
            this.clientSocket = new Socket();
            this.clientSocket.connect(new InetSocketAddress(gameCoordinatorAddress, gameCoordinatorPort), connectTimeout);
            this.clientSocket.setSoTimeout(10000);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public Socket getClientSocket() {
        return this.clientSocket;
    }

    public void disconnect(boolean communicate) {
        try {
            if (this.clientSocket.isConnected() && communicate) {
                ReadWriteHelper.writeSocketMessage(this.clientSocket, "disconnect;");
            }
            this.clientSocket.close();
        }
        catch (SocketException socketException) {
        }
        catch (IOException e) {
            LogHandler.notifyException(e);
        }
    }

    public void setClientConnection(ClientConnection clientConnection) {
        this.clientConnection = clientConnection;
    }

    public ClientConnection getClientConnection() {
        return this.clientConnection;
    }

    public ArrayList<ScoreBoardRecord> getScoreBoardRecordList() {
        return this.scoreBoardRecordList;
    }

    public void setScoreBoardRecordList(ArrayList<ScoreBoardRecord> scoreBoardRecordList) {
        this.scoreBoardRecordList = scoreBoardRecordList;
    }

    static {
        gameCoordinatorPort = 1357;
    }
}

