/*
 * Decompiled with CFR 0.152.
 */
package gameServer;

import game.GameLogicException;
import game.utils.LogHandler;
import gameServer.Client;
import gameServer.ClientSide.LobbyListEntry;
import gameServer.ClientSide.LobbyUpdateRecord;
import gameServer.ClientState;
import gameServer.GameCoordinatorListener;
import gameServer.Lobby;
import gameServer.ScoreBoard.ScorePointStorage;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import menu.GameMode;
import network.ReadWriteHelper;
import network.SerializableNetworkObject;

public class GameCoordinator {
    private ArrayList<Client> clientList = new ArrayList();
    private int playerNumberCounter = 0;
    private HashMap<Integer, GameCoordinatorListener> gameCoordinatorListenerMap = new HashMap();
    private boolean isRunning = true;
    private static GameCoordinator singleton;
    private int lobbyCounter = 0;
    private HashMap<Integer, Lobby> lobbyMap = new HashMap();
    private ServerSocket serverSocket = null;

    public static GameCoordinator getInstance() {
        if (singleton == null) {
            singleton = new GameCoordinator();
        }
        return singleton;
    }

    public void startServer() throws IOException {
        if (this.isRunning) {
            this.stopServer();
        }
        this.serverSocket = new ServerSocket(1357);
        this.isRunning = true;
        while (this.isRunning) {
            try {
                Socket socket = this.serverSocket.accept();
                Client client = new Client(socket, this.playerNumberCounter++);
                this.clientList.add(client);
                GameCoordinatorListener gameCoordinatorListener = new GameCoordinatorListener(client, this);
                this.gameCoordinatorListenerMap.put(client.getPlayerNumber(), gameCoordinatorListener);
                gameCoordinatorListener.start();
                this.refreshLobbyListForClient(client);
            }
            catch (IOException iOException) {}
        }
    }

    public void stopServer() {
        this.isRunning = false;
        for (GameCoordinatorListener gameCoordinatorListener : this.gameCoordinatorListenerMap.values()) {
            gameCoordinatorListener.disconnectClient();
        }
        this.gameCoordinatorListenerMap = new HashMap();
        this.playerNumberCounter = 0;
        this.lobbyCounter = 0;
        this.clientList = new ArrayList();
        this.lobbyMap = new HashMap();
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                LogHandler.notifyException(e);
            }
        }
    }

    public void createLobby(Client client, GameMode gameMode, boolean easyMode, boolean treasureMode) throws IOException {
        int lobbyId = this.lobbyCounter++;
        this.lobbyMap.put(lobbyId, new Lobby(client, lobbyId, gameMode, easyMode, treasureMode));
        client.setClientState(ClientState.LOBBY_HOST);
        this.refreshLobbyList();
    }

    public Lobby joinLobby(Client client, int lobbyIdentifier) {
        if (!this.lobbyMap.containsKey(lobbyIdentifier)) {
            return null;
        }
        Lobby lobby = this.lobbyMap.get(lobbyIdentifier);
        if (lobby.getOtherPlayersThanHost().size() > 10) {
            return null;
        }
        lobby.addPlayer(client);
        client.setClientState(ClientState.LOBBY_CLIENT);
        return lobby;
    }

    public Lobby getLobbyByPlayer(Client client) {
        for (Lobby lobby : this.lobbyMap.values()) {
            if (!lobby.hasPlayer(client)) continue;
            return lobby;
        }
        throw new GameLogicException("Lobby for player not found. Client player number: " + client.getPlayerNumber());
    }

    public Lobby getLobbyByPlayerOrNull(Client client) {
        for (Lobby lobby : this.lobbyMap.values()) {
            if (!lobby.hasPlayer(client)) continue;
            return lobby;
        }
        return null;
    }

    public void closeLobby(Client client) throws IOException {
        Lobby lobby = this.getLobbyByPlayer(client);
        this.lobbyMap.remove(lobby.getLobbyId());
        this.refreshLobbyList();
    }

    public void refreshLobbyList() throws IOException {
        ArrayList<LobbyListEntry> lobbyListEntries = new ArrayList<LobbyListEntry>();
        for (Lobby lobby : this.lobbyMap.values()) {
            lobbyListEntries.add(new LobbyListEntry(lobby.getLobbyId(), lobby.getHost().getPlayerName() + "'s Game"));
        }
        for (Client client : this.clientList) {
            if (client.getClientState() != ClientState.ENTRANCE) continue;
            ReadWriteHelper.writeSocketObject(client.getSocket(), this.createLobbyUpdateNetworkObject(lobbyListEntries));
        }
    }

    public void refreshLobbyListForClient(Client client) throws IOException {
        ArrayList<LobbyListEntry> lobbyListEntries = new ArrayList<LobbyListEntry>();
        for (Lobby lobby : this.lobbyMap.values()) {
            lobbyListEntries.add(new LobbyListEntry(lobby.getLobbyId(), lobby.getHost().getPlayerName() + "'s Game"));
        }
        ReadWriteHelper.writeSocketObject(client.getSocket(), this.createLobbyUpdateNetworkObject(lobbyListEntries));
    }

    private SerializableNetworkObject createLobbyUpdateNetworkObject(ArrayList<LobbyListEntry> lobbyListEntries) {
        ScorePointStorage scorePointStorage = new ScorePointStorage();
        return new SerializableNetworkObject(new LobbyUpdateRecord(lobbyListEntries, scorePointStorage.getScoreBoardRecordList()));
    }
}

