/*
 * Decompiled with CFR 0.152.
 */
package gameServer;

import game.NetworkGameCoordinatorHostGame;
import game.ShutdownGameCoordinator;
import game.utils.IniFileParser;
import game.utils.LogHandler;
import gameServer.Client;
import gameServer.ClientSide.LobbyListEntry;
import gameServer.ClientSide.LobbyUpdateRecord;
import gameServer.ClientState;
import gameServer.GameCoordinator;
import gameServer.Lobby;
import gameServer.ScoreBoard.ScorePointStorage;
import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.SocketException;
import java.util.ArrayList;
import menu.GameMode;
import menu.GameSettings;
import network.Connection;
import network.ReadWriteHelper;
import network.SerializableNetworkObject;

public class GameCoordinatorListener
extends Thread {
    private Client client;
    private GameCoordinator gameCoordinator;
    private boolean running = true;

    public GameCoordinatorListener(Client client, GameCoordinator gameCoordinator) {
        this.client = client;
        this.gameCoordinator = gameCoordinator;
    }

    public void disconnectClient() {
        this.running = false;
        try {
            this.leaveLobby();
            this.client.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        block23: while (this.running) {
            try {
                String action;
                String[] split;
                String message;
                try {
                    message = ReadWriteHelper.readSocketMessage(this.client.getSocket());
                }
                catch (ClassCastException e) {
                    continue;
                }
                if (message == null || (split = message.split(";")).length <= 0) continue;
                block11 : switch (action = split[0]) {
                    case "createLobby": {
                        if (this.client.getClientState() != ClientState.ENTRANCE) {
                            return;
                        }
                        if (split.length < 2) {
                            throw new IndexOutOfBoundsException("second index for lobby not found in message");
                        }
                        this.client.setPlayerName(split[1]);
                        GameMode gameMode = new GameMode();
                        if (split.length > 4 && split[2].equals("0")) {
                            gameMode = new GameMode(Integer.parseInt(split[3]), Integer.parseInt(split[4]), split.length > 5 ? split[5] : null);
                        }
                        boolean isEasyMode = false;
                        boolean isTreasureMode = false;
                        if (split.length > 7) {
                            isEasyMode = split[6].equals("1");
                            isTreasureMode = split[7].equals("1");
                        }
                        this.gameCoordinator.createLobby(this.client, gameMode, isEasyMode, isTreasureMode);
                        break;
                    }
                    case "joinLobby": {
                        boolean success;
                        if (this.client.getClientState() != ClientState.ENTRANCE) {
                            return;
                        }
                        if (split.length < 3) {
                            throw new IndexOutOfBoundsException("second index for lobby not found in message");
                        }
                        int lobbyIdentifier = Integer.parseInt(split[1]);
                        this.client.setPlayerName(split[2]);
                        Lobby lobby = this.gameCoordinator.joinLobby(this.client, lobbyIdentifier);
                        boolean bl = success = lobby != null;
                        if (success) {
                            String playerNamesAsString = lobby.getPlayerNamesAsString();
                            ReadWriteHelper.writeSocketMessage(this.client.getSocket(), "joinLobbySuccess;1;" + lobbyIdentifier + ";" + playerNamesAsString + ";" + lobby.getPlayerNumberInLobby(this.client));
                            ArrayList<Client> otherPlayers = lobby.getOtherPlayers(this.client);
                            for (Client otherPlayer : otherPlayers) {
                                ReadWriteHelper.writeSocketMessage(otherPlayer.getSocket(), "playerUpdate;" + playerNamesAsString + ";" + lobby.getPlayerNumberInLobby(otherPlayer));
                            }
                            continue block23;
                        }
                        ReadWriteHelper.writeSocketMessage(this.client.getSocket(), "joinLobbySuccess;0;" + lobbyIdentifier + ";");
                        break;
                    }
                    case "leaveLobby": {
                        if (this.client.getClientState() != ClientState.LOBBY_CLIENT && this.client.getClientState() != ClientState.LOBBY_HOST) {
                            return;
                        }
                        boolean isLobbyClient = this.client.getClientState() == ClientState.LOBBY_CLIENT;
                        this.leaveLobby();
                        this.client.setClientState(ClientState.ENTRANCE);
                        if (!isLobbyClient) break;
                        this.gameCoordinator.refreshLobbyListForClient(this.client);
                        break;
                    }
                    case "startGame": {
                        this.running = false;
                        if (this.client.getClientState() != ClientState.LOBBY_HOST) {
                            this.client.setClientState(ClientState.IN_GAME);
                            return;
                        }
                        this.client.setClientState(ClientState.IN_GAME);
                        Lobby currentLobby = this.gameCoordinator.getLobbyByPlayer(this.client);
                        for (Client allPlayers : currentLobby.getAllPlayers()) {
                            ReadWriteHelper.writeSocketMessage(allPlayers.getSocket(), "startGame;");
                        }
                        int tries = 0;
                        while (!this.playerAreReadyToStart(currentLobby.getAllPlayers())) {
                            Thread.sleep(20L);
                            if (tries++ <= 500) continue;
                            this.disconnectClient();
                            break block11;
                        }
                        GameSettings gameSettings = new GameSettings();
                        gameSettings.setGameMode(currentLobby.getGameMode());
                        gameSettings.setEasyMode(currentLobby.isEasyMode());
                        gameSettings.setTreasureMode(currentLobby.isTreasureMode());
                        ShutdownGameCoordinator shutdownGameCoordinator = new ShutdownGameCoordinator();
                        Connection serverGameConnection = new Connection(currentLobby.getAllPlayers(), this.client, shutdownGameCoordinator);
                        NetworkGameCoordinatorHostGame networkGameCoordinatorHostGame = new NetworkGameCoordinatorHostGame(shutdownGameCoordinator);
                        networkGameCoordinatorHostGame.startGame(gameSettings, serverGameConnection.getServerLobbyConnection());
                        this.gameCoordinator.closeLobby(this.client);
                        break;
                    }
                    case "disconnect": {
                        this.disconnectClient();
                        break;
                    }
                    case "sendScore": {
                        IniFileParser iniFileParser = IniFileParser.getInstance();
                        if (split.length != 4 || !iniFileParser.isUploadOfflineScorePossible() || !split[1].equals(iniFileParser.getOfflineScoreSecret())) break;
                        ScorePointStorage scorePointStorage = new ScorePointStorage();
                        scorePointStorage.notifyScore(Integer.parseInt(split[3]), split[2]);
                        scorePointStorage.persist();
                        break;
                    }
                    case "getScoreBoard": {
                        ScorePointStorage scorePointStorage = new ScorePointStorage();
                        ReadWriteHelper.writeSocketObject(this.client.getSocket(), new SerializableNetworkObject(new LobbyUpdateRecord(new ArrayList<LobbyListEntry>(), scorePointStorage.getScoreBoardRecordList())));
                        break;
                    }
                }
            }
            catch (EOFException | StreamCorruptedException | SocketException e) {
                this.disconnectClient();
            }
            catch (Exception e) {
                LogHandler.notifyException(e);
                this.disconnectClient();
            }
        }
    }

    private boolean playerAreReadyToStart(ArrayList<Client> allPlayers) {
        for (Client client : allPlayers) {
            if (client.getClientState() == ClientState.IN_GAME) continue;
            return false;
        }
        return true;
    }

    private void leaveLobby() throws IOException {
        if (this.client.getClientState() == ClientState.LOBBY_HOST) {
            ArrayList<Client> otherPlayers = this.gameCoordinator.getLobbyByPlayer(this.client).getOtherPlayersThanHost();
            for (Client otherPlayer : otherPlayers) {
                ReadWriteHelper.writeSocketMessage(otherPlayer.getSocket(), "closeLobby;");
            }
            this.gameCoordinator.closeLobby(this.client);
        } else if (this.client.getClientState() == ClientState.LOBBY_CLIENT) {
            Lobby lobby = this.gameCoordinator.getLobbyByPlayerOrNull(this.client);
            if (lobby == null) {
                return;
            }
            lobby.removePlayer(this.client);
            ArrayList<Client> otherPlayers = lobby.getOtherPlayers(this.client);
            for (Client otherPlayer : otherPlayers) {
                ReadWriteHelper.writeSocketMessage(otherPlayer.getSocket(), "playerUpdate;" + lobby.getPlayerNamesAsString() + ";" + lobby.getPlayerNumberInLobby(otherPlayer));
            }
        }
    }
}

