/*
 * Decompiled with CFR 0.152.
 */
package gameServer;

import game.utils.IniFileParser;
import game.utils.LogHandler;
import gameServer.GameCoordinator;

public class GameServer {
    public static void main(String[] args) {
        GameCoordinator gameCoordinator = null;
        try {
            IniFileParser.initializeIniFile(false);
            gameCoordinator = GameCoordinator.getInstance();
            Runtime.getRuntime().addShutdownHook(new Thread(gameCoordinator::stopServer));
            gameCoordinator.startServer();
        }
        catch (Exception e) {
            LogHandler.notifyException(e);
            if (gameCoordinator != null) {
                gameCoordinator.stopServer();
            }
            try {
                Thread.sleep(600000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return;
            }
            GameServer.main(args);
        }
    }
}

