/*
 * Decompiled with CFR 0.152.
 */
package gameServer;

import gameServer.Client;
import gameServer.ClientState;
import java.util.ArrayList;
import menu.GameMode;

public class Lobby {
    private int lobbyId;
    private Client host;
    private GameMode gameMode;
    private ArrayList<Client> otherPlayers = new ArrayList();
    private boolean easyMode;
    private boolean treasureMode;

    public Lobby(Client host, int lobbyId, GameMode gameMode, boolean easyMode, boolean treasureMode) {
        this.host = host;
        this.lobbyId = lobbyId;
        this.gameMode = gameMode;
        this.treasureMode = treasureMode;
        this.easyMode = easyMode;
    }

    public void addPlayer(Client player) {
        this.otherPlayers.add(player);
    }

    public void removePlayer(Client player) {
        this.otherPlayers.remove(player);
        player.setClientState(ClientState.ENTRANCE);
    }

    public int getLobbyId() {
        return this.lobbyId;
    }

    public Client getHost() {
        return this.host;
    }

    public ArrayList<Client> getOtherPlayersThanHost() {
        return this.otherPlayers;
    }

    public boolean hasPlayer(Client client) {
        if (this.host.equals(client)) {
            return true;
        }
        for (Client iterateClient : this.otherPlayers) {
            if (!iterateClient.equals(client)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Client> getOtherPlayers(Client client) {
        ArrayList<Client> otherPlayers = new ArrayList<Client>();
        if (!this.host.equals(client)) {
            otherPlayers.add(this.host);
        }
        for (Client iterateClient : this.otherPlayers) {
            if (iterateClient.equals(client)) continue;
            otherPlayers.add(iterateClient);
        }
        return otherPlayers;
    }

    public String getPlayerNamesAsString() {
        return String.join((CharSequence)";", this.getPlayerNamesFromPlayerList());
    }

    private String[] getPlayerNamesFromPlayerList() {
        String[] playerNameArray = new String[this.otherPlayers.size() + 1];
        int i = 0;
        playerNameArray[i++] = this.host.getPlayerName();
        for (Client iterateClient : this.otherPlayers) {
            if (!iterateClient.isConnected()) continue;
            playerNameArray[i++] = iterateClient.getPlayerName();
        }
        return playerNameArray;
    }

    public ArrayList<Client> getAllPlayers() {
        ArrayList<Client> allPlayers = new ArrayList<Client>();
        allPlayers.add(this.host);
        allPlayers.addAll(this.otherPlayers);
        return allPlayers;
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public String getPlayerNumberInLobby(Client player) {
        ArrayList<Client> allPlayers = this.getAllPlayers();
        int i = 0;
        for (Client client : allPlayers) {
            if (client.equals(player)) {
                return "" + i;
            }
            ++i;
        }
        return "-1";
    }

    public boolean isEasyMode() {
        return this.easyMode;
    }

    public boolean isTreasureMode() {
        return this.treasureMode;
    }
}

