/*
 * Decompiled with CFR 0.152.
 */
package gameServer.ScoreBoard;

import game.utils.LogHandler;
import gameServer.ScoreBoard.ScoreBoardRecord;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Semaphore;

public class ScorePointStorage {
    private final String scoreFileName = "./highscore.txt";
    private ArrayList<ScoreBoardRecord> scoreBoardRecordList = new ArrayList();
    private static Semaphore fileLock = new Semaphore(1);
    private int highScoreLength = 25;

    public ScorePointStorage() {
        FileInputStream fis;
        try {
            fileLock.acquire();
        }
        catch (InterruptedException e) {
            LogHandler.notifyException(e);
            return;
        }
        try {
            fis = new FileInputStream("./highscore.txt");
        }
        catch (FileNotFoundException e) {
            fileLock.release();
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
        try {
            String line = reader.readLine();
            while (line != null) {
                String[] split = line.split(": ");
                if (split.length > 1) {
                    this.scoreBoardRecordList.add(new ScoreBoardRecord(split[0], Integer.parseInt(split[1])));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            LogHandler.notifyException(e);
            fileLock.release();
            return;
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            LogHandler.notifyException(e);
            fileLock.release();
        }
        Collections.sort(this.scoreBoardRecordList);
        fileLock.release();
    }

    public void notifyScore(int score, String playerName) {
        for (ScoreBoardRecord scoreBoardRecord : this.scoreBoardRecordList) {
            if (!scoreBoardRecord.getPlayerName().equals(playerName)) continue;
            if (score > scoreBoardRecord.getScore()) {
                scoreBoardRecord.setScore(score);
            }
            return;
        }
        this.scoreBoardRecordList.add(new ScoreBoardRecord(playerName, score));
    }

    public void persist() {
        FileOutputStream fileOutputStream;
        try {
            fileLock.acquire();
        }
        catch (InterruptedException e) {
            LogHandler.notifyException(e);
            return;
        }
        try {
            fileOutputStream = new FileOutputStream("./highscore.txt");
        }
        catch (FileNotFoundException e) {
            LogHandler.notifyException(e);
            fileLock.release();
            return;
        }
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        Collections.sort(this.scoreBoardRecordList);
        for (int i = 0; i < this.highScoreLength && i < this.scoreBoardRecordList.size(); ++i) {
            printWriter.println(this.scoreBoardRecordList.get(i).toString());
        }
        printWriter.close();
        fileLock.release();
    }

    public ArrayList<ScoreBoardRecord> getScoreBoardRecordList() {
        return this.scoreBoardRecordList;
    }
}

