/*
 * Decompiled with CFR 0.152.
 */
package labyrinthField;

import java.io.Serializable;
import java.util.ArrayList;
import labyrinthField.AngleDistanceCalculator;
import labyrinthField.ConnectFormDrawHelper;
import labyrinthField.HalfParableDrawHelper;
import labyrinthField.LineDrawHelper;
import labyrinthField.Point;
import labyrinthField.PointValidCheckable;
import labyrinthField.Treasure;
import labyrinthField.TreasureType;
import labyrinthField.Vector;
import labyrinthField.WaveFormDrawHelper;
import labyrinthField.Way;
import rendering.TextMatrixCreator;

public class Field
implements PointValidCheckable,
Serializable {
    private transient boolean[][] wayPointMatrix;
    private transient boolean[][] flatWayPointMatrix;
    private transient boolean[][] notFreePointMatrix;
    private ArrayList<Way> wayCollection;
    private Point startPoint;
    private Way goal;
    private int fieldWidth = 1820;
    private int fieldHeight = 920;
    private int scaleFactor = 1;
    private final int iterations = 200;
    private int spaceBetweenWays = 10;
    private int minWayLength = 25;
    private int maxWayLength = 75;
    private boolean isEasyMode = false;
    public static final int courserOuterSize = 8;
    public static final int courserInnerSize = 3;
    private String blockingName;
    private int distanceToGoal;
    private ArrayList<Treasure> treasureList = new ArrayList();

    public Field() {
        this.generate(null, 0);
    }

    public Field(int width, int height, int scaleFactor, String labyrinthText, boolean isEasyMode, int numberOfTreasures) {
        this.fieldWidth = width * scaleFactor;
        this.fieldHeight = height * scaleFactor;
        this.scaleFactor = scaleFactor;
        this.spaceBetweenWays = 10 * scaleFactor;
        this.minWayLength = 15 * scaleFactor;
        this.maxWayLength = 75 * scaleFactor;
        this.isEasyMode = isEasyMode;
        this.generate(labyrinthText, numberOfTreasures);
    }

    public void generate(String blockingName, int numberOfTreasures) {
        int i;
        this.reset();
        if (blockingName != null && blockingName.length() > 0) {
            this.blockingName = blockingName;
            this.blockName(blockingName);
        }
        this.startPoint = new Point(this.fieldWidth / 2, this.fieldHeight - 1);
        ArrayList<Way> nextWaysList = new ArrayList<Way>();
        ArrayList<Way> allWays = new ArrayList<Way>();
        nextWaysList.add(this.generateInitialWay(this.startPoint));
        ArrayList delayList = new ArrayList();
        for (i = 0; i < 200; ++i) {
            ArrayList currentWaysList = (ArrayList)nextWaysList.clone();
            nextWaysList = new ArrayList();
            while (delayList.size() > 25) {
                int randomIndex = (int)(Math.random() * 25.0);
                currentWaysList.add(delayList.get(randomIndex));
                delayList.remove(randomIndex);
            }
            if (currentWaysList.size() == 0) {
                currentWaysList = delayList;
                delayList = new ArrayList();
            }
            int numberOfPoints = currentWaysList.size();
            int pointCounter = 0;
            for (Way way : currentWaysList) {
                if (++pointCounter == numberOfPoints && nextWaysList.isEmpty()) {
                    this.generateAndAddWay(way, nextWaysList);
                    this.generateAndAddWay(way, nextWaysList);
                    this.addGoalIfDeadEnd(nextWaysList, way, allWays);
                    continue;
                }
                double random = Math.random();
                if (random < 0.6) {
                    delayList.add(way);
                    continue;
                }
                random = Math.random();
                if (random < 0.3) {
                    this.generateAndAddWay(way, nextWaysList);
                    this.generateAndAddWay(way, nextWaysList);
                    this.generateAndAddWay(way, nextWaysList);
                } else if (random < 0.6) {
                    this.generateAndAddWay(way, nextWaysList);
                    this.generateAndAddWay(way, nextWaysList);
                } else if (random < 1.0) {
                    this.generateAndAddWay(way, nextWaysList);
                }
                this.addGoalIfDeadEnd(nextWaysList, way, allWays);
            }
        }
        if (this.goal == null) {
            this.generate(blockingName, numberOfTreasures);
            return;
        }
        allWays.remove(this.goal);
        for (i = 0; i < numberOfTreasures; ++i) {
            int randomTreasureIndex = (int)(Math.random() * (double)allWays.size());
            Treasure treasure = new Treasure(i, ((Way)allWays.get(randomTreasureIndex)).getEndPoint(), this.generateTreasureType());
            this.treasureList.add(treasure);
            allWays.remove(randomTreasureIndex);
        }
    }

    private TreasureType generateTreasureType() {
        double random = Math.random();
        if (random < 0.3) {
            return TreasureType.SPEED_SELF;
        }
        if (random < 0.4) {
            return TreasureType.SLOW_SELF;
        }
        if (random < 0.65) {
            return TreasureType.SLOW_FIRST;
        }
        if (random < 0.8) {
            return TreasureType.SLOW_OTHERS;
        }
        if (random < 0.9) {
            return TreasureType.CHANGE;
        }
        if (random < 1.0) {
            return TreasureType.SHOW_WAY_TO_GOAL;
        }
        return TreasureType.INVERT;
    }

    private void addGoalIfDeadEnd(ArrayList<Way> nextWaysList, Way way, ArrayList<Way> allWays) {
        allWays.add(way);
        if (nextWaysList.isEmpty() && (this.goal == null || this.distanceToGoal < this.getDistanceToWay(way) && Math.random() < 0.17)) {
            this.goal = way;
            this.distanceToGoal = this.getDistanceToGoal();
        }
    }

    public boolean[][] getWayPointMatrix() {
        if (this.wayPointMatrix == null) {
            this.recreatePoints();
        }
        return this.wayPointMatrix;
    }

    @Override
    public int getWidth() {
        return this.fieldWidth;
    }

    public int getWidthWithoutScaleFactor() {
        return this.fieldWidth / this.scaleFactor;
    }

    @Override
    public int getHeight() {
        return this.fieldHeight;
    }

    public int getHeightWithoutScaleFactor() {
        return this.fieldHeight / this.scaleFactor;
    }

    public boolean[][] getFlatWayPointMatrix() {
        if (this.wayPointMatrix == null) {
            this.recreatePoints();
        }
        if (this.flatWayPointMatrix != null) {
            return this.flatWayPointMatrix;
        }
        this.flatWayPointMatrix = new boolean[this.fieldWidth][this.fieldHeight];
        int width = this.scaleFactor;
        for (int x = 0; x < this.fieldWidth; ++x) {
            for (int y = 0; y < this.fieldHeight; ++y) {
                if (!this.wayPointMatrix[x][y]) continue;
                for (int xAround = -width; xAround <= width; ++xAround) {
                    for (int yAround = -width; yAround <= width; ++yAround) {
                        if (xAround * xAround + yAround * yAround > width * width + 1) continue;
                        int newX = x + xAround;
                        int newY = y + yAround;
                        if (newX < 0 || newX >= this.fieldWidth || newY < 0 || newY >= this.fieldHeight) continue;
                        this.flatWayPointMatrix[newX][newY] = true;
                    }
                }
            }
        }
        return this.flatWayPointMatrix;
    }

    @Override
    public boolean pointIsValid(Point point) {
        int x = point.getxPosition();
        int y = point.getyPosition();
        if (x < 0 || x >= this.fieldWidth || y < 0 || y >= this.fieldHeight) {
            return false;
        }
        return !this.notFreePointMatrix[x][y];
    }

    public Point getStartPoint() {
        return this.startPoint;
    }

    public Point getGoal() {
        return this.goal.getEndPoint();
    }

    public Way getGoalWay() {
        return this.goal;
    }

    public Way getFirstWay() {
        return this.wayCollection.get(0);
    }

    private Way generateWay(Way previousWay) {
        ConnectFormDrawHelper connectForm = this.getConnectForm();
        int limit = 100;
        int limitCount = 0;
        Way way = null;
        double minAngle = 0.5410520681182421;
        if (previousWay.getNextWayList().size() == 0) {
            minAngle *= 2.0;
        }
        double previousWayAngle = previousWay.getRadAngle(this.scaleFactor, 0, true);
        while (way == null && limitCount < limit) {
            double angle;
            double length = (double)(this.minWayLength + 2) + Math.random() * (double)(this.maxWayLength - this.minWayLength);
            double d = angle = this.isEasyMode ? (double)((int)(Math.random() * 4.0) * 90) : Math.random() * 360.0;
            if (Math.random() > 0.4 && AngleDistanceCalculator.getDistanceBetweenRadAngles(previousWay.getRadAngle(this.scaleFactor), angle) < 1.0471975511965976) {
                ++limitCount;
                continue;
            }
            Vector vector = new Vector(angle);
            way = connectForm.createWay(previousWay, vector, (double)this.minWayLength, length, (PointValidCheckable)this);
            if (!this.isEasyMode && way != null) {
                double angle1 = previousWayAngle;
                double angle2 = way.getRadAngle(this.scaleFactor);
                double currentDistance = AngleDistanceCalculator.getDistanceBetweenRadAngles(angle1, angle2);
                if (currentDistance < minAngle) {
                    way = null;
                    ++limitCount;
                    continue;
                }
                angle2 = way.getRadAngleShort(this.scaleFactor);
                if (AngleDistanceCalculator.getDistanceBetweenRadAngles(angle1, angle2) < minAngle) {
                    way = null;
                    ++limitCount;
                    continue;
                }
                for (Way nextWay : previousWay.getNextWayList()) {
                    angle1 = nextWay.getRadAngle(this.scaleFactor);
                    currentDistance = AngleDistanceCalculator.getDistanceBetweenRadAngles(angle1, angle2 = way.getRadAngle(this.scaleFactor));
                    if (currentDistance < minAngle) {
                        way = null;
                        break;
                    }
                    angle2 = way.getRadAngleShort(this.scaleFactor);
                    if (!(AngleDistanceCalculator.getDistanceBetweenRadAngles(angle1, angle2) < minAngle)) continue;
                    way = null;
                    break;
                }
            }
            ++limitCount;
        }
        if (way == null) {
            return null;
        }
        this.wayCollection.add(way);
        this.applyPointsToField(way.getPointCollection());
        return way;
    }

    private Way generateInitialWay(Point startPoint) {
        ConnectFormDrawHelper connectForm = this.getConnectForm();
        double length = (double)(this.minWayLength + 2) + Math.random() * (double)(this.maxWayLength - this.minWayLength);
        double angle = this.isEasyMode ? 270.0 : 225.0 + Math.random() * 90.0;
        Vector vector = new Vector(angle);
        Way way = connectForm.createWay(startPoint, vector, (double)this.minWayLength, length, (PointValidCheckable)this);
        this.wayCollection.add(way);
        this.applyPointsToField(way.getPointCollection());
        return way;
    }

    private ConnectFormDrawHelper getConnectForm() {
        if (this.isEasyMode) {
            return new LineDrawHelper();
        }
        double random = Math.random();
        if (random < 0.35) {
            return new WaveFormDrawHelper();
        }
        if (random < 0.7) {
            return new HalfParableDrawHelper();
        }
        return new LineDrawHelper();
    }

    private void applyPointsToField(ArrayList<Point> pointCollection) {
        for (Point point : pointCollection) {
            int x = point.getxPosition();
            int y = point.getyPosition();
            this.wayPointMatrix[x][y] = true;
            for (int xAround = -this.spaceBetweenWays; xAround <= this.spaceBetweenWays; ++xAround) {
                for (int yAround = -this.spaceBetweenWays; yAround <= this.spaceBetweenWays; ++yAround) {
                    if (xAround * xAround + yAround * yAround > this.spaceBetweenWays * this.spaceBetweenWays) continue;
                    int newX = x + xAround;
                    int newY = y + yAround;
                    if (newX < 0 || newX >= this.fieldWidth || newY < 0 || newY >= this.fieldHeight) continue;
                    this.notFreePointMatrix[newX][newY] = true;
                }
            }
        }
    }

    private void generateAndAddWay(Way previousWay, ArrayList<Way> nextWaysList) {
        Way way = this.generateWay(previousWay);
        if (way != null) {
            nextWaysList.add(way);
            previousWay.addNextWay(way);
        }
    }

    private void reset() {
        this.wayPointMatrix = new boolean[this.fieldWidth][this.fieldHeight];
        this.notFreePointMatrix = new boolean[this.fieldWidth][this.fieldHeight];
        this.wayCollection = new ArrayList();
        this.flatWayPointMatrix = null;
    }

    public int getDistanceToGoal() {
        return this.getDistanceToWay(this.goal);
    }

    public int getDistanceToWay(Way currentWay) {
        int distance = 0;
        while (currentWay.getStartPoint().getDistance(this.startPoint) > 1.0) {
            distance += currentWay.getPointCollection().size() - 1;
            currentWay = currentWay.getPreviousWay();
        }
        return (distance += currentWay.getPointCollection().size()) - 1;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public ArrayList<Way> getWayCollection() {
        return this.wayCollection;
    }

    public ArrayList<Treasure> getTreasureList() {
        return this.treasureList;
    }

    public void recreatePoints() {
        ArrayList<Point> allPoints = new ArrayList<Point>();
        for (Way way : this.wayCollection) {
            allPoints.addAll(way.getPointCollection());
        }
        this.wayPointMatrix = new boolean[this.fieldWidth][this.fieldHeight];
        this.notFreePointMatrix = new boolean[this.fieldWidth][this.fieldHeight];
        if (this.blockingName != null) {
            this.blockName(this.blockingName);
        }
        this.applyPointsToField(allPoints);
    }

    private void blockName(String blockingName) {
        TextMatrixCreator textMatrixCreator = new TextMatrixCreator(blockingName, this.fieldHeight, this.scaleFactor);
        this.notFreePointMatrix = textMatrixCreator.getTextMatrix();
        this.fieldWidth = textMatrixCreator.getWidth();
        this.wayPointMatrix = new boolean[this.fieldWidth][this.fieldHeight];
        boolean[][] fillOuterMatrix = new boolean[this.fieldWidth][this.fieldHeight];
        ArrayList<Point> aPL = new ArrayList<Point>();
        aPL.add(new Point(0, 0));
        fillOuterMatrix[0][0] = true;
        while (aPL.size() > 0) {
            ArrayList<Point> newAPL = new ArrayList<Point>();
            for (Point point : aPL) {
                int x = point.getxPosition() - 1;
                int y = point.getyPosition();
                if (point.getxPosition() > 0 && !this.notFreePointMatrix[x][y] && !fillOuterMatrix[x][y]) {
                    fillOuterMatrix[x][y] = true;
                    newAPL.add(new Point(x, y));
                }
                x = point.getxPosition() + 1;
                if (point.getxPosition() < this.fieldWidth - 1 && !this.notFreePointMatrix[x][y] && !fillOuterMatrix[x][y]) {
                    fillOuterMatrix[x][y] = true;
                    newAPL.add(new Point(x, y));
                }
                x = point.getxPosition();
                y = point.getyPosition() - 1;
                if (point.getyPosition() > 0 && !this.notFreePointMatrix[x][y] && !fillOuterMatrix[x][y]) {
                    fillOuterMatrix[x][y] = true;
                    newAPL.add(new Point(x, y));
                }
                y = point.getyPosition() + 1;
                if (point.getyPosition() >= this.fieldHeight - 1 || this.notFreePointMatrix[x][y] || fillOuterMatrix[x][y]) continue;
                fillOuterMatrix[x][y] = true;
                newAPL.add(new Point(x, y));
            }
            aPL = newAPL;
        }
        for (int x = 0; x < this.fieldWidth; ++x) {
            for (int y = 0; y < this.fieldHeight; ++y) {
                if (this.notFreePointMatrix[x][y] || fillOuterMatrix[x][y]) continue;
                if (Math.random() > 0.975) {
                    this.wayPointMatrix[x][y] = true;
                }
                this.notFreePointMatrix[x][y] = true;
            }
        }
    }
}

