/*
 * Decompiled with CFR 0.152.
 */
package labyrinthField;

import java.io.Serializable;
import java.util.ArrayList;
import labyrinthField.ConnectFormDrawHelper;
import labyrinthField.Point;
import labyrinthField.PointValidCheckable;
import labyrinthField.Vector;
import labyrinthField.Way;

public class HalfParableDrawHelper
implements ConnectFormDrawHelper,
Serializable {
    @Override
    public Way createWay(Way previousWay, Vector vector, double startRange, double endRange, PointValidCheckable field) {
        ArrayList<Point> pointCollection = this.getPointsInRange(previousWay.getEndPoint(), vector, startRange, endRange, field);
        if (pointCollection.isEmpty()) {
            return null;
        }
        return new Way(pointCollection, this, previousWay);
    }

    @Override
    public Way createWay(Point startPoint, Vector vector, double startRange, double endRange, PointValidCheckable field) {
        ArrayList<Point> pointCollection = this.getPointsInRange(startPoint, vector, startRange, endRange, field);
        if (pointCollection.isEmpty()) {
            return null;
        }
        return new Way(pointCollection, this, null);
    }

    private ArrayList<Point> getPointsInRange(Point fromPoint, Vector vector, double startRange, double endRange, PointValidCheckable field) {
        Vector functionVector = new Vector(2.0, 4.0);
        double functionVectorLength = functionVector.getLength();
        double scaleFactor = endRange / functionVectorLength;
        double rotationAngle = vector.getRadAngle() - functionVector.getRadAngle();
        double cosRotation = Math.cos(rotationAngle);
        double sinRotation = Math.sin(rotationAngle);
        int startPointX = fromPoint.getxPosition();
        int startPointY = fromPoint.getyPosition();
        double alpha = functionVector.getRadAngle();
        double cos2Alpha = Math.cos(alpha * 2.0);
        double sin2Alpha = Math.sin(alpha * 2.0);
        boolean doMirror = Math.random() > 0.33;
        double beta = (functionVector.getRadAngle() + 1.5707963267948966) % (Math.PI * 2);
        double cos2beta = Math.cos(beta * 2.0);
        double sin2beta = Math.sin(beta * 2.0);
        boolean doMirror2 = Math.random() > 0.66;
        int lastX = -1;
        int lastY = -1;
        double numberOfPointsFactor = 4.0;
        ArrayList<Point> pointList = new ArrayList<Point>();
        int numberOfDataPoints = (int)(endRange / functionVectorLength * functionVector.getX() * numberOfPointsFactor) + 1;
        for (int i = 0; i < numberOfDataPoints; ++i) {
            double newYValue;
            double newXValue;
            double rawXvalue = functionVector.getX() * (double)i / (double)(numberOfDataPoints - 1);
            rawXvalue /= Math.sqrt(Math.max(rawXvalue, 0.25)) / Math.sqrt(2.0);
            double xValue = rawXvalue - functionVector.getX() / 2.0;
            double yValue = rawXvalue * rawXvalue - functionVector.getY() / 2.0;
            if (doMirror) {
                newXValue = xValue * cos2Alpha + yValue * sin2Alpha;
                newYValue = -yValue * cos2Alpha + xValue * sin2Alpha;
                xValue = newXValue;
                yValue = newYValue;
            } else if (doMirror2) {
                newXValue = xValue * cos2beta + yValue * sin2beta;
                newYValue = -yValue * cos2beta + xValue * sin2beta;
                xValue = newXValue;
                yValue = newYValue;
            }
            newXValue = xValue * cosRotation - yValue * sinRotation;
            newYValue = yValue * cosRotation + xValue * sinRotation;
            xValue = newXValue + vector.getX() * functionVectorLength / 2.0;
            yValue = newYValue + vector.getY() * functionVectorLength / 2.0;
            Point point = new Point(startPointX + (int)(xValue *= scaleFactor), startPointY + (int)(yValue *= scaleFactor));
            Vector pointVector = new Vector(xValue, yValue);
            if (lastX == point.getxPosition() && lastY == point.getyPosition()) continue;
            lastX = point.getxPosition();
            lastY = point.getyPosition();
            if (point.getxPosition() < 0 || point.getxPosition() >= field.getWidth() || point.getyPosition() < 0 || point.getyPosition() >= field.getHeight()) {
                return new ArrayList<Point>();
            }
            if (pointVector.getLength() >= startRange - 1.0 && !field.pointIsValid(point)) {
                return new ArrayList<Point>();
            }
            pointList.add(point);
        }
        if (!doMirror && doMirror2) {
            ArrayList<Point> newPointList = new ArrayList<Point>();
            for (int i = pointList.size() - 1; i >= 0; --i) {
                newPointList.add(pointList.get(i));
            }
            pointList = newPointList;
        }
        return pointList;
    }
}

