/*
 * Decompiled with CFR 0.152.
 */
package labyrinthField;

import java.io.Serializable;
import java.util.ArrayList;
import labyrinthField.ConnectFormDrawHelper;
import labyrinthField.Point;
import labyrinthField.PointValidCheckable;
import labyrinthField.Vector;
import labyrinthField.Way;

public class LineDrawHelper
implements ConnectFormDrawHelper,
Serializable {
    @Override
    public Way createWay(Way previousWay, Vector vector, double startRange, double endRange, PointValidCheckable field) {
        ArrayList<Point> pointCollection = this.getPointsInRange(previousWay.getEndPoint(), vector, startRange, endRange, field);
        if (pointCollection.isEmpty()) {
            return null;
        }
        return new Way(pointCollection, this, previousWay);
    }

    @Override
    public Way createWay(Point startPoint, Vector vector, double startRange, double endRange, PointValidCheckable field) {
        ArrayList<Point> pointCollection = this.getPointsInRange(startPoint, vector, startRange, endRange, field);
        if (pointCollection.isEmpty()) {
            return null;
        }
        return new Way(pointCollection, this, null);
    }

    private ArrayList<Point> getPointsInRange(Point fromPoint, Vector vector, double startRange, double endRange, PointValidCheckable field) {
        ArrayList<Point> pointList = new ArrayList<Point>();
        double x = vector.getX();
        double y = vector.getY();
        int startPointX = fromPoint.getxPosition();
        int startPointY = fromPoint.getyPosition();
        if (Math.abs(x) > Math.abs(y)) {
            int startX = (int)(x * startRange);
            int endX = (int)(x * endRange);
            int xDiff = Math.abs(startX - endX);
            for (int xCounter = 0; xCounter <= xDiff; ++xCounter) {
                int currentY;
                int currentX = startX + (startX < endX ? xCounter : -xCounter);
                Point point = new Point(startPointX + currentX, startPointY + (currentY = (int)(y * (double)currentX)));
                if (!field.pointIsValid(point)) {
                    return new ArrayList<Point>();
                }
                pointList.add(point);
            }
            ArrayList<Point> pointListBefore = new ArrayList<Point>();
            int minX = Math.abs(startX);
            for (int xCounter = 0; xCounter < minX; ++xCounter) {
                int currentX = startX < endX ? xCounter : -xCounter;
                int currentY = (int)(y * (double)currentX);
                Point point = new Point(startPointX + currentX, startPointY + currentY);
                pointListBefore.add(point);
            }
            pointListBefore.addAll(pointList);
            return pointListBefore;
        }
        int startY = (int)(y * startRange);
        int endY = (int)(y * endRange);
        int yDiff = Math.abs(startY - endY);
        for (int yCounter = 0; yCounter <= yDiff; ++yCounter) {
            int currentY = startY + (startY < endY ? yCounter : -yCounter);
            int currentX = (int)(x * (double)currentY);
            Point point = new Point(startPointX + currentX, startPointY + currentY);
            if (!field.pointIsValid(point)) {
                return new ArrayList<Point>();
            }
            pointList.add(point);
        }
        ArrayList<Point> pointListBefore = new ArrayList<Point>();
        int minY = Math.abs(startY);
        for (int yCounter = 0; yCounter < minY; ++yCounter) {
            int currentY = startY < endY ? yCounter : -yCounter;
            int currentX = (int)(x * (double)currentY);
            Point point = new Point(startPointX + currentX, startPointY + currentY);
            pointListBefore.add(point);
        }
        pointListBefore.addAll(pointList);
        return pointListBefore;
    }
}

