/*
 * Decompiled with CFR 0.152.
 */
package labyrinthField;

import java.io.Serializable;
import java.util.ArrayList;
import labyrinthField.ConnectFormDrawHelper;
import labyrinthField.Point;
import labyrinthField.Vector;

public class Way
implements Serializable {
    private ConnectFormDrawHelper connectForm;
    private ArrayList<Point> pointCollection;
    private Way previousWay;
    private ArrayList<Way> nextWayList = new ArrayList();
    private static int idCounter = 0;
    private int id;

    public Way(ArrayList<Point> pointCollection, ConnectFormDrawHelper connectForm, Way previousWay) {
        this.connectForm = connectForm;
        this.pointCollection = pointCollection;
        this.previousWay = previousWay;
        this.id = idCounter++;
    }

    public Way(Way shortenedWay, int currentWayPointIndex, boolean goingBackwards) {
        this.connectForm = shortenedWay.connectForm;
        this.previousWay = shortenedWay.previousWay;
        this.nextWayList = shortenedWay.nextWayList;
        this.id = shortenedWay.id;
        int numberOfPoints = shortenedWay.pointCollection.size();
        this.pointCollection = numberOfPoints == 0 ? new ArrayList() : new ArrayList<Point>(shortenedWay.pointCollection.subList(goingBackwards ? 0 : Math.max(0, numberOfPoints - 1 - currentWayPointIndex), goingBackwards ? currentWayPointIndex : numberOfPoints - 1));
    }

    public void addNextWay(Way way) {
        this.nextWayList.add(way);
    }

    public Point getStartPoint() {
        return this.pointCollection.get(0);
    }

    public Point getEndPoint() {
        return this.pointCollection.get(this.pointCollection.size() - 1);
    }

    public double getRadAngle(int scaleFactor) {
        return this.getRadAngle(scaleFactor, 0, false);
    }

    public double getRadAngle(int scaleFactor, int offset, boolean reverse) {
        Point endPoint;
        Point startPoint;
        int endIndex;
        int numberOfPoints = this.pointCollection.size();
        int lastIndex = numberOfPoints - 1;
        int step = numberOfPoints / 3;
        int goodStep = 12 * scaleFactor;
        if ((offset *= scaleFactor) != 0 && offset != lastIndex) {
            step = numberOfPoints / 5;
            goodStep = 6 * scaleFactor;
        }
        if (step < goodStep && (step = goodStep) > lastIndex) {
            step = lastIndex;
        }
        if ((endIndex = offset + step) > lastIndex) {
            endIndex = lastIndex;
        }
        offset = endIndex - step;
        if (reverse) {
            startPoint = this.pointCollection.get(lastIndex - offset);
            endPoint = this.pointCollection.get(lastIndex - endIndex);
        } else {
            startPoint = this.pointCollection.get(offset);
            endPoint = this.pointCollection.get(endIndex);
        }
        Vector v = new Vector(endPoint.getxPosition() - startPoint.getxPosition(), endPoint.getyPosition() - startPoint.getyPosition());
        return v.getRadAngle();
    }

    public double getRadAngleShort(int scaleFactor) {
        int step = 3 * scaleFactor;
        Point startPoint = this.pointCollection.get(0);
        Point endPoint = this.pointCollection.get(step);
        Vector v = new Vector(endPoint.getxPosition() - startPoint.getxPosition(), endPoint.getyPosition() - startPoint.getyPosition());
        return v.getRadAngle();
    }

    public ConnectFormDrawHelper getConnectForm() {
        return this.connectForm;
    }

    public ArrayList<Point> getPointCollection() {
        return this.pointCollection;
    }

    public Way getPreviousWay() {
        return this.previousWay;
    }

    public ArrayList<Way> getNextWayList() {
        return this.nextWayList;
    }

    public int getId() {
        return this.id;
    }

    public boolean hasPoint(Point checkPoint) {
        for (Point currentPoint : this.pointCollection) {
            if (!currentPoint.equals(checkPoint)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Way> getAllWaysCrossing() {
        ArrayList allWayList = (ArrayList)this.nextWayList.clone();
        allWayList.add(this);
        if (this.previousWay != null) {
            allWayList.add(this.previousWay);
        }
        return allWayList;
    }

    public ArrayList<Way> getAllWaysBackwards() {
        ArrayList<Way> allWayList = new ArrayList<Way>();
        if (this.previousWay != null) {
            allWayList.addAll(this.previousWay.getNextWayList());
            allWayList.remove(this);
            allWayList.add(this.previousWay);
        }
        return allWayList;
    }
}

