/*
 * Decompiled with CFR 0.152.
 */
package menu;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import menu.KeyListenerJFrame;

public class BaseJFrameWrapper {
    private KeyListenerJFrame jFrame;
    private LayoutManager currentLayout;

    public BaseJFrameWrapper(boolean isFullscreen) {
        this.createJFrame(isFullscreen);
    }

    public void setFullScreen(boolean isFullScreen) {
        if (isFullScreen != this.jFrame.isUndecorated()) {
            this.rebuild(isFullScreen);
            this.show();
        }
    }

    public void updateJFrameForGame(Component panel, KeyListener keyListener) {
        this.emptyJFrameCache();
        this.updateKeyListener(keyListener);
        this.updateContent(panel, false);
    }

    public void updateJFrameForMenu(Component panel, KeyListener keyListener) {
        this.updateKeyListener(keyListener);
        this.updateContent(panel, true);
    }

    public void close() {
        this.jFrame.dispatchEvent(new WindowEvent(this.jFrame, 201));
    }

    public Component getMainComponent() {
        return this.jFrame;
    }

    public void overwriteFocusTraversalPolicy(FocusTraversalPolicy traversalPolicy) {
        this.jFrame.setFocusTraversalPolicy(traversalPolicy);
    }

    public void disableFocusTraversalKeys() {
        this.jFrame.setFocusTraversalKeysEnabled(false);
    }

    public void requestFocus() {
        this.jFrame.requestFocus();
    }

    public Dimension getSize() {
        return this.jFrame.getSize();
    }

    public void showDialog(String message) {
        JOptionPane.showMessageDialog(this.jFrame, message);
    }

    public void revalidate() {
        this.jFrame.revalidate();
        this.jFrame.repaint();
    }

    public void repaint() {
        this.jFrame.repaint();
    }

    private void updateContent(Component panel, boolean isMenu) {
        panel.setBackground(Color.darkGray);
        this.jFrame.getContentPane().setBackground(Color.darkGray);
        this.setLayoutManager(this.jFrame, isMenu);
        this.jFrame.getContentPane().removeAll();
        this.jFrame.getContentPane().add(panel);
        this.jFrame.setFocusTraversalPolicy(new DefaultFocusTraversalPolicy());
        this.jFrame.setFocusTraversalKeysEnabled(true);
        this.show();
    }

    private void show() {
        this.jFrame.setVisible(true);
        this.jFrame.revalidate();
        this.jFrame.repaint();
    }

    private void updateKeyListener(KeyListener keyListener) {
        this.jFrame.setCallbackKeyListener(keyListener);
    }

    private void createJFrame(boolean fullScreen) {
        this.jFrame = new KeyListenerJFrame(){

            @Override
            public void update(Graphics g) {
                super.paint(g);
            }
        };
        this.setLayoutManager(this.jFrame, true);
        this.jFrame.setUndecorated(fullScreen);
        this.jFrame.setDefaultCloseOperation(3);
        boolean needsMacWorkaround = System.getProperty("os.name").toLowerCase().contains("mac");
        if (needsMacWorkaround) {
            this.emptyJFrameCache();
        }
        if (fullScreen) {
            this.jFrame.setExtendedState(6);
        } else {
            Rectangle rect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            this.jFrame.setSize(new Dimension(rect.width, rect.height));
        }
        this.jFrame.setVisible(true);
        this.jFrame.setFocusable(true);
        this.jFrame.setFocusTraversalKeysEnabled(true);
        this.jFrame.addKeyListener(this.jFrame);
    }

    private void setLayoutManager(JFrame jFrame, boolean isMenu) {
        if (isMenu) {
            if (!(this.currentLayout instanceof FlowLayout)) {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                double height = screenSize.getHeight();
                this.currentLayout = new FlowLayout(1, 0, (int)height / 8);
                jFrame.setLayout(this.currentLayout);
            }
        } else if (!(this.currentLayout instanceof BorderLayout)) {
            this.currentLayout = new BorderLayout();
            jFrame.setLayout(this.currentLayout);
        }
    }

    private void rebuild(boolean isFullScreen) {
        Component[] componentList = this.jFrame.getContentPane().getComponents();
        KeyListener[] keyListenerList = this.jFrame.getKeyListeners();
        FocusTraversalPolicy traversalPolicy = this.jFrame.getFocusTraversalPolicy();
        this.emptyJFrameCache();
        this.createJFrame(isFullScreen);
        for (Component component : componentList) {
            this.jFrame.add(component);
        }
        for (KeyListener keyListener : keyListenerList) {
            this.jFrame.setCallbackKeyListener(keyListener);
        }
        this.jFrame.setFocusTraversalPolicy(traversalPolicy);
    }

    public void emptyJFrameCache() {
        Dimension screenSize = this.jFrame.getSize();
        this.jFrame.dispose();
        this.jFrame.pack();
        this.jFrame.setSize(screenSize);
    }
}

