/*
 * Decompiled with CFR 0.152.
 */
package menu;

import game.Game;
import game.NetworkClientGame;
import game.NetworkHostGame;
import game.SplitscreenGame;
import game.utils.LogHandler;
import gameServer.ClientSide.GameCoordinatorClientListener;
import gameServer.ClientSide.GameCoordinatorConnection;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.DefaultListModel;
import menu.BaseJFrameWrapper;
import menu.GameCoordinatorApplicationState;
import menu.GameMode;
import menu.GameModeSelectFrame;
import menu.GameSettings;
import menu.JoinFrame;
import menu.LobbyFrame;
import menu.NetworkOptionSelectFrame;
import menu.OnlineLobbyFrame;
import menu.PlayerMode;
import menu.PlayerModeSelectFrame;
import network.Connection;
import network.CreateServerException;
import rendering.thread.PeriodicExecutionService;

public class GameController {
    private GameSettings gameSettings = new GameSettings();
    private BaseJFrameWrapper baseJFrameWrapper;
    private GameCoordinatorApplicationState gameCoordinatorApplicationState;
    private DefaultListModel<String> scoreBoardModel;
    private static final String FULLSCREEN = "fullscreen";
    private static final String PLAYER_NAME = "player_name";
    private static final String PLAYER_TWO_NAME = "player_two_name";
    private static final String EASY_MODE = "easy_mode";
    private static final String TREASURE_MODE = "treasure_mode";
    private Preferences prefs = Preferences.userRoot().node(this.getClass().getName());

    public GameController() {
        boolean fullScreen = this.prefs.getBoolean(FULLSCREEN, true);
        String playerName = this.prefs.get(PLAYER_NAME, "unknown");
        String playerTwoName = this.prefs.get(PLAYER_TWO_NAME, "unknown");
        this.gameSettings.setUseFullScreen(fullScreen);
        if (!playerName.equals("unknown")) {
            this.gameSettings.setPlayerName(playerName);
        }
        if (!playerTwoName.equals("unknown")) {
            this.gameSettings.setPlayerTwoName(playerTwoName);
        }
        this.gameSettings.setEasyMode(this.prefs.getBoolean(EASY_MODE, false));
        this.gameSettings.setTreasureMode(this.prefs.getBoolean(TREASURE_MODE, false));
    }

    public GameSettings getGameSettings() {
        return this.gameSettings;
    }

    public void startTheGameAlready() {
        this.baseJFrameWrapper = new BaseJFrameWrapper(this.gameSettings.isUseFullScreen());
        PlayerModeSelectFrame modeSelectFrame = new PlayerModeSelectFrame(this);
        modeSelectFrame.render();
    }

    public void selectPlayerMode(PlayerMode playerMode) {
        GameCoordinatorConnection gameCoordinatorConnection = null;
        if (playerMode == PlayerMode.ONLINE && !(gameCoordinatorConnection = new GameCoordinatorConnection()).connect()) {
            this.baseJFrameWrapper.showDialog("Connection to game coordinator could not be established.");
            return;
        }
        this.gameSettings.setPlayerMode(playerMode);
        if (playerMode == PlayerMode.NETWORK) {
            NetworkOptionSelectFrame netWorkOptionSelectFrame = new NetworkOptionSelectFrame(this);
            netWorkOptionSelectFrame.render();
            return;
        }
        if (playerMode == PlayerMode.ONLINE) {
            OnlineLobbyFrame onlineLobbyFrame = new OnlineLobbyFrame(this, gameCoordinatorConnection);
            onlineLobbyFrame.render();
            GameCoordinatorClientListener gameCoordinatorClientListener = new GameCoordinatorClientListener(gameCoordinatorConnection, onlineLobbyFrame);
            gameCoordinatorClientListener.start();
            this.gameCoordinatorApplicationState = new GameCoordinatorApplicationState(gameCoordinatorConnection, gameCoordinatorClientListener);
            return;
        }
        GameModeSelectFrame gameModeSelectView = new GameModeSelectFrame(this);
        gameModeSelectView.render();
    }

    public void goBackToOnlineLobby() {
        if (this.gameCoordinatorApplicationState == null || !this.gameCoordinatorApplicationState.getGameCoordinatorConnection().getClientSocket().isConnected()) {
            this.selectPlayerMode(PlayerMode.ONLINE);
            return;
        }
        OnlineLobbyFrame onlineLobbyFrame = new OnlineLobbyFrame(this, this.gameCoordinatorApplicationState.getGameCoordinatorConnection());
        this.gameCoordinatorApplicationState.getGameCoordinatorClientListener().updateLobbyFrame(onlineLobbyFrame);
        onlineLobbyFrame.render();
        onlineLobbyFrame.updateLobbyListIfNotSet(this.gameCoordinatorApplicationState.getLobbyListEntries());
    }

    public void goBackToPlayerModeSelect() {
        PeriodicExecutionService.cancelAll();
        PlayerModeSelectFrame modeSelectFrame = new PlayerModeSelectFrame(this);
        modeSelectFrame.render();
    }

    public void selectGameMode(GameMode gameMode) {
        this.gameSettings.setGameMode(gameMode);
        switch (this.gameSettings.getPlayerMode()) {
            case SINGLE: {
                Game game = new Game();
                game.startGame(this);
                break;
            }
            case SPLITSCREEN: {
                SplitscreenGame splitScreenGame = new SplitscreenGame();
                splitScreenGame.startGame(this);
                break;
            }
            case NETWORK: {
                try {
                    LobbyFrame lobbyFrame = new LobbyFrame(this);
                    lobbyFrame.render();
                }
                catch (CreateServerException e) {
                    NetworkOptionSelectFrame netWorkOptionSelectFrame = new NetworkOptionSelectFrame(this);
                    netWorkOptionSelectFrame.render();
                }
                catch (IOException e) {
                    this.baseJFrameWrapper.showDialog("Connection error");
                    LogHandler.notifyException(e);
                    NetworkOptionSelectFrame netWorkOptionSelectFrame = new NetworkOptionSelectFrame(this);
                    netWorkOptionSelectFrame.render();
                }
                break;
            }
            case ONLINE: {
                try {
                    LobbyFrame lobbyFrame = new LobbyFrame(this);
                    lobbyFrame.render();
                    break;
                }
                catch (IOException e) {
                    this.baseJFrameWrapper.showDialog("Connection error");
                    LogHandler.notifyException(e);
                    this.getGameCoordinatorApplicationState().disconnect();
                    this.goBackToPlayerModeSelect();
                }
            }
        }
    }

    public void selectHostGame(String playerName) {
        this.gameSettings.setPlayerName(playerName);
        GameModeSelectFrame gameModeSelectView = new GameModeSelectFrame(this);
        gameModeSelectView.render();
    }

    public void selectJoinGame(String playerName) {
        this.gameSettings.setPlayerName(playerName);
        JoinFrame joinFrame = new JoinFrame(this);
        joinFrame.render();
    }

    public void selectJoinLobby(LobbyFrame lobbyFrame) {
        lobbyFrame.render();
    }

    public void selectStartMultiPlayer(Connection connection, boolean isPreferedSplitScreen) {
        if (connection.isHost()) {
            NetworkHostGame game = new NetworkHostGame();
            game.startGame(this, connection.getServerLobbyConnection());
        } else {
            NetworkClientGame game = new NetworkClientGame();
            game.startGame(this, connection.getClientConnection(), isPreferedSplitScreen, false);
        }
    }

    public BaseJFrameWrapper getBaseJFrameWrapper() {
        return this.baseJFrameWrapper;
    }

    public GameCoordinatorApplicationState getGameCoordinatorApplicationState() {
        return this.gameCoordinatorApplicationState;
    }

    public void storeSettings() {
        this.prefs.putBoolean(FULLSCREEN, this.gameSettings.isUseFullScreen());
        if (!this.gameSettings.getPlayerName().equals("unknown")) {
            this.prefs.put(PLAYER_NAME, this.gameSettings.getPlayerName());
        }
        if (!this.gameSettings.getPlayerTwoName().equals("unknown")) {
            this.prefs.put(PLAYER_TWO_NAME, this.gameSettings.getPlayerTwoName());
        }
        this.prefs.putBoolean(EASY_MODE, this.gameSettings.isEasyMode());
        this.prefs.putBoolean(TREASURE_MODE, this.gameSettings.isTreasureMode());
    }

    public DefaultListModel<String> getScoreBoardModel() {
        return this.scoreBoardModel;
    }

    public void setScoreBoardModel(DefaultListModel<String> scoreBoardModel) {
        this.scoreBoardModel = scoreBoardModel;
    }
}

