/*
 * Decompiled with CFR 0.152.
 */
package menu;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import menu.BaseJFrameWrapper;
import menu.GameController;
import menu.GameMode;
import menu.GameSettings;
import menu.PlayerMode;
import menu.RenderableFrame;
import navigationView.JElementFactory;

public class GameModeSelectFrame
implements RenderableFrame,
KeyListener {
    private BaseJFrameWrapper baseJFrameWrapper;
    private GameController gameController;
    private JTextField widthInput;
    private JTextField heightInput;
    private JTextField textInput;
    private JTextField playerNameInput;
    private JTextField playerTwoNameInput;

    public GameModeSelectFrame(GameController gameController) {
        this.baseJFrameWrapper = gameController.getBaseJFrameWrapper();
        this.gameController = gameController;
    }

    @Override
    public void render() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double width = screenSize.getWidth();
        double height = screenSize.getHeight();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GameSettings gameSettings = this.gameController.getGameSettings();
        boolean showPlayerNameInputSingle = gameSettings.getPlayerMode() == PlayerMode.SINGLE;
        boolean showPlayerNameInputSplit = gameSettings.getPlayerMode() == PlayerMode.SPLITSCREEN;
        JPanel playerNamePanel = null;
        if (showPlayerNameInputSingle || showPlayerNameInputSplit) {
            String playerName = gameSettings.getPlayerName();
            String playerTwoName = gameSettings.getPlayerTwoName();
            playerNamePanel = JElementFactory.createPanel();
            playerNamePanel.setLayout(new GridBagLayout());
            playerNamePanel.setPreferredSize(new Dimension((int)width / 3, showPlayerNameInputSplit ? 80 : 40));
            JLabel playerNameLabel = JElementFactory.createLabel((showPlayerNameInputSplit ? "First Player " : "") + "Name");
            this.playerNameInput = new JTextField(playerName);
            this.playerNameInput.setPreferredSize(new Dimension((int)width / 16, 20));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.gridx = 0;
            gbc.gridy = 0;
            playerNamePanel.add((Component)playerNameLabel, gbc);
            gbc.insets = new Insets(0, (int)width / 100, 0, 0);
            gbc.gridx = 1;
            playerNamePanel.add((Component)this.playerNameInput, gbc);
            if (showPlayerNameInputSplit) {
                JLabel playerTwoNameLabel = JElementFactory.createLabel("Second Player Name");
                this.playerTwoNameInput = new JTextField(playerTwoName);
                this.playerTwoNameInput.setPreferredSize(new Dimension((int)width / 16, 20));
                gbc.insets = new Insets(20, 0, 0, 0);
                gbc.gridx = 0;
                gbc.gridy = 1;
                playerNamePanel.add((Component)playerTwoNameLabel, gbc);
                gbc.insets = new Insets(20, (int)width / 100, 0, 0);
                gbc.gridx = 1;
                playerNamePanel.add((Component)this.playerTwoNameInput, gbc);
                this.playerTwoNameInput.addKeyListener(this);
            }
            this.playerNameInput.addKeyListener(this);
        }
        JButton bestOfTenButton = JElementFactory.createButton("[1] best of ten");
        JButton freeGameButton = JElementFactory.createButton("[2] free game");
        JButton backButton = JElementFactory.createButton("[ESC] Back");
        bestOfTenButton.setPreferredSize(new Dimension((int)width / 3, (int)height / 8));
        freeGameButton.setPreferredSize(new Dimension((int)width / 3, (int)height / 8));
        backButton.setPreferredSize(new Dimension((int)width / 6, (int)height / 16));
        bestOfTenButton.addActionListener(evt -> this.applyGameMode(true));
        freeGameButton.addActionListener(evt -> this.applyGameMode(false));
        backButton.addActionListener(evt -> this.goBack());
        this.widthInput = new JTextField("800");
        this.heightInput = new JTextField("600");
        this.textInput = new JTextField("");
        JLabel widthText = JElementFactory.createLabel("width");
        JLabel heightText = JElementFactory.createLabel("height");
        JLabel textText = JElementFactory.createLabel("text");
        JLabel infoText = JElementFactory.createLabel(" (width will be ignored if text is given)");
        JPanel dimensionSelectPanel = JElementFactory.createPanel();
        dimensionSelectPanel.setLayout(new GridBagLayout());
        dimensionSelectPanel.setPreferredSize(new Dimension((int)width / 3, 40));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        dimensionSelectPanel.add((Component)widthText, gbc);
        gbc.insets = new Insets(0, (int)width / 100, 0, 0);
        gbc.ipadx = (int)width / 50;
        gbc.gridx = 1;
        dimensionSelectPanel.add((Component)this.widthInput, gbc);
        gbc.insets = new Insets(0, (int)width / 50, 0, 0);
        gbc.ipadx = 0;
        gbc.gridx = 2;
        dimensionSelectPanel.add((Component)heightText, gbc);
        gbc.insets = new Insets(0, (int)width / 100, 0, 0);
        gbc.ipadx = (int)width / 50;
        gbc.gridx = 3;
        dimensionSelectPanel.add((Component)this.heightInput, gbc);
        gbc.insets = new Insets(0, -((int)width) / 300, 0, 0);
        gbc.ipadx = 0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        dimensionSelectPanel.add((Component)textText, gbc);
        gbc.insets = new Insets(0, (int)width / 100, 0, 0);
        gbc.ipadx = (int)width / 32;
        gbc.gridx = 1;
        dimensionSelectPanel.add((Component)this.textInput, gbc);
        gbc.insets = new Insets(0, (int)width / 100, 0, 0);
        gbc.ipadx = 0;
        gbc.gridx = 2;
        gbc.gridwidth = 3;
        dimensionSelectPanel.add((Component)infoText, gbc);
        GridLayout gridLayout = new GridLayout(2, 0);
        JPanel freeGameBlock = new JPanel(gridLayout);
        freeGameBlock.add((Component)freeGameButton, gbc);
        freeGameBlock.add((Component)dimensionSelectPanel, gbc);
        freeGameBlock.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        gbc = new GridBagConstraints();
        gbc.insets = new Insets((int)height / 200, (int)width / 200, (int)height / 200, (int)width / 200);
        gbc.gridx = 0;
        gbc.gridy = 0;
        if (this.gameController.getGameSettings().getPlayerMode() != PlayerMode.NETWORK) {
            JLabel highScoreLabel = JElementFactory.createLabel("Finish all 10 rounds in best of ten mode to get a new high score");
            panel.add((Component)highScoreLabel, gbc);
        }
        gbc.gridy = 1;
        JLabel controlHint = this.gameController.getGameSettings().getPlayerMode() == PlayerMode.SPLITSCREEN ? JElementFactory.createLabel("Player 1 uses W/A/S/D, player 2 uses arrows to navigate.") : JElementFactory.createLabel("Use arrows, W/A/S/D or numblock to navigate.");
        panel.add((Component)controlHint, gbc);
        gbc.gridy = 2;
        JLabel controlHint2 = JElementFactory.createLabel("Find the goal as fast as possible (circle in your own color).");
        if (this.gameController.getGameSettings().getPlayerMode() != PlayerMode.SINGLE && gameSettings.isTreasureMode()) {
            controlHint2.setText("Find the goal as fast as possible (circle in your own color). Treasures count as 10 extra points.");
        }
        panel.add((Component)controlHint2, gbc);
        if (playerNamePanel != null) {
            gbc.gridy = 3;
            panel.add((Component)playerNamePanel, gbc);
        }
        gbc.insets = new Insets((int)height / 40, (int)width / 200, (int)height / 40, (int)width / 200);
        gbc.gridy = 4;
        panel.add((Component)bestOfTenButton, gbc);
        gbc.gridy = 5;
        panel.add((Component)freeGameBlock, gbc);
        gbc.insets = new Insets((int)height / 20, (int)width / 200, (int)height / 20, (int)width / 200);
        gbc.gridy = 6;
        panel.add((Component)backButton, gbc);
        this.baseJFrameWrapper.updateJFrameForMenu(panel, this);
        this.addFocusTraversalPolicy();
    }

    private void addFocusTraversalPolicy() {
        final Component selectFrame = this.baseJFrameWrapper.getMainComponent();
        FocusTraversalPolicy traversalPolicy = new FocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                if (aComponent == GameModeSelectFrame.this.widthInput) {
                    return GameModeSelectFrame.this.heightInput;
                }
                if (aComponent == GameModeSelectFrame.this.heightInput) {
                    return GameModeSelectFrame.this.textInput;
                }
                if (aComponent == GameModeSelectFrame.this.textInput) {
                    return selectFrame;
                }
                if (aComponent == GameModeSelectFrame.this.playerNameInput) {
                    if (GameModeSelectFrame.this.playerTwoNameInput != null) {
                        return GameModeSelectFrame.this.playerTwoNameInput;
                    }
                    return GameModeSelectFrame.this.widthInput;
                }
                if (aComponent == GameModeSelectFrame.this.playerTwoNameInput) {
                    return GameModeSelectFrame.this.widthInput;
                }
                if (GameModeSelectFrame.this.playerNameInput != null) {
                    return GameModeSelectFrame.this.playerNameInput;
                }
                return GameModeSelectFrame.this.widthInput;
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                if (aComponent == GameModeSelectFrame.this.widthInput) {
                    if (GameModeSelectFrame.this.playerTwoNameInput != null) {
                        return GameModeSelectFrame.this.playerTwoNameInput;
                    }
                    if (GameModeSelectFrame.this.playerNameInput != null) {
                        return GameModeSelectFrame.this.playerNameInput;
                    }
                    return selectFrame;
                }
                if (aComponent == GameModeSelectFrame.this.heightInput) {
                    return GameModeSelectFrame.this.widthInput;
                }
                if (aComponent == GameModeSelectFrame.this.textInput) {
                    return GameModeSelectFrame.this.heightInput;
                }
                if (aComponent == GameModeSelectFrame.this.playerNameInput) {
                    return selectFrame;
                }
                if (aComponent == GameModeSelectFrame.this.playerTwoNameInput) {
                    return GameModeSelectFrame.this.playerNameInput;
                }
                return GameModeSelectFrame.this.textInput;
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                return selectFrame;
            }

            @Override
            public Component getLastComponent(Container aContainer) {
                return GameModeSelectFrame.this.textInput;
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return selectFrame;
            }
        };
        this.baseJFrameWrapper.overwriteFocusTraversalPolicy(traversalPolicy);
    }

    public void applyGameMode(boolean bestOfTenMode) {
        GameMode gameMode;
        if (bestOfTenMode) {
            gameMode = new GameMode();
        } else {
            try {
                int width = Integer.parseInt(this.widthInput.getText());
                int height = Integer.parseInt(this.heightInput.getText());
                width = Math.max(width, 100);
                width = Math.min(width, 2500);
                height = Math.max(height, 100);
                height = Math.min(height, 2500);
                String inputText = this.textInput.getText();
                if (inputText != null && inputText.length() > 20) {
                    inputText = inputText.substring(0, 20);
                    height = Math.min(height, 1000);
                }
                if (inputText != null && inputText.length() > 10) {
                    height = Math.min(height, 1500);
                }
                gameMode = new GameMode(width, height, inputText);
            }
            catch (NumberFormatException e) {
                gameMode = new GameMode(800, 600, null);
            }
        }
        if (this.playerNameInput != null) {
            this.gameController.getGameSettings().setPlayerName(this.playerNameInput.getText());
        }
        if (this.playerTwoNameInput != null) {
            this.gameController.getGameSettings().setPlayerTwoName(this.playerTwoNameInput.getText());
        }
        this.gameController.selectGameMode(gameMode);
    }

    public void goBack() {
        this.gameController.goBackToPlayerModeSelect();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 49 && !this.textHasFocus()) {
            this.applyGameMode(true);
        } else if (e.getKeyCode() == 50 && !this.textHasFocus()) {
            this.applyGameMode(false);
        } else if (e.getKeyCode() == 10 && this.playerNameInput != null && this.playerNameInput.hasFocus()) {
            if (this.playerTwoNameInput != null) {
                this.playerNameInput.transferFocus();
            } else {
                this.baseJFrameWrapper.getMainComponent().requestFocus();
            }
        } else if (e.getKeyCode() == 10 && this.playerTwoNameInput != null && this.playerTwoNameInput.hasFocus()) {
            this.baseJFrameWrapper.getMainComponent().requestFocus();
        } else if (e.getKeyCode() == 27) {
            this.goBack();
        }
    }

    private boolean textHasFocus() {
        if (this.playerNameInput != null && this.playerNameInput.hasFocus()) {
            return true;
        }
        return this.playerTwoNameInput != null && this.playerTwoNameInput.hasFocus();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

