/*
 * Decompiled with CFR 0.152.
 */
package menu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import menu.BaseJFrameWrapper;
import menu.GameController;
import menu.LobbyFrame;
import menu.RenderableFrame;
import navigationView.JElementFactory;
import network.Connection;

public class JoinFrame
implements RenderableFrame,
KeyListener {
    private BaseJFrameWrapper baseJFrameWrapper;
    private GameController gameController;
    private JTextField ipInput;

    public JoinFrame(GameController gameController) {
        this.baseJFrameWrapper = gameController.getBaseJFrameWrapper();
        this.gameController = gameController;
    }

    @Override
    public void render() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double width = screenSize.getWidth();
        double height = screenSize.getHeight();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        String ipInputString = "127.0.0.1";
        if (this.gameController.getGameSettings().getStoredIp() != null) {
            ipInputString = this.gameController.getGameSettings().getStoredIp();
        }
        this.ipInput = new JTextField(ipInputString);
        JLabel ipLabel = JElementFactory.createLabel("IP");
        JButton connectButton = JElementFactory.createButton("[Enter] Connect");
        JButton backButton = JElementFactory.createButton("[ESC] Back");
        connectButton.setPreferredSize(new Dimension((int)width / 3, (int)height / 8));
        backButton.setPreferredSize(new Dimension((int)width / 6, (int)height / 16));
        connectButton.addActionListener(evt -> this.connect());
        backButton.addActionListener(evt -> this.goBack());
        JPanel dimensionSelectPanel = JElementFactory.createPanel();
        dimensionSelectPanel.setLayout(new GridBagLayout());
        dimensionSelectPanel.setPreferredSize(new Dimension((int)width / 3, 30));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        dimensionSelectPanel.add((Component)ipLabel, gbc);
        gbc.insets = new Insets(0, (int)width / 100, 0, 0);
        gbc.ipadx = (int)width / 50;
        gbc.gridx = 1;
        dimensionSelectPanel.add((Component)this.ipInput, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets((int)height / 40, (int)width / 200, (int)height / 40, (int)width / 200);
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)dimensionSelectPanel, gbc);
        gbc.gridy = 1;
        panel.add((Component)connectButton, gbc);
        gbc.insets = new Insets((int)height / 20, (int)width / 200, (int)height / 20, (int)width / 200);
        gbc.gridy = 2;
        panel.add((Component)backButton, gbc);
        this.baseJFrameWrapper.updateJFrameForMenu(panel, this);
        this.ipInput.addKeyListener(this);
        if (ipInputString.equals("127.0.0.1")) {
            this.ipInput.requestFocus();
            this.ipInput.selectAll();
        }
    }

    public void connect() {
        String ip = this.ipInput.getText();
        this.gameController.getGameSettings().storeIp(ip);
        Connection connection = new Connection(ip);
        LobbyFrame lobbyFrame = new LobbyFrame(this.gameController, connection);
        boolean isSuccess = connection.startClientConnection(lobbyFrame, this.gameController.getGameSettings().getPlayerName());
        if (isSuccess) {
            this.gameController.selectJoinLobby(lobbyFrame);
        }
    }

    public void goBack() {
        this.gameController.goBackToPlayerModeSelect();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.connect();
        } else if (e.getKeyCode() == 27) {
            this.goBack();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

