/*
 * Decompiled with CFR 0.152.
 */
package menu;

import game.NetworkClientGame;
import game.utils.LogHandler;
import gameServer.ClientSide.GameCoordinatorConnection;
import gameServer.ClientState;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import menu.BaseJFrameWrapper;
import menu.GameController;
import menu.GameSettings;
import menu.PlayerMode;
import menu.RenderableFrame;
import navigationView.JElementFactory;
import network.Connection;
import network.LobbyListener;
import network.ReadWriteHelper;
import rendering.ImageRenderer;

public class LobbyFrame
implements RenderableFrame,
KeyListener,
LobbyListener {
    private BaseJFrameWrapper baseJFrameWrapper;
    private GameController gameController;
    private Connection connection;
    private boolean isHost;
    private JPanel playerNamePanel;
    private ArrayList<JLabel> playerLabelList = new ArrayList();
    private boolean isOnlineMode;

    public LobbyFrame(GameController gameController, Connection connectInfo) {
        this.baseJFrameWrapper = gameController.getBaseJFrameWrapper();
        this.gameController = gameController;
        this.connection = connectInfo;
        this.isHost = false;
        this.isOnlineMode = gameController.getGameSettings().getPlayerMode() == PlayerMode.ONLINE;
    }

    public LobbyFrame(GameController gameController) throws IOException {
        this.baseJFrameWrapper = gameController.getBaseJFrameWrapper();
        this.gameController = gameController;
        this.isHost = true;
        GameSettings gameSettings = gameController.getGameSettings();
        boolean bl = this.isOnlineMode = gameSettings.getPlayerMode() == PlayerMode.ONLINE;
        if (this.isOnlineMode) {
            GameCoordinatorConnection gameCoordinatorConnection = gameController.getGameCoordinatorApplicationState().getGameCoordinatorConnection();
            this.connection = new Connection(gameController.getGameCoordinatorApplicationState(), this.isHost, gameSettings.getPlayerName());
            this.connection.addLobbyListenerToClientConnection(this);
            ReadWriteHelper.writeSocketMessage(gameCoordinatorConnection.getClientSocket(), "createLobby;" + gameSettings.getPlayerName() + ";" + gameSettings.getGameMode().getCustomSerializedString() + ";" + (gameSettings.isEasyMode() ? "1" : "0") + ";" + (gameSettings.isTreasureMode() ? "1" : "0"));
            return;
        }
        this.connection = new Connection();
        this.connection.startServerLobbyConnection(this, gameSettings.getPlayerName());
    }

    @Override
    public void render() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double width = screenSize.getWidth();
        double height = screenSize.getHeight();
        JPanel panel = new JPanel();
        this.playerNamePanel = JElementFactory.createPanel();
        this.playerNamePanel.setLayout(new BoxLayout(this.playerNamePanel, 1));
        JLabel infoLabel = JElementFactory.createLabel("Connected Players:");
        infoLabel.setFont(infoLabel.getFont().deriveFont(30.0f));
        this.playerNamePanel.add(infoLabel);
        this.playerNamePanel.setPreferredSize(new Dimension((int)width / 3, (int)height / 6));
        panel.setLayout(new GridBagLayout());
        JButton startButton = JElementFactory.createButton("[Enter] Start");
        JButton backButton = JElementFactory.createButton("[ESC] Back");
        startButton.setPreferredSize(new Dimension((int)width / 3, (int)height / 8));
        backButton.setPreferredSize(new Dimension((int)width / 6, (int)height / 16));
        startButton.addActionListener(evt -> this.start(this.gameController.getGameSettings().isPreferNetworkSplitscreen()));
        backButton.addActionListener(evt -> this.goBack());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets((int)height / 200, (int)width / 200, (int)height / 200, (int)width / 200);
        gbc.gridx = 0;
        gbc.gridy = 0;
        if (this.gameController.getGameSettings().getGameMode() != null && this.gameController.getGameSettings().getGameMode().isBestOfTenMode()) {
            JLabel highScoreLabel = JElementFactory.createLabel("Finish all 10 rounds to get a new high score");
            panel.add((Component)highScoreLabel, gbc);
        }
        gbc.gridy = 1;
        JLabel controlHint = JElementFactory.createLabel("Use arrows, W/A/S/D or numblock to navigate.");
        panel.add((Component)controlHint, gbc);
        gbc.gridy = 2;
        JLabel controlHint2 = JElementFactory.createLabel("Find the goal as fast as possible (circle in your own color).");
        if (this.gameController.getGameSettings().isTreasureMode()) {
            controlHint2.setText("Find the goal as fast as possible (circle in your own color). Treasures count as 10 extra points.");
        }
        panel.add((Component)controlHint2, gbc);
        gbc.insets = new Insets((int)height / 40, (int)width / 200, (int)height / 40, (int)width / 200);
        gbc.gridy = 3;
        panel.add((Component)this.playerNamePanel, gbc);
        gbc.gridy = 4;
        if (this.isHost) {
            panel.add((Component)startButton, gbc);
        }
        gbc.insets = new Insets((int)height / 20, (int)width / 200, (int)height / 20, (int)width / 200);
        gbc.gridy = 5;
        panel.add((Component)backButton, gbc);
        this.baseJFrameWrapper.updateJFrameForMenu(panel, this);
        this.baseJFrameWrapper.requestFocus();
        if (this.isHost) {
            if (this.connection.getClientConnection() != null) {
                this.connection.getClientConnection().updatePlayers(new String[]{this.gameController.getGameSettings().getPlayerName()}, 0);
            } else {
                this.playerNameUpdate(new String[]{this.gameController.getGameSettings().getPlayerName()});
            }
        }
    }

    @Override
    public void start(boolean isPreferedSplitScreen) {
        if (this.connection.isHost()) {
            if (this.isOnlineMode && this.isInLobby()) {
                try {
                    ReadWriteHelper.writeSocketMessage(this.gameController.getGameCoordinatorApplicationState().getGameCoordinatorConnection().getClientSocket(), "startGame;");
                }
                catch (IOException e) {
                    LogHandler.notifyException(e);
                    this.baseJFrameWrapper.showDialog("starting game failed");
                    this.gameController.goBackToOnlineLobby();
                    return;
                }
                NetworkClientGame game = new NetworkClientGame();
                game.startGame(this.gameController, this.connection.getClientConnection(), isPreferedSplitScreen, true);
                return;
            }
            int playerNumber = this.connection.getServerLobbyConnection().getPlayerList().size();
            if (playerNumber < 2 || playerNumber > 12) {
                this.baseJFrameWrapper.showDialog("Online Game can only be started with 2 - 12 players.");
                return;
            }
            this.connection.getServerLobbyConnection().startGame(isPreferedSplitScreen);
        }
        this.gameController.selectStartMultiPlayer(this.connection, isPreferedSplitScreen);
    }

    public void goBack() {
        if (this.isOnlineMode) {
            try {
                if (this.isInLobby()) {
                    ReadWriteHelper.writeSocketMessage(this.gameController.getGameCoordinatorApplicationState().getGameCoordinatorConnection().getClientSocket(), "leaveLobby;");
                }
            }
            catch (IOException e) {
                LogHandler.notifyException(e);
            }
            this.gameController.getGameCoordinatorApplicationState().setClientState(ClientState.ENTRANCE);
            this.gameController.goBackToOnlineLobby();
            return;
        }
        this.connection.stop();
        if (this.isHost) {
            this.gameController.goBackToPlayerModeSelect();
        } else {
            this.gameController.selectJoinGame(this.gameController.getGameSettings().getPlayerName());
        }
    }

    private boolean isInLobby() {
        return this.gameController.getGameCoordinatorApplicationState().isInLobby();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.start(this.gameController.getGameSettings().isPreferNetworkSplitscreen());
        } else if (e.getKeyCode() == 27) {
            this.goBack();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void disconnect() {
        this.goBack();
    }

    @Override
    public void showMessageDialog(String message) {
        this.baseJFrameWrapper.showDialog(message);
    }

    @Override
    public void playerNameUpdate(String[] playerNameList) {
        for (JLabel playerLabel : this.playerLabelList) {
            this.playerNamePanel.remove(playerLabel);
        }
        this.playerLabelList = new ArrayList();
        int i = 0;
        for (String playerName : playerNameList) {
            JLabel playerLabel = new JLabel(playerName);
            playerLabel.setForeground(ImageRenderer.getColorByPlayerNumber(i++));
            this.playerNamePanel.add(playerLabel);
            this.playerLabelList.add(playerLabel);
        }
        this.baseJFrameWrapper.revalidate();
    }
}

