/*
 * Decompiled with CFR 0.152.
 */
package menu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import menu.BaseJFrameWrapper;
import menu.GameController;
import menu.RenderableFrame;
import navigationView.JElementFactory;

public class NetworkOptionSelectFrame
implements RenderableFrame,
KeyListener {
    private BaseJFrameWrapper baseJFrameWrapper;
    private GameController gameController;
    private JTextField playerNameInput;

    public NetworkOptionSelectFrame(GameController gameController) {
        this.gameController = gameController;
        this.baseJFrameWrapper = gameController.getBaseJFrameWrapper();
    }

    @Override
    public void render() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double width = screenSize.getWidth();
        double height = screenSize.getHeight();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        String playerName = "unknown";
        if (this.gameController.getGameSettings().getPlayerName() != null) {
            playerName = this.gameController.getGameSettings().getPlayerName();
        }
        this.playerNameInput = new JTextField(playerName);
        JLabel playerNameLabel = JElementFactory.createLabel("Name");
        JButton hostGameButton = JElementFactory.createButton("[1] host game");
        JButton joinGameButton = JElementFactory.createButton("[2] join game");
        JButton backButton = JElementFactory.createButton("[ESC] Back");
        hostGameButton.setPreferredSize(new Dimension((int)width / 3, (int)height / 8));
        joinGameButton.setPreferredSize(new Dimension((int)width / 3, (int)height / 8));
        backButton.setPreferredSize(new Dimension((int)width / 6, (int)height / 16));
        hostGameButton.addActionListener(evt -> this.selectHostGame());
        joinGameButton.addActionListener(evt -> this.selectJoinGame());
        backButton.addActionListener(evt -> this.goBack());
        JPanel dimensionSelectPanel = JElementFactory.createPanel();
        dimensionSelectPanel.setLayout(new GridBagLayout());
        dimensionSelectPanel.setPreferredSize(new Dimension((int)width / 3, 30));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        dimensionSelectPanel.add((Component)playerNameLabel, gbc);
        gbc.insets = new Insets(0, (int)width / 100, 0, 0);
        gbc.ipadx = (int)width / 50;
        gbc.gridx = 1;
        dimensionSelectPanel.add((Component)this.playerNameInput, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets((int)height / 40, (int)width / 200, (int)height / 40, (int)width / 200);
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)dimensionSelectPanel, gbc);
        gbc.gridy = 1;
        panel.add((Component)hostGameButton, gbc);
        gbc.gridy = 2;
        panel.add((Component)joinGameButton, gbc);
        gbc.gridy = 3;
        gbc.insets = new Insets((int)height / 20, (int)width / 200, (int)height / 20, (int)width / 200);
        panel.add((Component)backButton, gbc);
        this.baseJFrameWrapper.updateJFrameForMenu(panel, this);
        this.playerNameInput.addKeyListener(this);
        if (playerName.equals("unknown")) {
            this.playerNameInput.requestFocus();
            this.playerNameInput.selectAll();
        }
    }

    public void selectHostGame() {
        String playerName = this.playerNameInput.getText();
        if (playerName.length() > 30) {
            playerName = playerName.substring(0, 30);
        }
        if (playerName.replace(" ", "").length() == 0) {
            return;
        }
        this.gameController.selectHostGame(playerName);
    }

    public void selectJoinGame() {
        String playerName = this.playerNameInput.getText();
        if (playerName.length() > 30) {
            playerName = playerName.substring(0, 30);
        }
        if (playerName.replace(" ", "").length() == 0) {
            return;
        }
        this.gameController.selectJoinGame(playerName);
    }

    public void goBack() {
        this.gameController.goBackToPlayerModeSelect();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 49 && !this.playerNameInput.hasFocus()) {
            this.selectHostGame();
        } else if (e.getKeyCode() == 50 && !this.playerNameInput.hasFocus()) {
            this.selectJoinGame();
        } else if (e.getKeyCode() == 10 && this.playerNameInput.hasFocus()) {
            this.playerNameInput.transferFocus();
        } else if (e.getKeyCode() == 27) {
            this.goBack();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

