/*
 * Decompiled with CFR 0.152.
 */
package menu;

import game.utils.LogHandler;
import gameServer.ClientSide.GameCoordinatorConnection;
import gameServer.ClientSide.LobbyListEntry;
import gameServer.ClientSide.LobbyUpdateRecord;
import gameServer.ScoreBoard.ScoreBoardRecord;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import menu.BaseJFrameWrapper;
import menu.GameController;
import menu.LobbyFrame;
import menu.RenderableFrame;
import navigationView.JElementFactory;
import network.Connection;
import network.ReadWriteHelper;

public class OnlineLobbyFrame
implements RenderableFrame,
KeyListener {
    private BaseJFrameWrapper baseJFrameWrapper;
    private GameController gameController;
    private DefaultListModel<LobbyListEntry> lobbyListModel = new DefaultListModel();
    private JList<LobbyListEntry> lobbyList;
    private JTextField playerNameInput;
    private GameCoordinatorConnection gameCoordinatorConnection;
    private ArrayList<LobbyListEntry> lobbyListEntries = new ArrayList();
    private DefaultListModel<String> scoreBoardModel;
    private boolean isShown = false;

    public OnlineLobbyFrame(GameController gameController, GameCoordinatorConnection gameCoordinatorConnection) {
        this.baseJFrameWrapper = gameController.getBaseJFrameWrapper();
        this.gameController = gameController;
        this.gameCoordinatorConnection = gameCoordinatorConnection;
    }

    @Override
    public void render() {
        this.isShown = true;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double width = screenSize.getWidth();
        double height = screenSize.getHeight();
        String playerName = "unknown";
        if (this.gameController.getGameSettings().getPlayerName() != null) {
            playerName = this.gameController.getGameSettings().getPlayerName();
        }
        this.playerNameInput = new JTextField(playerName);
        JPanel panel = new JPanel();
        JPanel lobbyListPanel = new JPanel();
        lobbyListPanel.setBackground(new Color(90, 90, 90));
        this.lobbyList = new JList<LobbyListEntry>(this.lobbyListModel);
        this.lobbyList.setPreferredSize(new Dimension((int)width / 3, (int)height / 6));
        JLabel infoLabel = JElementFactory.createLabel("Lobby List:");
        infoLabel.setFont(infoLabel.getFont().deriveFont(30.0f));
        lobbyListPanel.add(infoLabel);
        lobbyListPanel.add(this.lobbyList);
        lobbyListPanel.setPreferredSize(new Dimension((int)width / 3, (int)height / 6));
        panel.setLayout(new GridBagLayout());
        JLabel playerNameLabel = JElementFactory.createLabel("Name");
        JButton joinLobbyButton = JElementFactory.createButton("[Enter] Join Lobby");
        JButton createLobbyButton = JElementFactory.createButton("[C] Create Lobby");
        JButton backButton = JElementFactory.createButton("[ESC] Back");
        JPanel scoreBoardPanel = new JPanel();
        scoreBoardPanel.setBackground(new Color(90, 90, 90));
        this.scoreBoardModel = this.gameController.getScoreBoardModel();
        if (this.scoreBoardModel == null) {
            this.scoreBoardModel = new DefaultListModel();
        }
        JList<String> scoreBoard = new JList<String>(this.scoreBoardModel);
        if (this.gameCoordinatorConnection.getScoreBoardRecordList() != null) {
            this.setupScoreBoardContent(this.gameCoordinatorConnection.getScoreBoardRecordList());
        }
        scoreBoard.setSelectionModel(new DisabledItemSelectionModel());
        scoreBoard.setPreferredSize(new Dimension((int)width / 6, (int)height / 2));
        infoLabel = JElementFactory.createLabel("Highscore:");
        infoLabel.setFont(infoLabel.getFont().deriveFont(30.0f));
        scoreBoardPanel.add(infoLabel);
        scoreBoardPanel.add(scoreBoard);
        scoreBoardPanel.setPreferredSize(new Dimension((int)width / 6, (int)(height / 2.1)));
        joinLobbyButton.setPreferredSize(new Dimension((int)width / 3, (int)height / 8));
        createLobbyButton.setPreferredSize(new Dimension((int)width / 3, (int)height / 8));
        backButton.setPreferredSize(new Dimension((int)width / 6, (int)height / 16));
        joinLobbyButton.addActionListener(evt -> this.joinSelectedLobby());
        createLobbyButton.addActionListener(evt -> this.createLobby());
        backButton.addActionListener(evt -> this.goBack());
        JPanel dimensionSelectPanel = JElementFactory.createPanel();
        dimensionSelectPanel.setLayout(new GridBagLayout());
        dimensionSelectPanel.setPreferredSize(new Dimension((int)width / 3, 30));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        dimensionSelectPanel.add((Component)playerNameLabel, gbc);
        gbc.insets = new Insets(0, (int)width / 100, 0, 0);
        gbc.ipadx = (int)width / 50;
        gbc.gridx = 1;
        dimensionSelectPanel.add((Component)this.playerNameInput, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets((int)height / 60, (int)width / 200, (int)height / 60, (int)width / 200);
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)dimensionSelectPanel, gbc);
        gbc.gridy = 1;
        panel.add((Component)lobbyListPanel, gbc);
        gbc.gridy = 2;
        panel.add((Component)joinLobbyButton, gbc);
        gbc.gridy = 3;
        panel.add((Component)createLobbyButton, gbc);
        gbc.gridy = 4;
        panel.add((Component)backButton, gbc);
        gbc.insets = new Insets(-((int)height) / 60, (int)width / 100, (int)height / 60, (int)width / 100);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 5;
        panel.add((Component)scoreBoardPanel, gbc);
        this.baseJFrameWrapper.updateJFrameForMenu(panel, this);
        this.baseJFrameWrapper.disableFocusTraversalKeys();
        this.lobbyList.addKeyListener(this);
        this.playerNameInput.setFocusTraversalKeysEnabled(false);
        this.playerNameInput.addKeyListener(this);
        this.focusTextField();
    }

    private void setupScoreBoardContent(ArrayList<ScoreBoardRecord> scoreBoardRecordList) {
        this.scoreBoardModel.clear();
        for (ScoreBoardRecord scoreBoardRecord : scoreBoardRecordList) {
            this.scoreBoardModel.addElement(scoreBoardRecord.toString());
        }
        this.gameController.setScoreBoardModel(this.scoreBoardModel);
    }

    public void goBack() {
        this.isShown = false;
        this.gameController.getGameCoordinatorApplicationState().getGameCoordinatorClientListener().stopThread();
        this.gameCoordinatorConnection.disconnect(true);
        this.gameController.goBackToPlayerModeSelect();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && !this.playerNameInput.hasFocus()) {
            this.joinSelectedLobby();
        } else if (e.getKeyCode() == 67) {
            if (!this.playerNameInput.hasFocus()) {
                this.createLobby();
            }
        } else if (e.getKeyCode() == 27) {
            this.goBack();
        } else if (e.getKeyCode() == 9 || e.getKeyCode() == 10 && this.playerNameInput.hasFocus()) {
            int currentSelectedIndex = 0;
            if (!this.lobbyList.isSelectionEmpty() && this.lobbyListModel.getSize() > 0) {
                currentSelectedIndex = (this.lobbyList.getSelectedIndex() + 1) % this.lobbyListModel.getSize();
            }
            if (!(currentSelectedIndex != 0 || this.lobbyList.isSelectionEmpty() && this.lobbyListModel.getSize() > 0)) {
                if (this.lobbyListModel.getSize() == 0 && this.playerNameInput.hasFocus()) {
                    this.baseJFrameWrapper.requestFocus();
                } else {
                    this.lobbyList.clearSelection();
                    this.playerNameInput.requestFocus();
                }
            } else {
                this.lobbyList.setSelectedIndex(currentSelectedIndex);
                if (!this.baseJFrameWrapper.getMainComponent().hasFocus()) {
                    this.baseJFrameWrapper.requestFocus();
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private void createLobby() {
        this.gameController.selectHostGame(this.playerNameInput.getText());
    }

    private void joinSelectedLobby() {
        LobbyListEntry selectedLobbyListEntry = this.lobbyList.getSelectedValue();
        this.gameController.getGameSettings().setPlayerName(this.playerNameInput.getText());
        if (selectedLobbyListEntry == null) {
            return;
        }
        try {
            ReadWriteHelper.writeSocketMessage(this.gameCoordinatorConnection.getClientSocket(), "joinLobby;" + selectedLobbyListEntry.getLobbyId() + ";" + this.playerNameInput.getText());
        }
        catch (IOException e) {
            LogHandler.notifyException(e);
            this.baseJFrameWrapper.showDialog("Join Lobby failed: Connection lost.");
            this.goBack();
        }
    }

    public void enterSelectedLobby(String[] playerNames, int selfIndex) throws IOException {
        Connection connection = new Connection(this.gameController.getGameCoordinatorApplicationState(), false, this.playerNameInput.getText());
        LobbyFrame lobbyFrame = new LobbyFrame(this.gameController, connection);
        connection.addLobbyListenerToClientConnection(lobbyFrame);
        this.gameController.selectJoinLobby(lobbyFrame);
        connection.getClientConnection().updatePlayers(playerNames, selfIndex);
    }

    public void focusTextField() {
        if (this.playerNameInput.getText().equals("unknown")) {
            this.playerNameInput.requestFocus();
            this.playerNameInput.selectAll();
        }
    }

    public void updateLobby(LobbyUpdateRecord lobbyUpdateRecord) {
        this.setupScoreBoardContent(lobbyUpdateRecord.getScoreBoardRecordList());
        this.updateLobbyList(lobbyUpdateRecord.getLobbyListEntryList());
        this.gameCoordinatorConnection.setScoreBoardRecordList(lobbyUpdateRecord.getScoreBoardRecordList());
    }

    public void updateLobbyList(ArrayList<LobbyListEntry> lobbyListEntries) {
        for (LobbyListEntry lobbyListEntry : lobbyListEntries) {
            if (this.lobbyListEntries.contains(lobbyListEntry)) continue;
            this.lobbyListEntries.add(lobbyListEntry);
            this.lobbyListModel.addElement(lobbyListEntry);
        }
        ArrayList<LobbyListEntry> elementsToRemove = new ArrayList<LobbyListEntry>();
        for (LobbyListEntry lobbyListEntry : this.lobbyListEntries) {
            if (lobbyListEntries.contains(lobbyListEntry)) continue;
            elementsToRemove.add(lobbyListEntry);
            this.lobbyListModel.removeElement(lobbyListEntry);
        }
        this.lobbyListEntries.removeAll(elementsToRemove);
        this.baseJFrameWrapper.revalidate();
        this.gameController.getGameCoordinatorApplicationState().setLobbyList(lobbyListEntries);
    }

    public void updateLobbyListIfNotSet(ArrayList<LobbyListEntry> lobbyListEntries) {
        if (this.lobbyListEntries.isEmpty()) {
            this.updateLobbyList(lobbyListEntries);
        }
    }

    public boolean isShown() {
        return this.isShown;
    }

    public void showDialog(String message) {
        this.baseJFrameWrapper.showDialog(message);
    }

    static class DisabledItemSelectionModel
    extends DefaultListSelectionModel {
        DisabledItemSelectionModel() {
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            super.setSelectionInterval(-1, -1);
        }
    }
}

