/*
 * Decompiled with CFR 0.152.
 */
package menu;

import gameServer.ScoreBoard.ScoreBoardRecord;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import menu.BaseJFrameWrapper;
import menu.GameController;
import menu.GameSettings;
import menu.OnlineLobbyFrame;
import menu.PlayerMode;
import menu.RenderableFrame;
import menu.UpdateScoreBoardThread;
import navigationView.JElementFactory;
import rendering.thread.PeriodicExecutionService;

public class PlayerModeSelectFrame
implements RenderableFrame,
KeyListener {
    private GameController gameController;
    private BaseJFrameWrapper baseJFrameWrapper;
    private DefaultListModel<String> scoreBoardModel;
    private UpdateScoreBoardThread updateScoreBoardThread;

    public PlayerModeSelectFrame(GameController gameController) {
        this.baseJFrameWrapper = gameController.getBaseJFrameWrapper();
        this.gameController = gameController;
    }

    @Override
    public void render() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double width = screenSize.getWidth();
        double height = screenSize.getHeight();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JButton singlePlayerButton = JElementFactory.createButton("[1] Singleplayer");
        JButton splitScreenButton = JElementFactory.createButton("[2] Splitscreen");
        JButton networkButton = JElementFactory.createButton("[3] LAN");
        JButton onlineButton = JElementFactory.createButton("[4] Online");
        JButton closeButton = JElementFactory.createButton("[ESC] Close");
        JCheckBox easyModeCheckBox = new JCheckBox("Classic Mode");
        easyModeCheckBox.setForeground(Color.white);
        easyModeCheckBox.setBackground(Color.darkGray);
        JCheckBox treasureModeCheckBox = new JCheckBox("Treasure Mode (for 2+ players)");
        treasureModeCheckBox.setForeground(Color.white);
        treasureModeCheckBox.setBackground(Color.darkGray);
        JCheckBox fullScreenCheckBox = new JCheckBox("Full Screen");
        fullScreenCheckBox.setForeground(Color.white);
        fullScreenCheckBox.setBackground(Color.darkGray);
        JCheckBox preferSplitscreenCheckBox = new JCheckBox("Prefer Splitscreen over Network");
        GameSettings gameSettings = this.gameController.getGameSettings();
        easyModeCheckBox.setSelected(gameSettings.isEasyMode());
        treasureModeCheckBox.setSelected(gameSettings.isTreasureMode());
        fullScreenCheckBox.setSelected(gameSettings.isUseFullScreen());
        preferSplitscreenCheckBox.setSelected(gameSettings.isPreferNetworkSplitscreen());
        easyModeCheckBox.addItemListener(e -> gameSettings.setEasyMode(e.getStateChange() == 1));
        treasureModeCheckBox.addItemListener(e -> gameSettings.setTreasureMode(e.getStateChange() == 1));
        fullScreenCheckBox.addItemListener(e -> {
            gameSettings.setUseFullScreen(e.getStateChange() == 1);
            this.baseJFrameWrapper.setFullScreen(e.getStateChange() == 1);
        });
        preferSplitscreenCheckBox.addItemListener(e -> gameSettings.setPreferNetworkSplitscreen(e.getStateChange() == 1));
        singlePlayerButton.setPreferredSize(new Dimension((int)width / 3, (int)height / 10));
        splitScreenButton.setPreferredSize(new Dimension((int)width / 3, (int)height / 10));
        networkButton.setPreferredSize(new Dimension((int)width / 3, (int)height / 10));
        onlineButton.setPreferredSize(new Dimension((int)width / 3, (int)height / 10));
        closeButton.setPreferredSize(new Dimension((int)width / 6, (int)height / 18));
        singlePlayerButton.addActionListener(evt -> this.applyPlayerMode(PlayerMode.SINGLE));
        splitScreenButton.addActionListener(evt -> this.applyPlayerMode(PlayerMode.SPLITSCREEN));
        networkButton.addActionListener(evt -> this.applyPlayerMode(PlayerMode.NETWORK));
        onlineButton.addActionListener(evt -> this.applyPlayerMode(PlayerMode.ONLINE));
        closeButton.addActionListener(evt -> this.closeGame());
        JPanel optionBox = JElementFactory.createPanel();
        optionBox.add(easyModeCheckBox);
        optionBox.add(treasureModeCheckBox);
        optionBox.add(fullScreenCheckBox);
        JPanel scoreBoardPanel = new JPanel();
        scoreBoardPanel.setBackground(new Color(90, 90, 90));
        this.scoreBoardModel = this.gameController.getScoreBoardModel();
        if (this.scoreBoardModel == null) {
            this.scoreBoardModel = new DefaultListModel();
            this.scoreBoardModel.add(0, "no server connection");
        }
        JList<String> scoreBoard = new JList<String>(this.scoreBoardModel);
        scoreBoard.setSelectionModel(new OnlineLobbyFrame.DisabledItemSelectionModel());
        scoreBoard.setPreferredSize(new Dimension((int)width / 6, (int)(height / 1.9)));
        JLabel infoLabel = JElementFactory.createLabel("Highscore:");
        infoLabel.setFont(infoLabel.getFont().deriveFont(30.0f));
        scoreBoardPanel.add(infoLabel);
        scoreBoardPanel.add(scoreBoard);
        scoreBoardPanel.setPreferredSize(new Dimension((int)width / 6, (int)(height / 1.88)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)optionBox, gbc);
        gbc.insets = new Insets((int)height / 45, (int)width / 200, (int)height / 45, (int)width / 200);
        gbc.gridy = 1;
        panel.add((Component)singlePlayerButton, gbc);
        gbc.gridy = 2;
        panel.add((Component)splitScreenButton, gbc);
        gbc.gridy = 3;
        panel.add((Component)networkButton, gbc);
        gbc.gridy = 4;
        panel.add((Component)onlineButton, gbc);
        gbc.insets = new Insets((int)height / 22, (int)width / 200, (int)height / 22, (int)width / 200);
        gbc.gridy = 5;
        panel.add((Component)closeButton, gbc);
        gbc.insets = new Insets((int)height / 25, (int)width / 100, (int)height / 120, (int)width / 100);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 5;
        panel.add((Component)scoreBoardPanel, gbc);
        this.baseJFrameWrapper.updateJFrameForMenu(panel, this);
        this.baseJFrameWrapper.requestFocus();
        this.updateScoreBoardThread = new UpdateScoreBoardThread(this);
        new PeriodicExecutionService(this.updateScoreBoardThread).start(5000L, 0L);
    }

    public void applyPlayerMode(PlayerMode playerMode) {
        this.updateScoreBoardThread.stopThread();
        this.gameController.selectPlayerMode(playerMode);
    }

    public void closeGame() {
        this.gameController.storeSettings();
        this.baseJFrameWrapper.close();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 49) {
            this.applyPlayerMode(PlayerMode.SINGLE);
        } else if (e.getKeyCode() == 50) {
            this.applyPlayerMode(PlayerMode.SPLITSCREEN);
        } else if (e.getKeyCode() == 51) {
            this.applyPlayerMode(PlayerMode.NETWORK);
        } else if (e.getKeyCode() == 52) {
            this.applyPlayerMode(PlayerMode.ONLINE);
        } else if (e.getKeyCode() == 27) {
            this.closeGame();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void setupScoreBoardContent(ArrayList<ScoreBoardRecord> scoreBoardRecordList) {
        this.scoreBoardModel.clear();
        for (ScoreBoardRecord scoreBoardRecord : scoreBoardRecordList) {
            this.scoreBoardModel.addElement(scoreBoardRecord.toString());
        }
        this.gameController.setScoreBoardModel(this.scoreBoardModel);
    }
}

