/*
 * Decompiled with CFR 0.152.
 */
package menu;

import gameServer.ClientSide.GameCoordinatorConnection;
import gameServer.ScoreBoard.ScoreBoardRecord;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import menu.PlayerModeSelectFrame;
import network.ReadWriteHelper;
import network.SerializableNetworkObject;

public class UpdateScoreBoardThread
extends Thread {
    private PlayerModeSelectFrame callBackFrame;
    private GameCoordinatorConnection gameCoordinatorConnection;
    private boolean enabled = true;

    public UpdateScoreBoardThread(PlayerModeSelectFrame callBackFrame) {
        this.callBackFrame = callBackFrame;
    }

    @Override
    public void run() {
        if (!this.enabled) {
            return;
        }
        boolean justCreated = false;
        if (this.gameCoordinatorConnection == null) {
            this.gameCoordinatorConnection = new GameCoordinatorConnection();
            if (!this.gameCoordinatorConnection.connect(3000)) {
                return;
            }
            justCreated = true;
        }
        Socket socket = this.gameCoordinatorConnection.getClientSocket();
        try {
            if (!socket.isConnected()) {
                this.gameCoordinatorConnection = null;
                return;
            }
            if (!justCreated) {
                ReadWriteHelper.writeSocketMessage(socket, "getScoreBoard");
            }
            SerializableNetworkObject serializableNetworkObject = ReadWriteHelper.readSocketObject(socket);
            ArrayList<ScoreBoardRecord> scoreBoardRecordList = serializableNetworkObject.getLobbyUpdateRecord().getScoreBoardRecordList();
            this.callBackFrame.setupScoreBoardContent(scoreBoardRecordList);
        }
        catch (IOException | ClassNotFoundException e) {
            this.enabled = false;
        }
    }

    public void stopThread() {
        this.enabled = false;
        if (this.gameCoordinatorConnection == null) {
            return;
        }
        this.gameCoordinatorConnection.disconnect(true);
    }
}

