/*
 * Decompiled with CFR 0.152.
 */
package navigationView;

import java.util.HashMap;
import labyrinthField.AngleDistanceCalculator;
import labyrinthField.Way;
import navigationView.Direction;
import navigationView.DirectionWay;

public class DirectionAssignment {
    private double distance = 0.0;
    HashMap<Direction, DirectionWay> assignments = new HashMap();

    public DirectionAssignment addWay(Direction direction, DirectionWay way) {
        this.assignments.put(direction, way);
        this.distance += AngleDistanceCalculator.getDistanceBetweenRadAngles(way.getCurrentRadAngle(), direction.getRadAngle());
        return this;
    }

    public double getDistance() {
        return this.distance;
    }

    public HashMap<Direction, DirectionWay> getAssignments() {
        return this.assignments;
    }

    public Way getDirectionByDegrees(int pushedAngle) {
        Direction direction = Direction.getByDegree(pushedAngle);
        if (direction == null) {
            return null;
        }
        if (!this.assignments.containsKey((Object)direction)) {
            return null;
        }
        return this.assignments.get((Object)direction).getWay();
    }
}

