/*
 * Decompiled with CFR 0.152.
 */
package navigationView;

import java.io.Serializable;

public class DirectionInput
implements Serializable {
    private boolean upPushed = false;
    private boolean downPushed = false;
    private boolean leftPushed = false;
    private boolean rightPushed = false;

    public DirectionInput(boolean upPushed, boolean downPushed, boolean leftPushed, boolean rightPushed) {
        this.upPushed = upPushed;
        this.downPushed = downPushed;
        this.leftPushed = leftPushed;
        this.rightPushed = rightPushed;
    }

    public DirectionInput() {
    }

    public DirectionInput(double radAngle) {
        double angle = (radAngle / Math.PI * 180.0 + 360.0) % 360.0;
        if (angle < 75.0 || angle > 285.0) {
            this.rightPushed = true;
        }
        if (angle < 165.0 && angle > 15.0) {
            this.downPushed = true;
        }
        if (angle < 255.0 && angle > 105.0) {
            this.leftPushed = true;
        }
        if (angle < 345.0 && angle > 195.0) {
            this.upPushed = true;
        }
    }

    public void setUpPushed(boolean upPushed) {
        this.upPushed = upPushed;
    }

    public void setDownPushed(boolean downPushed) {
        this.downPushed = downPushed;
    }

    public void setLeftPushed(boolean leftPushed) {
        this.leftPushed = leftPushed;
    }

    public void setRightPushed(boolean rightPushed) {
        this.rightPushed = rightPushed;
    }

    public boolean isUpPushed() {
        return this.upPushed;
    }

    public boolean isDownPushed() {
        return this.downPushed;
    }

    public boolean isLeftPushed() {
        return this.leftPushed;
    }

    public boolean isRightPushed() {
        return this.rightPushed;
    }

    public boolean isOppositeKeyPushed(DirectionInput directionInput) {
        return this.rightPushed && directionInput.isLeftPushed() || this.leftPushed && directionInput.isRightPushed() || this.downPushed && directionInput.isUpPushed() || this.upPushed && directionInput.isDownPushed();
    }

    public DirectionInput getOpposite() {
        return new DirectionInput(this.downPushed, this.upPushed, this.rightPushed, this.leftPushed);
    }
}

