/*
 * Decompiled with CFR 0.152.
 */
package navigationView;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import labyrinthField.Point;
import labyrinthField.Treasure;
import labyrinthField.Way;
import navigationView.Closable;
import navigationView.Direction;
import navigationView.GameState;
import navigationView.KeyConfig;
import navigationView.PlayerEffect;
import navigationView.ViewModel;
import network.LabyrinthFieldMetaData;
import network.VictoryMetaData;
import rendering.ColoredLabyrinthComponent;
import rendering.ImageRenderer;
import rendering.SimpleLabyrinthComponent;

public class LabyrinthNavigationView
extends JPanel {
    private static final long serialVersionUID = -2143685347023784912L;
    private JLabel imageLabel;
    private ColoredLabyrinthComponent coloredLabyrinthComponent;
    private SimpleLabyrinthComponent simpleLabyrinthComponent;
    private BufferedImage bufferedImage;
    private ViewModel viewModel;
    private KeyConfig keyConfig;
    private Closable closable;
    private double scaleFactor;
    private long lockMoving = 0L;
    private boolean readyToStartMultiplayer = true;
    private boolean allPlayersReady = false;
    private HashSet<Integer> playerReadySet = new HashSet();
    private long startPushed = 0L;
    private JComponent currentShownComponent;

    public LabyrinthNavigationView(ViewModel viewModel, boolean show) {
        this.viewModel = viewModel;
        this.keyConfig = new KeyConfig();
        this.keyConfig.enableWasdCommands();
        this.scaleFactor = viewModel.getScaleFactor();
        if (show) {
            this.initComponent();
        }
    }

    public LabyrinthNavigationView(ViewModel viewModel, KeyConfig keyConfig, double scaleFactor) {
        this.viewModel = viewModel;
        this.keyConfig = keyConfig;
        this.scaleFactor = scaleFactor;
        if (!viewModel.getViewModelProperties().isSplitScreen() || viewModel.getViewModelProperties().isNetwork()) {
            keyConfig.enableWasdCommands();
        }
        this.initComponent();
    }

    private void initComponent() {
        this.imageLabel = new JLabel();
        this.add(this.imageLabel);
        this.setLayout(new GridLayout(1, 0));
        this.imageLabel.setHorizontalTextPosition(0);
        this.imageLabel.setVerticalTextPosition(0);
        this.imageLabel.setFont(this.imageLabel.getFont().deriveFont(15.0f * (float)this.scaleFactor));
        this.imageLabel.setHorizontalAlignment(0);
        this.imageLabel.setVerticalAlignment(0);
        this.imageLabel.setForeground(Color.white);
        this.imageLabel.setBackground(Color.DARK_GRAY);
        if (this.viewModel.isBestOfThenMode()) {
            this.imageLabel.setText("Play 10 labyrinths to win the game. Start with Enter!");
        } else {
            this.imageLabel.setText("Start with Enter!");
        }
        this.setBackground(Color.DARK_GRAY);
        this.currentShownComponent = this.imageLabel;
    }

    public void showLabyrinth(int[] image) {
        if (this.viewModel.getGameState() == GameState.PLAYING) {
            this.bufferedImage.getRaster().setDataElements(0, 0, this.viewModel.getWindowWidth(), this.viewModel.getWindowHeight(), image);
            this.imageLabel.setText(null);
            this.imageLabel.setIcon(new ImageIcon(this.bufferedImage));
        }
    }

    public void showLabyrinth() {
        if (this.simpleLabyrinthComponent == null) {
            this.simpleLabyrinthComponent = new SimpleLabyrinthComponent();
            this.simpleLabyrinthComponent.setVisible(true);
        }
        if (this.viewModel.getGameState() == GameState.PLAYING) {
            this.showSimpleLabyrinthComponent();
            Point currentPosition = this.viewModel.getCurrentPosition();
            this.simpleLabyrinthComponent.setRenderData(this.viewModel.buildLabyrinthMetaData(), this.getWidth(), this.getHeight(), currentPosition.getxPosition(), currentPosition.getyPosition(), this.viewModel.getTimeout());
        }
    }

    public boolean showContDown() {
        if (this.viewModel.getGameState() == GameState.WAITING) {
            if (this.lockMoving == -1L) {
                this.lockMoving = new Date().getTime();
                this.showText("Game starts in 3");
                return true;
            }
            if (this.lockMoving != 0L) {
                long diff = new Date().getTime() - this.lockMoving;
                if (diff < 900L) {
                    return true;
                }
                if (diff < 1900L) {
                    this.showText("Game starts in 3, 2");
                    return true;
                }
                if (diff < 2900L) {
                    this.showText("Game starts in 3, 2, 1");
                    return true;
                }
            }
            this.lockMoving = 0L;
            if (this.readyToStartMultiplayer) {
                this.viewModel.startGame();
            }
        }
        return false;
    }

    public void checkStartPushed() {
        if (this.viewModel.getGameState() == GameState.VICTORY_SCREEN && this.startPushed != 0L && new Date().getTime() > this.startPushed + 10000L) {
            this.pressedEnterForGameStart();
        }
    }

    public void checkContDown() {
        if (this.viewModel.getGameState() == GameState.WAITING) {
            long diff;
            if (this.lockMoving == -1L) {
                this.lockMoving = new Date().getTime();
                return;
            }
            if (this.lockMoving != 0L && (diff = new Date().getTime() - this.lockMoving) < 2900L) {
                return;
            }
            this.lockMoving = 0L;
            if (this.readyToStartMultiplayer) {
                this.viewModel.startGame();
            }
        }
    }

    public void showColoredLabyrinth(LabyrinthFieldMetaData labyrinthFieldMetaData, int width, int height, HashMap<Integer, Point> pointMap, int currentPlayerNumber, long timeout, ArrayList<Treasure> treasureList, ArrayList<Way> wayToGoal, ArrayList<PlayerEffect> activePlayerEffectList) {
        if (this.coloredLabyrinthComponent == null) {
            this.coloredLabyrinthComponent = new ColoredLabyrinthComponent();
            this.coloredLabyrinthComponent.setVisible(true);
        }
        if (this.viewModel.getGameState() == GameState.PLAYING) {
            this.showColoredLabyrinthComponent();
        }
        if (this.currentShownComponent != this.imageLabel) {
            this.coloredLabyrinthComponent.setRenderData(labyrinthFieldMetaData, pointMap, currentPlayerNumber, timeout, treasureList, wayToGoal, activePlayerEffectList);
        }
    }

    public void close() {
        this.closable.close();
    }

    public void setClosable(Closable closable) {
        this.closable = closable;
    }

    public ViewModel getViewModel() {
        return this.viewModel;
    }

    public void keyPressed(KeyEvent e) {
        this.keyPressedKeyCode(e.getKeyCode());
    }

    public void keyPressedKeyCode(int keyCode) {
        if (this.lockMoving != 0L) {
            return;
        }
        if (keyCode == this.keyConfig.getClose()) {
            this.closable.close();
        } else if (this.viewModel.getGameState() == GameState.PLAYING) {
            if (keyCode == this.keyConfig.getRight()) {
                this.viewModel.updateDirectionInput(Direction.RIGHT, true);
            } else if (keyCode == this.keyConfig.getLeft()) {
                this.viewModel.updateDirectionInput(Direction.LEFT, true);
            } else if (keyCode == this.keyConfig.getDown()) {
                this.viewModel.updateDirectionInput(Direction.DOWN, true);
            } else if (keyCode == this.keyConfig.getUp()) {
                this.viewModel.updateDirectionInput(Direction.UP, true);
            } else {
                this.checkAlternateKeys(keyCode, true);
            }
        } else if (keyCode == this.keyConfig.getStart()) {
            if (this.viewModel.getGameState() == GameState.END_SCREEN && this.viewModel.areListenersReady() && this.closable != null) {
                this.closable.close();
            }
            if (this.viewModel.getViewModelProperties().isNetwork()) {
                this.playerPressedEnter(0, this.viewModel.getPlayerNameList().size());
                this.showText("Waiting for other players...");
            } else {
                this.pressedEnterForGameStart();
            }
        }
    }

    private void pressedEnterForGameStart() {
        if (this.viewModel.getGameState() == GameState.END_SCREEN && this.viewModel.areListenersReady()) {
            if (this.closable != null) {
                this.closable.close();
            }
            return;
        }
        if (this.viewModel.isResetable()) {
            if (this.viewModel.getField() == null || !this.viewModel.getViewModelProperties().shouldResetFieldAfterVictory()) {
                this.viewModel.reset();
            }
            if (!this.viewModel.getViewModelProperties().isNetwork() || this.viewModel.getViewModelProperties().isSplitScreen()) {
                this.viewModel.startGame();
                return;
            }
            if (!this.readyToStartMultiplayer) {
                this.allPlayersReady = true;
                return;
            }
            this.startGame();
        }
    }

    private void startGame() {
        this.allPlayersReady = false;
        this.lockMoving = -1L;
        this.viewModel.startGameCountdown();
        this.playerReadySet = new HashSet();
        this.startPushed = 0L;
    }

    private void checkAlternateKeys(int keyCode, boolean pushAction) {
        if (keyCode == this.keyConfig.getAlternateRight()) {
            this.viewModel.updateDirectionInput(Direction.RIGHT, pushAction);
        } else if (keyCode == this.keyConfig.getAlternateLeft()) {
            this.viewModel.updateDirectionInput(Direction.LEFT, pushAction);
        } else if (keyCode == this.keyConfig.getAlternateDown()) {
            this.viewModel.updateDirectionInput(Direction.DOWN, pushAction);
        } else if (keyCode == this.keyConfig.getAlternateUp()) {
            this.viewModel.updateDirectionInput(Direction.UP, pushAction);
        } else if (keyCode == this.keyConfig.getUpLeft()) {
            this.viewModel.updateDirectionInput(Direction.LEFT, pushAction);
            this.viewModel.updateDirectionInput(Direction.UP, pushAction);
        } else if (keyCode == this.keyConfig.getUpRight()) {
            this.viewModel.updateDirectionInput(Direction.RIGHT, pushAction);
            this.viewModel.updateDirectionInput(Direction.UP, pushAction);
        } else if (keyCode == this.keyConfig.getDownLeft() || this.keyConfig.getDownLeft() == 89 && keyCode == 90) {
            this.viewModel.updateDirectionInput(Direction.LEFT, pushAction);
            this.viewModel.updateDirectionInput(Direction.DOWN, pushAction);
        } else if (keyCode == this.keyConfig.getDownRight()) {
            this.viewModel.updateDirectionInput(Direction.RIGHT, pushAction);
            this.viewModel.updateDirectionInput(Direction.DOWN, pushAction);
        } else if (this.keyConfig.isWasdEnabled()) {
            if (keyCode == 68) {
                this.viewModel.updateDirectionInput(Direction.RIGHT, pushAction);
            } else if (keyCode == 65) {
                this.viewModel.updateDirectionInput(Direction.LEFT, pushAction);
            } else if (keyCode == 83 || keyCode == 88) {
                this.viewModel.updateDirectionInput(Direction.DOWN, pushAction);
            } else if (keyCode == 87) {
                this.viewModel.updateDirectionInput(Direction.UP, pushAction);
            } else if (keyCode == 81) {
                this.viewModel.updateDirectionInput(Direction.LEFT, pushAction);
                this.viewModel.updateDirectionInput(Direction.UP, pushAction);
            } else if (keyCode == 69) {
                this.viewModel.updateDirectionInput(Direction.RIGHT, pushAction);
                this.viewModel.updateDirectionInput(Direction.UP, pushAction);
            } else if (keyCode == 89 || keyCode == 90) {
                this.viewModel.updateDirectionInput(Direction.LEFT, pushAction);
                this.viewModel.updateDirectionInput(Direction.DOWN, pushAction);
            } else if (keyCode == 67) {
                this.viewModel.updateDirectionInput(Direction.RIGHT, pushAction);
                this.viewModel.updateDirectionInput(Direction.DOWN, pushAction);
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        this.keyReleasedKeyCode(e.getKeyCode());
    }

    public void keyReleasedKeyCode(int keyCode) {
        if (this.viewModel.getGameState() == GameState.PLAYING) {
            if (keyCode == this.keyConfig.getRight()) {
                this.viewModel.updateDirectionInput(Direction.RIGHT, false);
            } else if (keyCode == this.keyConfig.getLeft()) {
                this.viewModel.updateDirectionInput(Direction.LEFT, false);
            } else if (keyCode == this.keyConfig.getDown()) {
                this.viewModel.updateDirectionInput(Direction.DOWN, false);
            } else if (keyCode == this.keyConfig.getUp()) {
                this.viewModel.updateDirectionInput(Direction.UP, false);
            } else {
                this.checkAlternateKeys(keyCode, false);
            }
        }
    }

    public void shareSize(int width, int height) {
        this.viewModel.setWindowHeight(height);
        this.viewModel.setWindowWidth(width);
        this.bufferedImage = new BufferedImage(width, height, 2);
    }

    public VictoryMetaData showVictory() {
        VictoryMetaData victoryMetaData = this.createVictoryMetaData();
        this.showImageLabel();
        ImageRenderer.renderVictory(this.imageLabel, victoryMetaData, this.scaleFactor);
        if (this.viewModel.isResetable() && this.viewModel.getViewModelProperties().shouldResetFieldAfterVictory()) {
            this.viewModel.reset();
        }
        return victoryMetaData;
    }

    public VictoryMetaData createVictoryMetaData() {
        VictoryMetaData victoryMetaData = this.viewModel.buildVictoryMetaData();
        if (!this.viewModel.isBestOfThenMode()) {
            this.viewModel.setGameState(GameState.END_SCREEN);
        } else if (victoryMetaData.getScoreTableMetaData().length > ViewModel.numberOfRounds - 1) {
            this.viewModel.setGameState(GameState.END_SCREEN);
        } else if (victoryMetaData.getScoreTableMetaData().length == 1) {
            this.viewModel.setGameState(GameState.VICTORY_SCREEN);
        } else {
            this.viewModel.setGameState(GameState.VICTORY_SCREEN);
        }
        return victoryMetaData;
    }

    public void renderVictoryWithColor(HashMap<Integer, VictoryMetaData> victoryMetaDataMap, ArrayList<String> playerNameList) {
        this.showImageLabel();
        ImageRenderer.renderVictoryColored(this.imageLabel, victoryMetaDataMap, playerNameList, 0, this.scaleFactor, true);
        if (this.viewModel.isResetable()) {
            this.viewModel.reset();
        }
    }

    public void markAsDisconnected() {
        this.viewModel.markAsDisconnected();
    }

    public void setReadyToStart(boolean readyToStartMultiplayer) {
        this.readyToStartMultiplayer = readyToStartMultiplayer;
        if (readyToStartMultiplayer && this.allPlayersReady) {
            this.startGame();
        }
    }

    public void resetField() {
        if (this.viewModel.isResetable()) {
            this.viewModel.reset();
        }
    }

    public void playerPressedEnter(int playerNumber, int numberOfConnectedPlayers) {
        if (this.lockMoving != 0L) {
            return;
        }
        this.playerReadySet.add(playerNumber);
        if (this.startPushed == 0L) {
            this.startPushed = new Date().getTime();
        }
        if (this.playerReadySet.size() >= numberOfConnectedPlayers) {
            this.pressedEnterForGameStart();
        }
    }

    private void showText(String text) {
        this.showImageLabel();
        this.imageLabel.setText(text);
        this.imageLabel.setIcon(null);
    }

    private void showImageLabel() {
        if (this.currentShownComponent == this.coloredLabyrinthComponent) {
            this.remove(this.coloredLabyrinthComponent);
            this.add(this.imageLabel);
            this.currentShownComponent = this.imageLabel;
            this.revalidate();
        }
        if (this.currentShownComponent == this.simpleLabyrinthComponent) {
            this.remove(this.simpleLabyrinthComponent);
            this.add(this.imageLabel);
            this.currentShownComponent = this.imageLabel;
            this.revalidate();
        }
    }

    private void showColoredLabyrinthComponent() {
        if (this.currentShownComponent == this.imageLabel) {
            this.remove(this.imageLabel);
            this.add(this.coloredLabyrinthComponent);
            this.currentShownComponent = this.coloredLabyrinthComponent;
            this.revalidate();
        }
    }

    private void showSimpleLabyrinthComponent() {
        if (this.currentShownComponent == this.imageLabel) {
            this.remove(this.imageLabel);
            this.add(this.simpleLabyrinthComponent);
            this.currentShownComponent = this.simpleLabyrinthComponent;
            this.revalidate();
        }
    }
}

