/*
 * Decompiled with CFR 0.152.
 */
package navigationView;

import game.utils.LogHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import labyrinthField.Point;
import labyrinthField.Treasure;
import labyrinthField.TreasureType;
import menu.BaseJFrameWrapper;
import menu.GameController;
import menu.RenderableFrame;
import navigationView.Direction;
import navigationView.GameState;
import navigationView.KeyConfig;
import navigationView.MultiplayerClientView;
import navigationView.PickupTreasureEvent;
import navigationView.PlayerEffect;
import navigationView.ViewModel;
import network.ClientConnection;
import network.LabyrinthFieldMetaData;
import network.Player;
import network.ReadWriteHelper;
import network.SerializableNetworkObject;
import network.UpdateRecord;
import network.VictoryMetaData;
import rendering.ColoredLabyrinthComponent;
import rendering.ImageRenderer;
import rendering.thread.MultiplayerClientStepThread;
import rendering.thread.PeriodicExecutionService;

public class MultiplayerClientViewColored
implements RenderableFrame,
KeyListener,
MultiplayerClientView {
    private JLabel imageLabel;
    private JPanel panel;
    private ColoredLabyrinthComponent coloredLabyrinthComponent;
    private GameController gameController;
    private BaseJFrameWrapper baseJFrameWrapper;
    private ClientConnection connection;
    private LabyrinthFieldMetaData labyrinthFieldMetaData;
    private long timeout = 0L;
    private HashMap<Integer, GameState> gameStateMap = new HashMap();
    private int playerNumber;
    private HashMap<Integer, ViewModel> renderViewModelMap;
    private ViewModel playerViewModel;
    private KeyConfig keyConfig;
    private PeriodicExecutionService localRenderExecutorService;
    private boolean needLabyrinthFieldUpdate = true;
    private boolean isHost;
    private long lockMoving = 0L;
    private JComponent currentShownComponent;

    public MultiplayerClientViewColored(GameController gameController, ClientConnection connection, boolean isHost) {
        this.gameController = gameController;
        this.baseJFrameWrapper = gameController.getBaseJFrameWrapper();
        this.connection = connection;
        this.isHost = isHost;
        this.playerNumber = connection.getPlayer().getPlayerNumber();
        this.keyConfig = new KeyConfig();
    }

    @Override
    public void render() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayout(1, 0));
        this.imageLabel = new JLabel();
        this.panel.add(this.imageLabel);
        this.imageLabel.setHorizontalTextPosition(0);
        this.imageLabel.setHorizontalAlignment(0);
        this.imageLabel.setVerticalAlignment(0);
        this.imageLabel.setText("Press Enter to start the game");
        this.imageLabel.setForeground(Color.white);
        this.imageLabel.setBackground(Color.DARK_GRAY);
        this.baseJFrameWrapper.updateJFrameForGame(this.panel, this);
        this.currentShownComponent = this.imageLabel;
    }

    @Override
    public void setLabyrinthFieldMetaData(LabyrinthFieldMetaData labyrinthFieldMetaData) {
        this.needLabyrinthFieldUpdate = false;
        this.labyrinthFieldMetaData = labyrinthFieldMetaData;
    }

    private void initializeRound() {
        this.renderViewModelMap = new HashMap();
        for (int i = 0; i < this.labyrinthFieldMetaData.getPlayerNameList().size(); ++i) {
            Player player = new Player();
            player.setName(this.labyrinthFieldMetaData.getPlayerNameList().get(i));
            player.setPlayerNumber(i);
            this.renderViewModelMap.put(i, new ViewModel(this.labyrinthFieldMetaData.getLabyrinthField(), this.labyrinthFieldMetaData.getNavigationMode(), this.labyrinthFieldMetaData.getWindowWidth(), this.labyrinthFieldMetaData.getWindowHeight(), false, i != this.playerNumber, this.labyrinthFieldMetaData.isBestOfTenMode(), player));
            if (this.gameStateMap.get(i) == GameState.DISCONNECTED) {
                player.setDisconnected(true);
            } else {
                this.gameStateMap.put(i, GameState.WAITING);
            }
            this.renderViewModelMap.get(i).setGameState(this.gameStateMap.get(i));
        }
        this.playerViewModel = this.renderViewModelMap.get(this.playerNumber);
        if (this.localRenderExecutorService != null) {
            this.localRenderExecutorService.stop();
        }
        this.localRenderExecutorService = new PeriodicExecutionService(new MultiplayerClientStepThread(this.renderViewModelMap));
        this.localRenderExecutorService.start(ViewModel.getMillisecondsForStep(), 100L);
    }

    @Override
    public void startTheGame() {
        this.lockMoving = -1L;
    }

    public void checkContDown() {
        if (this.lockMoving != 0L) {
            long diff;
            if (this.needLabyrinthFieldUpdate) {
                return;
            }
            if (this.lockMoving == -1L) {
                this.showText("Game starts in 3");
                this.lockMoving = new Date().getTime();
                this.initializeRound();
            }
            if ((diff = new Date().getTime() - this.lockMoving) < 900L) {
                return;
            }
            if (diff < 1900L) {
                this.showText("Game starts in 3, 2");
                return;
            }
            if (diff < 2900L) {
                this.showText("Game starts in 3, 2, 1");
                return;
            }
            this.lockMoving = 0L;
            for (int i = 0; i < this.connection.getNumberOfPlayers(); ++i) {
                this.setGameStateForPlayerNumber(i, GameState.PLAYING);
            }
            this.setTimeout(this.playerViewModel.getTimeout());
            this.playerViewModel.triggerRenderUpdate();
        }
    }

    @Override
    public void showMessageDialog(String message) {
        this.baseJFrameWrapper.showDialog(message);
    }

    @Override
    public void applyPickupTreasureEvent(PickupTreasureEvent pickupTreasureEvent) {
        Treasure treasure = this.playerViewModel.getTreasureById(pickupTreasureEvent.getTreasureId());
        if (treasure == null) {
            LogHandler.notifyDebugMessage("treasure not found");
            return;
        }
        for (ViewModel viewModel : this.renderViewModelMap.values()) {
            viewModel.pickUpTreasure(pickupTreasureEvent.getTreasureId());
        }
        long effectElapseTime = new Date().getTime() + 30000L;
        if (treasure.getTreasureType() == TreasureType.SLOW_OTHERS) {
            effectElapseTime = new Date().getTime() + 15000L;
        }
        long showUntilTime = new Date().getTime() + 10000L;
        int pickupPlayerNumber = pickupTreasureEvent.getPlayerNumber();
        switch (treasure.getTreasureType()) {
            case SPEED_SELF: 
            case SLOW_SELF: 
            case SLOW_OTHERS: {
                for (ViewModel viewModel : this.renderViewModelMap.values()) {
                    viewModel.addPlayerEffect(new PlayerEffect(treasure.getTreasureType(), effectElapseTime, pickupPlayerNumber, pickupPlayerNumber, treasure.getId(), showUntilTime));
                }
                break;
            }
            case SLOW_FIRST: {
                for (ViewModel viewModel : this.renderViewModelMap.values()) {
                    viewModel.addPlayerEffect(new PlayerEffect(treasure.getTreasureType(), effectElapseTime, pickupPlayerNumber, pickupTreasureEvent.getSecondPlayerNumber(), treasure.getId(), showUntilTime));
                }
                break;
            }
            case SHOW_WAY_TO_GOAL: {
                effectElapseTime = new Date().getTime() + 5000L;
                showUntilTime = new Date().getTime() + 5000L;
                if (this.playerNumber != pickupTreasureEvent.getPlayerNumber()) break;
                this.playerViewModel.addPlayerEffect(new PlayerEffect(TreasureType.SHOW_WAY_TO_GOAL, effectElapseTime, pickupPlayerNumber, this.playerNumber, treasure.getId(), showUntilTime));
                break;
            }
            case INVERT: {
                effectElapseTime = new Date().getTime() + 10000L;
                if (this.playerNumber != pickupTreasureEvent.getPlayerNumber()) break;
                this.playerViewModel.addPlayerEffect(new PlayerEffect(TreasureType.INVERT, effectElapseTime, pickupPlayerNumber, this.playerNumber, treasure.getId(), showUntilTime));
                break;
            }
            case CHANGE: {
                ViewModel viewModel1 = this.renderViewModelMap.get(pickupTreasureEvent.getPlayerNumber());
                if (pickupTreasureEvent.getSecondPlayerNumber() == -1) break;
                ViewModel viewModel2 = this.renderViewModelMap.get(pickupTreasureEvent.getSecondPlayerNumber());
                viewModel1.switchPositions(viewModel2);
                this.playerViewModel.addPlayerEffect(new PlayerEffect(TreasureType.CHANGE, showUntilTime, pickupPlayerNumber, this.playerNumber, treasure.getId(), showUntilTime));
            }
        }
    }

    public void setGameStateForPlayerNumber(int playerNumber, GameState gameState) {
        if (this.gameStateMap.get(playerNumber) == GameState.DISCONNECTED) {
            return;
        }
        this.gameStateMap.put(playerNumber, gameState);
        if (this.renderViewModelMap != null && this.renderViewModelMap.containsKey(playerNumber)) {
            this.renderViewModelMap.get(playerNumber).setGameState(gameState);
        }
    }

    @Override
    public void updateView(UpdateRecord updateRecord) {
        if (updateRecord.getLabyrinthNumber() == this.playerNumber) {
            return;
        }
        ViewModel viewModel = this.renderViewModelMap.get(updateRecord.getLabyrinthNumber());
        if (viewModel == null) {
            return;
        }
        if (updateRecord.getWayVector() == null) {
            viewModel.markAsDisconnected();
            this.setGameStateForPlayerNumber(updateRecord.getLabyrinthNumber(), GameState.DISCONNECTED);
            return;
        }
        viewModel.followWayVector(updateRecord.getWayVector());
    }

    @Override
    public void renderView() {
        this.checkContDown();
        if (this.playerViewModel == null || this.labyrinthFieldMetaData == null || !this.viewNeedsUpdate()) {
            return;
        }
        if (this.getNumberOfDisconnectedPlayers() + this.getNumberOfPlayingPlayers() < this.connection.getNumberOfPlayers()) {
            return;
        }
        this.renderColoredLabyrinth();
        if (this.getNumberOfDisconnectedPlayers() + this.getNumberOfPlayingPlayers() < this.connection.getNumberOfPlayers()) {
            return;
        }
        if (this.renderViewModelMap != null && this.playerViewModel.hasCurrentVectorChanged()) {
            try {
                ReadWriteHelper.writeSocketObject(this.connection.getPlayer().getClient(), new SerializableNetworkObject(this.playerViewModel.getCurrentWayVector()));
            }
            catch (IOException e) {
                LogHandler.notifyException(e);
                this.baseJFrameWrapper.showDialog("Connection lost.");
                this.close(false);
            }
        }
    }

    @Override
    public void renderInitially() {
        this.render();
    }

    private boolean viewNeedsUpdate() {
        for (ViewModel viewModel : this.renderViewModelMap.values()) {
            if (!viewModel.needsRenderUpdate()) continue;
            return true;
        }
        return false;
    }

    public void renderColoredLabyrinth() {
        int width = this.playerViewModel.getWindowWidth();
        int height = this.playerViewModel.getWindowHeight();
        HashMap<Integer, Point> pointMap = new HashMap<Integer, Point>();
        for (Map.Entry<Integer, ViewModel> integerViewModelEntry : this.renderViewModelMap.entrySet()) {
            int currentPlayerNumber = integerViewModelEntry.getKey();
            ViewModel currentViewModel = integerViewModelEntry.getValue();
            if (currentViewModel.getGameState() == GameState.DISCONNECTED) continue;
            pointMap.put(currentPlayerNumber, currentViewModel.getCurrentPosition());
        }
        if (this.coloredLabyrinthComponent == null) {
            this.coloredLabyrinthComponent = new ColoredLabyrinthComponent();
            this.coloredLabyrinthComponent.setVisible(true);
        }
        this.showColoredLabyrinthComponent();
        this.coloredLabyrinthComponent.setRenderData(this.labyrinthFieldMetaData, width, height, pointMap, this.playerNumber, this.timeout, this.playerViewModel.getLeftTreasuresList(), this.playerViewModel.getWayToGoalIfTreasureIsActive(), this.playerViewModel.getPlayerEffectList());
        this.coloredLabyrinthComponent.repaint();
    }

    @Override
    public void showVictory(ArrayList<VictoryMetaData> victoryMetaDataList) {
        if (this.localRenderExecutorService != null) {
            this.localRenderExecutorService.stop();
        }
        HashMap<Integer, VictoryMetaData> victoryMetaDataMap = new HashMap<Integer, VictoryMetaData>();
        for (int i = 0; i < victoryMetaDataList.size(); ++i) {
            if (victoryMetaDataList.get(i) != null) {
                victoryMetaDataMap.put(i, victoryMetaDataList.get(i));
            }
            if (victoryMetaDataList.get(i).getScoreTableMetaData().length > ViewModel.numberOfRounds - 1 || !this.playerViewModel.isBestOfThenMode()) {
                this.setGameStateForPlayerNumber(i, GameState.END_SCREEN);
                continue;
            }
            this.setGameStateForPlayerNumber(i, GameState.VICTORY_SCREEN);
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double width = screenSize.getWidth();
        double scaleFactor = width / 3000.0 + 1.0;
        this.showImageLabel();
        ImageRenderer.renderVictoryColored(this.imageLabel, victoryMetaDataMap, this.labyrinthFieldMetaData.getPlayerNameList(), this.playerNumber, scaleFactor, this.isHost);
        this.needLabyrinthFieldUpdate = true;
    }

    private int getNumberOfDisconnectedPlayers() {
        int numberOfDisconnectedPlayers = 0;
        for (Map.Entry<Integer, ViewModel> integerViewModelEntry : this.renderViewModelMap.entrySet()) {
            if (integerViewModelEntry.getValue().getGameState() != GameState.DISCONNECTED) continue;
            ++numberOfDisconnectedPlayers;
        }
        return numberOfDisconnectedPlayers;
    }

    private int getNumberOfPlayingPlayers() {
        int numberOfWaitingPlayers = 0;
        for (Map.Entry<Integer, ViewModel> integerViewModelEntry : this.renderViewModelMap.entrySet()) {
            if (integerViewModelEntry.getValue().getGameState() != GameState.PLAYING) continue;
            ++numberOfWaitingPlayers;
        }
        return numberOfWaitingPlayers;
    }

    @Override
    public void close(boolean communicateClose) {
        if (communicateClose) {
            this.connection.disconnect();
        } else {
            this.connection.disconnectPlayer(false);
        }
        this.gameController.goBackToPlayerModeSelect();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 10 && this.gameStateMap.get(this.playerNumber) == GameState.END_SCREEN) {
            this.close(this.gameStateMap.get(this.playerNumber) != GameState.END_SCREEN);
            return;
        }
        if (keyEvent.getKeyCode() == 10 && this.gameStateMap.get(this.playerNumber) != GameState.PLAYING) {
            try {
                ReadWriteHelper.writeSocketMessage(this.connection.getPlayer().getClient(), "Enter;");
                if (this.imageLabel != null && this.imageLabel.getText() != null && this.imageLabel.getText().contains(" Enter")) {
                    this.showText("Waiting for other players...");
                }
            }
            catch (IOException e) {
                this.close(false);
                LogHandler.notifyException(e);
            }
            return;
        }
        if (!this.isEssentialNavigationKey(keyEvent.getKeyCode()) || !this.gameStateMap.containsKey(this.playerNumber) || this.gameStateMap.get(this.playerNumber) != GameState.PLAYING || this.connection.getPlayer().isDisconnected()) {
            return;
        }
        if (this.renderViewModelMap != null) {
            this.updateLocalLabyrinthByPressedKeyCode(keyEvent.getKeyCode(), true);
        }
    }

    private void updateLocalLabyrinthByPressedKeyCode(int keyCode, boolean pushAction) {
        if (keyCode == this.keyConfig.getRight()) {
            this.playerViewModel.updateDirectionInput(Direction.RIGHT, pushAction);
        } else if (keyCode == this.keyConfig.getLeft()) {
            this.playerViewModel.updateDirectionInput(Direction.LEFT, pushAction);
        } else if (keyCode == this.keyConfig.getDown()) {
            this.playerViewModel.updateDirectionInput(Direction.DOWN, pushAction);
        } else if (keyCode == this.keyConfig.getUp()) {
            this.playerViewModel.updateDirectionInput(Direction.UP, pushAction);
        } else {
            this.checkAlternateKeys(keyCode, pushAction);
        }
    }

    private void checkAlternateKeys(int keyCode, boolean pushAction) {
        if (keyCode == this.keyConfig.getAlternateRight()) {
            this.playerViewModel.updateDirectionInput(Direction.RIGHT, pushAction);
        } else if (keyCode == this.keyConfig.getAlternateLeft()) {
            this.playerViewModel.updateDirectionInput(Direction.LEFT, pushAction);
        } else if (keyCode == this.keyConfig.getAlternateDown()) {
            this.playerViewModel.updateDirectionInput(Direction.DOWN, pushAction);
        } else if (keyCode == this.keyConfig.getAlternateUp()) {
            this.playerViewModel.updateDirectionInput(Direction.UP, pushAction);
        } else if (keyCode == this.keyConfig.getUpLeft()) {
            this.playerViewModel.updateDirectionInput(Direction.LEFT, pushAction);
            this.playerViewModel.updateDirectionInput(Direction.UP, pushAction);
        } else if (keyCode == this.keyConfig.getUpRight()) {
            this.playerViewModel.updateDirectionInput(Direction.RIGHT, pushAction);
            this.playerViewModel.updateDirectionInput(Direction.UP, pushAction);
        } else if (keyCode == this.keyConfig.getDownLeft() || this.keyConfig.getDownLeft() == 89 && keyCode == 90) {
            this.playerViewModel.updateDirectionInput(Direction.LEFT, pushAction);
            this.playerViewModel.updateDirectionInput(Direction.DOWN, pushAction);
        } else if (keyCode == this.keyConfig.getDownRight()) {
            this.playerViewModel.updateDirectionInput(Direction.RIGHT, pushAction);
            this.playerViewModel.updateDirectionInput(Direction.DOWN, pushAction);
        } else if (keyCode == 68) {
            this.playerViewModel.updateDirectionInput(Direction.RIGHT, pushAction);
        } else if (keyCode == 65) {
            this.playerViewModel.updateDirectionInput(Direction.LEFT, pushAction);
        } else if (keyCode == 83 || keyCode == 88) {
            this.playerViewModel.updateDirectionInput(Direction.DOWN, pushAction);
        } else if (keyCode == 87) {
            this.playerViewModel.updateDirectionInput(Direction.UP, pushAction);
        } else if (keyCode == 81) {
            this.playerViewModel.updateDirectionInput(Direction.LEFT, pushAction);
            this.playerViewModel.updateDirectionInput(Direction.UP, pushAction);
        } else if (keyCode == 69) {
            this.playerViewModel.updateDirectionInput(Direction.RIGHT, pushAction);
            this.playerViewModel.updateDirectionInput(Direction.UP, pushAction);
        } else if (keyCode == 89 || keyCode == 90) {
            this.playerViewModel.updateDirectionInput(Direction.LEFT, pushAction);
            this.playerViewModel.updateDirectionInput(Direction.DOWN, pushAction);
        } else if (keyCode == 67) {
            this.playerViewModel.updateDirectionInput(Direction.RIGHT, pushAction);
            this.playerViewModel.updateDirectionInput(Direction.DOWN, pushAction);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (!this.isEssentialNavigationKey(keyEvent.getKeyCode())) {
            return;
        }
        if (!this.isEssentialNavigationKey(keyEvent.getKeyCode()) || !this.gameStateMap.containsKey(this.playerNumber) || this.gameStateMap.get(this.playerNumber) != GameState.PLAYING || this.connection.getPlayer().isDisconnected()) {
            return;
        }
        if (this.renderViewModelMap != null) {
            this.updateLocalLabyrinthByPressedKeyCode(keyEvent.getKeyCode(), false);
        }
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public int getPlayerNumber() {
        return this.playerNumber;
    }

    private boolean isEssentialNavigationKey(int keyCode) {
        return keyCode == 38 || keyCode == 40 || keyCode == 39 || keyCode == 37 || keyCode == 97 || keyCode == 98 || keyCode == 99 || keyCode == 100 || keyCode == 102 || keyCode == 103 || keyCode == 104 || keyCode == 105 || keyCode == 81 || keyCode == 87 || keyCode == 69 || keyCode == 65 || keyCode == 83 || keyCode == 68 || keyCode == 89 || keyCode == 88 || keyCode == 67 || keyCode == 90;
    }

    public void makeHost() {
        this.isHost = true;
    }

    private void showText(String text) {
        this.showImageLabel();
        this.imageLabel.setText(text);
        this.imageLabel.setIcon(null);
    }

    private void showImageLabel() {
        if (this.currentShownComponent == this.coloredLabyrinthComponent) {
            this.panel.remove(this.coloredLabyrinthComponent);
            this.panel.add(this.imageLabel);
            this.currentShownComponent = this.imageLabel;
            this.panel.revalidate();
        }
    }

    private void showColoredLabyrinthComponent() {
        if (this.currentShownComponent == this.imageLabel) {
            this.panel.remove(this.imageLabel);
            this.panel.add(this.coloredLabyrinthComponent);
            this.currentShownComponent = this.coloredLabyrinthComponent;
            this.panel.revalidate();
        }
    }
}

