/*
 * Decompiled with CFR 0.152.
 */
package navigationView;

import game.utils.LogHandler;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import labyrinthField.Point;
import menu.BaseJFrameWrapper;
import menu.GameController;
import menu.RenderableFrame;
import navigationView.Direction;
import navigationView.GameState;
import navigationView.JElementFactory;
import navigationView.KeyConfig;
import navigationView.MultiplayerClientView;
import navigationView.PickupTreasureEvent;
import navigationView.ViewModel;
import network.ClientConnection;
import network.LabyrinthFieldMetaData;
import network.Player;
import network.ReadWriteHelper;
import network.SerializableNetworkObject;
import network.UpdateRecord;
import network.VictoryMetaData;
import rendering.ImageRenderer;
import rendering.thread.MultiplayerClientStepThread;
import rendering.thread.PeriodicExecutionService;

public class MultiplayerClientViewSplitScreen
implements RenderableFrame,
KeyListener,
MultiplayerClientView {
    private ArrayList<BufferedImage> bufferedImageList;
    private ArrayList<JLabel> viewList = new ArrayList();
    private GameController gameController;
    private BaseJFrameWrapper baseJFrameWrapper;
    private ClientConnection connection;
    private LabyrinthFieldMetaData labyrinthFieldMetaData;
    private long timeout = 0L;
    private HashMap<Integer, GameState> gameStateMap = new HashMap();
    private HashMap<Integer, ViewModel> renderViewModelMap;
    private ViewModel playerViewModel;
    private KeyConfig keyConfig;
    private PeriodicExecutionService localRenderExecutorService;

    public MultiplayerClientViewSplitScreen(GameController gameController, ClientConnection connection) {
        this.gameController = gameController;
        this.baseJFrameWrapper = gameController.getBaseJFrameWrapper();
        this.connection = connection;
        this.keyConfig = new KeyConfig();
    }

    @Override
    public void render() {
        JSplitPane splitPane = JElementFactory.createJSplitPane(1);
        int numberOfPlayers = this.connection.getNumberOfPlayers();
        for (int i = 0; i < numberOfPlayers; ++i) {
            JLabel bufferedImage = new JLabel();
            bufferedImage.setHorizontalAlignment(0);
            bufferedImage.setVerticalAlignment(0);
            this.viewList.add(bufferedImage);
        }
        if (numberOfPlayers == 2) {
            JLabel leftView = this.viewList.get(0);
            JLabel rightView = this.viewList.get(1);
            splitPane.setLeftComponent(leftView);
            splitPane.setRightComponent(rightView);
        } else {
            JSplitPane splitPaneLeft = JElementFactory.createJSplitPane(0);
            JSplitPane splitPaneRight = JElementFactory.createJSplitPane(0);
            splitPane.setLeftComponent(splitPaneLeft);
            splitPane.setRightComponent(splitPaneRight);
            JLabel firstView = this.viewList.get(0);
            JLabel secondView = this.viewList.get(1);
            JLabel thirdView = this.viewList.get(2);
            splitPaneLeft.setTopComponent(firstView);
            splitPaneLeft.setBottomComponent(thirdView);
            splitPaneRight.setTopComponent(secondView);
            if (numberOfPlayers == 4) {
                JLabel fourthView = this.viewList.get(3);
                splitPaneRight.setBottomComponent(fourthView);
            }
        }
        this.baseJFrameWrapper.updateJFrameForGame(splitPane, this);
    }

    @Override
    public void setLabyrinthFieldMetaData(LabyrinthFieldMetaData labyrinthFieldMetaData) {
        this.labyrinthFieldMetaData = labyrinthFieldMetaData;
    }

    private void initializeRound() {
        while (this.labyrinthFieldMetaData == null) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                LogHandler.notifyException(e);
            }
        }
        this.renderViewModelMap = new HashMap();
        for (int i = 0; i < this.labyrinthFieldMetaData.getPlayerNameList().size(); ++i) {
            Player player = new Player();
            player.setName(this.labyrinthFieldMetaData.getPlayerNameList().get(i));
            player.setPlayerNumber(i);
            this.renderViewModelMap.put(i, new ViewModel(this.labyrinthFieldMetaData.getLabyrinthField(), this.labyrinthFieldMetaData.getNavigationMode(), this.labyrinthFieldMetaData.getWindowWidth(), this.labyrinthFieldMetaData.getWindowHeight(), false, i != this.getPlayerNumber(), this.labyrinthFieldMetaData.isBestOfTenMode(), player));
            if (this.gameStateMap.get(i) == GameState.DISCONNECTED) {
                player.setDisconnected(true);
            } else {
                this.gameStateMap.put(i, GameState.WAITING);
            }
            this.renderViewModelMap.get(i).setGameState(this.gameStateMap.get(i));
        }
        this.playerViewModel = this.renderViewModelMap.get(this.getPlayerNumber());
        if (this.localRenderExecutorService != null) {
            this.localRenderExecutorService.stop();
        }
        this.localRenderExecutorService = new PeriodicExecutionService(new MultiplayerClientStepThread(this.renderViewModelMap));
        this.localRenderExecutorService.start(ViewModel.getMillisecondsForStep(), 100L);
    }

    @Override
    public void startTheGame() {
        this.initializeRound();
        for (int i = 0; i < this.connection.getNumberOfPlayers(); ++i) {
            this.setGameStateForPlayerNumber(i, GameState.PLAYING);
        }
        this.playerViewModel.triggerRenderUpdate();
    }

    public void setGameStateForPlayerNumber(int playerNumber, GameState gameState) {
        this.gameStateMap.put(playerNumber, gameState);
        if (this.renderViewModelMap != null && this.renderViewModelMap.containsKey(playerNumber)) {
            this.renderViewModelMap.get(playerNumber).setGameState(gameState);
        }
    }

    @Override
    public void updateView(UpdateRecord updateRecord) {
        if (updateRecord.getLabyrinthNumber() == this.getPlayerNumber()) {
            return;
        }
        ViewModel viewModel = this.renderViewModelMap.get(updateRecord.getLabyrinthNumber());
        if (viewModel == null) {
            return;
        }
        if (updateRecord.getWayVector() == null) {
            viewModel.markAsDisconnected();
            this.setGameStateForPlayerNumber(updateRecord.getLabyrinthNumber(), GameState.DISCONNECTED);
            return;
        }
        viewModel.followWayVector(updateRecord.getWayVector());
    }

    @Override
    public void renderView() {
        if (this.playerViewModel == null || this.labyrinthFieldMetaData == null || !this.viewNeedsUpdate()) {
            return;
        }
        for (Map.Entry<Integer, ViewModel> integerViewModelEntry : this.renderViewModelMap.entrySet()) {
            int currentPlayerNumber = integerViewModelEntry.getKey();
            ViewModel currentViewModel = integerViewModelEntry.getValue();
            if (this.gameStateMap.get(currentPlayerNumber) != GameState.PLAYING) continue;
            JLabel view = this.viewList.get(currentPlayerNumber);
            view.setText(null);
            Point currentPoint = currentViewModel.getCurrentPosition();
            int[] image = ImageRenderer.matrixToImage(this.getRawImage(currentPoint.getxPosition(), currentPoint.getyPosition(), currentPlayerNumber));
            if (this.gameStateMap.get(currentPlayerNumber) != GameState.PLAYING) continue;
            BufferedImage bufferedImage = this.bufferedImageList.get(currentPlayerNumber);
            bufferedImage.getRaster().setDataElements(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), image);
            view.setIcon(new ImageIcon(bufferedImage));
            view.setText(null);
        }
        if (this.playerViewModel != null && this.playerViewModel.hasCurrentVectorChanged()) {
            try {
                ReadWriteHelper.writeSocketObject(this.connection.getPlayer().getClient(), new SerializableNetworkObject(this.playerViewModel.getCurrentWayVector()));
            }
            catch (IOException e) {
                LogHandler.notifyException(e);
                this.baseJFrameWrapper.showDialog("Connection lost.");
                this.close(false);
            }
        }
    }

    private boolean viewNeedsUpdate() {
        for (ViewModel viewModel : this.renderViewModelMap.values()) {
            if (!viewModel.needsRenderUpdate()) continue;
            return true;
        }
        return false;
    }

    public boolean[][] getRawImage(int posX, int posY, int labyrinthNumber) {
        int width = this.getBufferedImageWidth() / 2;
        int height = this.getBufferedImageHeight();
        if (this.connection.getNumberOfPlayers() > 2) {
            height /= 2;
        }
        if (this.bufferedImageList == null) {
            this.bufferedImageList = new ArrayList();
            for (int i = 0; i < this.viewList.size(); ++i) {
                this.bufferedImageList.add(new BufferedImage(width, height, 2));
            }
        }
        return ImageRenderer.getRawImage(this.labyrinthFieldMetaData, width, height, posX, posY, labyrinthNumber, this.timeout);
    }

    @Override
    public void showVictory(ArrayList<VictoryMetaData> victoryMetaDataList) {
        if (this.localRenderExecutorService != null && this.allPlayersHaveWon()) {
            this.localRenderExecutorService.stop();
        }
        for (int i = 0; i < victoryMetaDataList.size(); ++i) {
            if (victoryMetaDataList.get(i) == null) continue;
            this.setGameStateForPlayerNumber(i, GameState.VICTORY_SCREEN);
            JLabel view = this.viewList.get(i);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            double width = screenSize.getWidth();
            double scaleFactor = width / 3000.0 + 1.0;
            view.setHorizontalTextPosition(0);
            view.setHorizontalAlignment(0);
            view.setVerticalAlignment(0);
            ImageRenderer.renderVictory(view, victoryMetaDataList.get(i), scaleFactor);
        }
        if (this.allPlayersHaveWon()) {
            this.labyrinthFieldMetaData = null;
        }
    }

    private boolean allPlayersHaveWon() {
        int numberOfWonPlayers = 0;
        for (ViewModel viewModel : this.renderViewModelMap.values()) {
            if (viewModel.getGameState() != GameState.VICTORY_SCREEN && viewModel.getGameState() != GameState.DISCONNECTED) continue;
            ++numberOfWonPlayers;
        }
        return numberOfWonPlayers >= this.connection.getNumberOfPlayers();
    }

    @Override
    public void close(boolean communicateClose) {
        if (communicateClose) {
            this.connection.disconnect();
        } else {
            this.connection.disconnectPlayer(false);
        }
        this.gameController.goBackToPlayerModeSelect();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.close(true);
            return;
        }
        if (!this.isEssentialNavigationKey(keyEvent.getKeyCode())) {
            return;
        }
        if (this.connection.getPlayer().isDisconnected()) {
            return;
        }
        if (this.playerViewModel != null) {
            this.updateLocalLabyrinthByPressedKeyCode(keyEvent.getKeyCode(), true);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (!this.isEssentialNavigationKey(keyEvent.getKeyCode())) {
            return;
        }
        if (this.connection.getPlayer().isDisconnected()) {
            return;
        }
        if (this.playerViewModel != null) {
            this.updateLocalLabyrinthByPressedKeyCode(keyEvent.getKeyCode(), false);
        }
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public int getPlayerNumber() {
        return this.connection.getPlayer().getPlayerNumber();
    }

    private boolean isEssentialNavigationKey(int keyCode) {
        return keyCode == 38 || keyCode == 40 || keyCode == 39 || keyCode == 37 || keyCode == 97 || keyCode == 98 || keyCode == 99 || keyCode == 100 || keyCode == 102 || keyCode == 103 || keyCode == 104 || keyCode == 105 || keyCode == 81 || keyCode == 87 || keyCode == 69 || keyCode == 65 || keyCode == 83 || keyCode == 68 || keyCode == 89 || keyCode == 88 || keyCode == 67 || keyCode == 90;
    }

    private void updateLocalLabyrinthByPressedKeyCode(int keyCode, boolean pushAction) {
        if (keyCode == this.keyConfig.getRight()) {
            this.playerViewModel.updateDirectionInput(Direction.RIGHT, pushAction);
        } else if (keyCode == this.keyConfig.getLeft()) {
            this.playerViewModel.updateDirectionInput(Direction.LEFT, pushAction);
        } else if (keyCode == this.keyConfig.getDown()) {
            this.playerViewModel.updateDirectionInput(Direction.DOWN, pushAction);
        } else if (keyCode == this.keyConfig.getUp()) {
            this.playerViewModel.updateDirectionInput(Direction.UP, pushAction);
        } else {
            this.checkAlternateKeys(keyCode, pushAction);
        }
    }

    private void checkAlternateKeys(int keyCode, boolean pushAction) {
        if (keyCode == this.keyConfig.getAlternateRight()) {
            this.playerViewModel.updateDirectionInput(Direction.RIGHT, pushAction);
        } else if (keyCode == this.keyConfig.getAlternateLeft()) {
            this.playerViewModel.updateDirectionInput(Direction.LEFT, pushAction);
        } else if (keyCode == this.keyConfig.getAlternateDown()) {
            this.playerViewModel.updateDirectionInput(Direction.DOWN, pushAction);
        } else if (keyCode == this.keyConfig.getAlternateUp()) {
            this.playerViewModel.updateDirectionInput(Direction.UP, pushAction);
        } else if (keyCode == this.keyConfig.getUpLeft()) {
            this.playerViewModel.updateDirectionInput(Direction.LEFT, pushAction);
            this.playerViewModel.updateDirectionInput(Direction.UP, pushAction);
        } else if (keyCode == this.keyConfig.getUpRight()) {
            this.playerViewModel.updateDirectionInput(Direction.RIGHT, pushAction);
            this.playerViewModel.updateDirectionInput(Direction.UP, pushAction);
        } else if (keyCode == this.keyConfig.getDownLeft() || this.keyConfig.getDownLeft() == 89 && keyCode == 90) {
            this.playerViewModel.updateDirectionInput(Direction.LEFT, pushAction);
            this.playerViewModel.updateDirectionInput(Direction.DOWN, pushAction);
        } else if (keyCode == this.keyConfig.getDownRight()) {
            this.playerViewModel.updateDirectionInput(Direction.RIGHT, pushAction);
            this.playerViewModel.updateDirectionInput(Direction.DOWN, pushAction);
        } else if (keyCode == 68) {
            this.playerViewModel.updateDirectionInput(Direction.RIGHT, pushAction);
        } else if (keyCode == 65) {
            this.playerViewModel.updateDirectionInput(Direction.LEFT, pushAction);
        } else if (keyCode == 83 || keyCode == 88) {
            this.playerViewModel.updateDirectionInput(Direction.DOWN, pushAction);
        } else if (keyCode == 87) {
            this.playerViewModel.updateDirectionInput(Direction.UP, pushAction);
        } else if (keyCode == 81) {
            this.playerViewModel.updateDirectionInput(Direction.LEFT, pushAction);
            this.playerViewModel.updateDirectionInput(Direction.UP, pushAction);
        } else if (keyCode == 69) {
            this.playerViewModel.updateDirectionInput(Direction.RIGHT, pushAction);
            this.playerViewModel.updateDirectionInput(Direction.UP, pushAction);
        } else if (keyCode == 89 || keyCode == 90) {
            this.playerViewModel.updateDirectionInput(Direction.LEFT, pushAction);
            this.playerViewModel.updateDirectionInput(Direction.DOWN, pushAction);
        } else if (keyCode == 67) {
            this.playerViewModel.updateDirectionInput(Direction.RIGHT, pushAction);
            this.playerViewModel.updateDirectionInput(Direction.DOWN, pushAction);
        }
    }

    private int getBufferedImageWidth() {
        Dimension dimension = this.baseJFrameWrapper.getSize();
        if (this.gameController.getGameSettings().isUseFullScreen()) {
            return (int)dimension.getWidth();
        }
        return (int)dimension.getWidth() - 22;
    }

    private int getBufferedImageHeight() {
        Dimension dimension = this.baseJFrameWrapper.getSize();
        if (this.gameController.getGameSettings().isUseFullScreen()) {
            return (int)dimension.getHeight();
        }
        return (int)dimension.getHeight() - 40;
    }

    @Override
    public void renderInitially() {
        this.render();
    }

    @Override
    public void showMessageDialog(String message) {
        this.baseJFrameWrapper.showDialog(message);
    }

    @Override
    public void applyPickupTreasureEvent(PickupTreasureEvent pickupTreasureEvent) {
    }
}

