/*
 * Decompiled with CFR 0.152.
 */
package navigationView;

import game.utils.LogHandler;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import labyrinthField.Point;
import menu.BaseJFrameWrapper;
import menu.GameController;
import menu.RenderableFrame;
import navigationView.Closable;
import navigationView.GameState;
import navigationView.LabyrinthNavigationView;
import navigationView.MultiplayerHostView;
import navigationView.SendLabyrinthMetaDataThread;
import navigationView.ViewModel;
import network.Player;
import network.ReadWriteHelper;
import network.ServerConnection;
import network.UpdateRecord;
import rendering.thread.MultiplayerHostListenerThread;
import rendering.thread.MultiplayerHostRenderThread;
import rendering.thread.PeriodicExecutionService;

public class MultiplayerHostViewColored
implements RenderableFrame,
Closable,
KeyListener,
MultiplayerHostView {
    private ArrayList<LabyrinthNavigationView> viewList;
    private GameController gameController;
    private BaseJFrameWrapper baseJFrameWrapper;
    private ServerConnection connection;
    private HashMap<Integer, Integer> datagramCountMap = new HashMap();
    private HashMap<Integer, Point> playerPositionMap = new HashMap();
    private long lastUpdateTime = 0L;
    private MultiplayerHostRenderThread renderThread;
    private ArrayList<MultiplayerHostListenerThread> multiplayerHostListenerThreads;
    private boolean currentlySending = false;
    private HashSet<Integer> disconnectedPlayerNumber = new HashSet();
    private LabyrinthNavigationView mainView;

    public MultiplayerHostViewColored(ArrayList<LabyrinthNavigationView> viewList, GameController gameController, ServerConnection connection, ArrayList<MultiplayerHostListenerThread> multiplayerHostListenerThreads) {
        this.gameController = gameController;
        if (gameController != null) {
            this.baseJFrameWrapper = gameController.getBaseJFrameWrapper();
        }
        this.viewList = viewList;
        this.connection = connection;
        this.multiplayerHostListenerThreads = multiplayerHostListenerThreads;
        this.mainView = viewList.get(0);
        for (LabyrinthNavigationView labyrinthNavigationView : viewList) {
            labyrinthNavigationView.setClosable(this);
        }
    }

    @Override
    public void render() {
        if (this.baseJFrameWrapper != null) {
            this.baseJFrameWrapper.updateJFrameForGame(this.mainView, this);
        }
        for (LabyrinthNavigationView labyrinthNavigationView : this.viewList) {
            labyrinthNavigationView.shareSize(this.getBufferedImageWidth(), this.getBufferedImageHeight());
        }
        this.mainView.getViewModel().reset();
        this.renderThread = new MultiplayerHostRenderThread(this.playerPositionMap, this, this.mainView);
        new PeriodicExecutionService(this.renderThread).start(5L, 0L);
    }

    private void sendLabyrinthMetaData() {
        Player player;
        HashSet<Integer> waitForPlayerList = new HashSet<Integer>();
        for (MultiplayerHostListenerThread multiplayerHostListenerThread : this.multiplayerHostListenerThreads) {
            player = multiplayerHostListenerThread.getPlayer();
            if (player.getClient() == null || player.isDisconnected()) continue;
            waitForPlayerList.add(player.getPlayerNumber());
            multiplayerHostListenerThread.enableWaitForAcknowledge();
        }
        for (Player player2 : this.connection.getPlayerList()) {
            if (player2.getClient() == null || player2.isDisconnected()) continue;
            new SendLabyrinthMetaDataThread(player2, this.mainView.getViewModel().buildLabyrinthMetaData()).start();
        }
        for (MultiplayerHostListenerThread multiplayerHostListenerThread : this.multiplayerHostListenerThreads) {
            player = multiplayerHostListenerThread.getPlayer();
            if (!waitForPlayerList.contains(multiplayerHostListenerThread.getPlayer().getPlayerNumber())) continue;
            int tries = 0;
            while (!multiplayerHostListenerThread.isAcknowledged() && multiplayerHostListenerThread.isActive() && player.getClient() != null && !player.isDisconnected() && tries <= 500) {
                try {
                    Thread.sleep(20L);
                    ++tries;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        for (MultiplayerHostListenerThread multiplayerHostListenerThread : this.multiplayerHostListenerThreads) {
            player = multiplayerHostListenerThread.getPlayer();
            if (!waitForPlayerList.contains(multiplayerHostListenerThread.getPlayer().getPlayerNumber()) || multiplayerHostListenerThread.isAcknowledged() || !multiplayerHostListenerThread.isActive()) continue;
            LogHandler.notifyDebugMessage(player.getName() + " timed out (no response in time).");
            try {
                ReadWriteHelper.writeSocketMessage(player.getClient(), "disconnect;");
            }
            catch (IOException e) {
                LogHandler.notifyException(e);
            }
            try {
                multiplayerHostListenerThread.disconnectPlayer();
            }
            catch (IOException e) {
                LogHandler.notifyException(e);
            }
        }
    }

    @Override
    public void updateLabyrinth() {
        boolean hasUpdate = false;
        ArrayList<UpdateRecord> updateRecordList = new ArrayList<UpdateRecord>();
        this.mainView.checkStartPushed();
        if (!this.mainView.getViewModel().hasLabyrinthData() || this.currentlySending) {
            return;
        }
        if (this.mainView.getViewModel().hasChangedField()) {
            this.currentlySending = true;
            this.mainView.setReadyToStart(false);
            this.sendLabyrinthMetaData();
            this.mainView.setReadyToStart(true);
            this.currentlySending = false;
        }
        if (this.mainView.getViewModel().needsToCommunicateGameStart()) {
            this.connection.updateClientsWithGameStart();
            this.disconnectedPlayerNumber = new HashSet();
        }
        if (this.renderThread == null && this.mainView.getViewModel().getGameState() == GameState.WAITING) {
            this.mainView.checkContDown();
            return;
        }
        boolean hasUpdateAfterTimeOrDisconnect = this.lastUpdateTime + 500L < new Date().getTime();
        for (Player player : this.connection.getPlayerList()) {
            if (!player.isDisconnected() || this.disconnectedPlayerNumber.contains(player.getPlayerNumber())) continue;
            this.disconnectedPlayerNumber.add(player.getPlayerNumber());
            updateRecordList.add(new UpdateRecord(player.getPlayerNumber(), this.getDatagramCounter(player.getPlayerNumber()), this.mainView.getViewModel().getCurrentWayVector(), true));
            hasUpdateAfterTimeOrDisconnect = true;
        }
        int i = 0;
        boolean onePlaying = false;
        for (LabyrinthNavigationView labyrinthNavigationView : this.viewList) {
            ViewModel viewModel = labyrinthNavigationView.getViewModel();
            if (viewModel.getGameState() == GameState.PLAYING) {
                onePlaying = true;
            }
            if (viewModel.needsRenderUpdate() || hasUpdateAfterTimeOrDisconnect) {
                hasUpdate = true;
                Point currentPoint = viewModel.getCurrentPosition();
                boolean isDisconnected = this.connection.getPlayerList().get(i).isDisconnected();
                if (!isDisconnected) {
                    this.playerPositionMap.put(i, currentPoint);
                } else {
                    this.playerPositionMap.remove(i);
                }
                if (i == 0 && !this.isOnlyHost()) {
                    if (viewModel.hasCurrentVectorChanged()) {
                        updateRecordList.add(new UpdateRecord(i, this.getDatagramCounter(i), viewModel.getCurrentWayVector(), isDisconnected));
                    }
                } else if (viewModel.hasFollowWayVectorChanged()) {
                    updateRecordList.add(new UpdateRecord(i, this.getDatagramCounter(i), viewModel.getWayFollowVector(), isDisconnected));
                }
            }
            ++i;
        }
        if (hasUpdate && onePlaying) {
            if (this.renderThread != null) {
                this.renderThread.update();
            }
            this.connection.updateClientsWithLabyrinths(updateRecordList);
            this.lastUpdateTime = new Date().getTime();
        }
    }

    private boolean isOnlyHost() {
        return this.mainView != this.viewList.get(0);
    }

    private int getDatagramCounter(int labyrinthCounter) {
        int datagramCounter = 0;
        if (this.datagramCountMap.containsKey(labyrinthCounter)) {
            datagramCounter = this.datagramCountMap.get(labyrinthCounter);
        }
        this.datagramCountMap.put(labyrinthCounter, ++datagramCounter);
        return datagramCounter;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.mainView.keyPressed(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.mainView.keyReleased(e);
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void close() {
        this.connection.disconnect();
        if (this.gameController != null) {
            this.gameController.goBackToPlayerModeSelect();
        }
    }

    public boolean hasOnePlayerPlaying() {
        for (LabyrinthNavigationView labyrinthNavigationView : this.viewList) {
            ViewModel viewModel = labyrinthNavigationView.getViewModel();
            if (viewModel.getGameState() != GameState.PLAYING) continue;
            return true;
        }
        return false;
    }

    private int getBufferedImageWidth() {
        if (this.baseJFrameWrapper == null) {
            return 1920;
        }
        Dimension dimension = this.baseJFrameWrapper.getSize();
        if (this.gameController.getGameSettings().isUseFullScreen()) {
            return (int)dimension.getWidth();
        }
        return (int)dimension.getWidth() - 22;
    }

    private int getBufferedImageHeight() {
        if (this.baseJFrameWrapper == null) {
            return 1080;
        }
        Dimension dimension = this.baseJFrameWrapper.getSize();
        if (this.gameController.getGameSettings().isUseFullScreen()) {
            return (int)dimension.getHeight();
        }
        return (int)dimension.getHeight() - 40;
    }

    @Override
    public void renderInitially() {
        this.render();
    }

    @Override
    public void showMessageDialog(String message) {
        if (this.mainView == null) {
            this.baseJFrameWrapper.showDialog(message);
        }
    }

    public void repaint() {
        if (this.baseJFrameWrapper != null) {
            this.baseJFrameWrapper.repaint();
        }
    }

    public void showDialog(String message) {
        if (this.baseJFrameWrapper != null) {
            this.baseJFrameWrapper.showDialog(message);
        }
    }

    public void setMainView(LabyrinthNavigationView gameControllingView) {
        this.mainView = gameControllingView;
    }
}

