/*
 * Decompiled with CFR 0.152.
 */
package navigationView;

import game.utils.LogHandler;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JSplitPane;
import menu.BaseJFrameWrapper;
import menu.GameController;
import menu.RenderableFrame;
import navigationView.Closable;
import navigationView.GameState;
import navigationView.JElementFactory;
import navigationView.LabyrinthNavigationView;
import navigationView.MultiplayerHostView;
import navigationView.ViewModel;
import network.Player;
import network.ReadWriteHelper;
import network.SerializableNetworkObject;
import network.ServerConnection;
import network.UpdateRecord;
import rendering.ImageRenderer;
import rendering.thread.MultiplayerHostListenerThread;

public class MultiplayerHostViewSplitScreen
implements RenderableFrame,
Closable,
KeyListener,
MultiplayerHostView {
    private ArrayList<LabyrinthNavigationView> viewList;
    private GameController gameController;
    private BaseJFrameWrapper baseJFrameWrapper;
    private ServerConnection connection;
    private HashMap<Integer, Integer> datagramCountMap = new HashMap();
    private long lastUpdateTime = 0L;
    private ArrayList<MultiplayerHostListenerThread> multiplayerHostListenerThreads;
    private boolean currentlySending = false;
    private HashSet<Integer> disconnectedPlayerNumber = new HashSet();

    public MultiplayerHostViewSplitScreen(ArrayList<LabyrinthNavigationView> viewList, GameController gameController, ServerConnection connection, ArrayList<MultiplayerHostListenerThread> multiplayerHostListenerThreads) {
        this.baseJFrameWrapper = gameController.getBaseJFrameWrapper();
        this.gameController = gameController;
        this.viewList = viewList;
        this.connection = connection;
        this.multiplayerHostListenerThreads = multiplayerHostListenerThreads;
    }

    @Override
    public void render() {
        JSplitPane splitPane = JElementFactory.createJSplitPane(1);
        for (LabyrinthNavigationView labyrinthNavigationView : this.viewList) {
            labyrinthNavigationView.setClosable(this);
        }
        if (this.connection.getPlayerList().size() == 2) {
            LabyrinthNavigationView leftView = this.viewList.get(0);
            LabyrinthNavigationView rightView = this.viewList.get(1);
            splitPane.setLeftComponent(leftView);
            splitPane.setRightComponent(rightView);
        } else {
            JSplitPane splitPaneLeft = JElementFactory.createJSplitPane(0);
            JSplitPane splitPaneRight = JElementFactory.createJSplitPane(0);
            splitPane.setLeftComponent(splitPaneLeft);
            splitPane.setRightComponent(splitPaneRight);
            LabyrinthNavigationView firstView = this.viewList.get(0);
            LabyrinthNavigationView secondView = this.viewList.get(1);
            LabyrinthNavigationView thirdView = this.viewList.get(2);
            splitPaneLeft.setTopComponent(firstView);
            splitPaneLeft.setBottomComponent(thirdView);
            splitPaneRight.setTopComponent(secondView);
            if (this.connection.getPlayerList().size() == 4) {
                LabyrinthNavigationView fourthView = this.viewList.get(3);
                splitPaneRight.setBottomComponent(fourthView);
            }
        }
        this.baseJFrameWrapper.updateJFrameForGame(splitPane, this);
        for (LabyrinthNavigationView labyrinthNavigationView : this.viewList) {
            if (this.connection.getPlayerList().size() == 2) {
                labyrinthNavigationView.shareSize(this.getBufferedImageWidth() / 2 - 2, this.getBufferedImageHeight());
                continue;
            }
            labyrinthNavigationView.shareSize(this.getBufferedImageWidth() / 2 - 2, this.getBufferedImageHeight() / 2 - 2);
        }
        this.viewList.get(0).getViewModel().reset();
    }

    private void sendLabyrinthMetaData() {
        Player player;
        HashSet<Integer> waitForPlayerList = new HashSet<Integer>();
        for (MultiplayerHostListenerThread multiplayerHostListenerThread : this.multiplayerHostListenerThreads) {
            player = multiplayerHostListenerThread.getPlayer();
            if (player.getClient() == null || player.isDisconnected()) continue;
            waitForPlayerList.add(player.getPlayerNumber());
            multiplayerHostListenerThread.enableWaitForAcknowledge();
        }
        for (Player player2 : this.connection.getPlayerList()) {
            if (player2.getClient() == null || player2.isDisconnected()) continue;
            try {
                ReadWriteHelper.writeSocketObject(player2.getClient(), new SerializableNetworkObject(this.viewList.get(0).getViewModel().buildLabyrinthMetaData()));
            }
            catch (SocketException e) {
                if (player2.getClient().isConnected()) continue;
                player2.setDisconnected(true);
            }
            catch (IOException e) {
                LogHandler.notifyException(e);
            }
        }
        for (MultiplayerHostListenerThread multiplayerHostListenerThread : this.multiplayerHostListenerThreads) {
            player = multiplayerHostListenerThread.getPlayer();
            if (!waitForPlayerList.contains(multiplayerHostListenerThread.getPlayer().getPlayerNumber())) continue;
            while (!multiplayerHostListenerThread.isAcknowledged() && multiplayerHostListenerThread.isActive() && player.getClient() != null && !player.isDisconnected()) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public void updateLabyrinth() {
        boolean hasUpdate = false;
        ArrayList<UpdateRecord> updateRecordList = new ArrayList<UpdateRecord>();
        if (this.viewList.get(0).getViewModel().needsToCommunicateGameStart()) {
            this.connection.updateClientsWithGameStart();
            this.disconnectedPlayerNumber = new HashSet();
        }
        if (!this.viewList.get(0).getViewModel().hasLabyrinthData() || this.currentlySending) {
            return;
        }
        if (this.viewList.get(0).getViewModel().hasChangedField()) {
            this.currentlySending = true;
            this.viewList.get(0).setReadyToStart(false);
            this.sendLabyrinthMetaData();
            this.viewList.get(0).setReadyToStart(true);
            this.currentlySending = false;
        }
        boolean hasDisconnectUpdate = false;
        for (Player player : this.connection.getPlayerList()) {
            if (!player.isDisconnected() || this.disconnectedPlayerNumber.contains(player.getPlayerNumber())) continue;
            this.disconnectedPlayerNumber.add(player.getPlayerNumber());
            updateRecordList.add(new UpdateRecord(player.getPlayerNumber(), this.getDatagramCounter(player.getPlayerNumber()), this.viewList.get(0).getViewModel().getCurrentWayVector(), true));
            hasDisconnectUpdate = true;
        }
        int i = 0;
        boolean hasUpdateAfterTime = this.lastUpdateTime + 500L < new Date().getTime();
        for (LabyrinthNavigationView labyrinthNavigationView : this.viewList) {
            ViewModel viewModel = labyrinthNavigationView.getViewModel();
            if (viewModel.needsRenderUpdate() || hasUpdateAfterTime && viewModel.getGameState() == GameState.PLAYING || hasDisconnectUpdate) {
                boolean[][] labyrinth = viewModel.getRawImage(i);
                labyrinthNavigationView.showLabyrinth(ImageRenderer.matrixToImage(labyrinth));
                hasUpdate = true;
                if (i == 0) {
                    if (viewModel.hasCurrentVectorChanged()) {
                        updateRecordList.add(new UpdateRecord(i, this.getDatagramCounter(i), viewModel.getCurrentWayVector(), false));
                    }
                } else if (viewModel.hasFollowWayVectorChanged()) {
                    updateRecordList.add(new UpdateRecord(i, this.getDatagramCounter(i), viewModel.getWayFollowVector(), false));
                }
            }
            ++i;
        }
        if (hasUpdate) {
            this.connection.updateClientsWithLabyrinths(updateRecordList);
            this.lastUpdateTime = new Date().getTime();
        }
    }

    private int getDatagramCounter(int labyrinthCounter) {
        int datagramCounter = 0;
        if (this.datagramCountMap.containsKey(labyrinthCounter)) {
            datagramCounter = this.datagramCountMap.get(labyrinthCounter);
        }
        this.datagramCountMap.put(labyrinthCounter, ++datagramCounter);
        return datagramCounter;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        LabyrinthNavigationView mainView = this.viewList.get(0);
        mainView.keyPressed(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        LabyrinthNavigationView mainView = this.viewList.get(0);
        mainView.keyReleased(e);
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void close() {
        this.connection.disconnect();
        this.gameController.goBackToPlayerModeSelect();
    }

    private int getBufferedImageWidth() {
        Dimension dimension = this.baseJFrameWrapper.getSize();
        if (this.gameController.getGameSettings().isUseFullScreen()) {
            return (int)dimension.getWidth();
        }
        return (int)dimension.getWidth() - 22;
    }

    private int getBufferedImageHeight() {
        Dimension dimension = this.baseJFrameWrapper.getSize();
        if (this.gameController.getGameSettings().isUseFullScreen()) {
            return (int)dimension.getHeight();
        }
        return (int)dimension.getHeight() - 40;
    }

    @Override
    public void renderInitially() {
        this.render();
    }

    @Override
    public void showMessageDialog(String message) {
        this.baseJFrameWrapper.showDialog(message);
    }
}

