/*
 * Decompiled with CFR 0.152.
 */
package navigationView;

import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import menu.BaseJFrameWrapper;
import menu.GameController;
import menu.RenderableFrame;
import navigationView.Closable;
import navigationView.LabyrinthNavigationView;
import navigationView.Renderable;
import navigationView.ViewModel;

public class SinglePlayerView
implements RenderableFrame,
Closable,
KeyListener,
Renderable {
    private BaseJFrameWrapper baseJFrameWrapper;
    private LabyrinthNavigationView navigationView;
    private GameController gameController;

    public SinglePlayerView(LabyrinthNavigationView navigationView, GameController gameController) {
        this.baseJFrameWrapper = gameController.getBaseJFrameWrapper();
        this.navigationView = navigationView;
        this.gameController = gameController;
        navigationView.setClosable(this);
    }

    @Override
    public void render() {
        this.baseJFrameWrapper.updateJFrameForGame(this.navigationView, this);
        this.navigationView.shareSize(this.getBufferedImageWidth(), this.getBufferedImageHeight());
    }

    @Override
    public void updateLabyrinth() {
        ViewModel viewModel = this.navigationView.getViewModel();
        if (viewModel.needsRenderUpdate()) {
            this.navigationView.showLabyrinth();
            this.baseJFrameWrapper.repaint();
        }
    }

    @Override
    public void showMessageDialog(String message) {
        this.baseJFrameWrapper.showDialog(message);
    }

    @Override
    public void close() {
        this.gameController.goBackToPlayerModeSelect();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.navigationView.keyPressed(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.navigationView.keyReleased(e);
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    public void showDialog(String message) {
        this.baseJFrameWrapper.showDialog(message);
        this.baseJFrameWrapper.requestFocus();
    }

    private int getBufferedImageWidth() {
        Dimension dimension = this.baseJFrameWrapper.getSize();
        if (this.gameController.getGameSettings().isUseFullScreen()) {
            return (int)dimension.getWidth();
        }
        return (int)dimension.getWidth() - 22;
    }

    private int getBufferedImageHeight() {
        Dimension dimension = this.baseJFrameWrapper.getSize();
        if (this.gameController.getGameSettings().isUseFullScreen()) {
            return (int)dimension.getHeight();
        }
        return (int)dimension.getHeight() - 40;
    }
}

