/*
 * Decompiled with CFR 0.152.
 */
package navigationView;

import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JSplitPane;
import menu.BaseJFrameWrapper;
import menu.GameController;
import menu.RenderableFrame;
import navigationView.Closable;
import navigationView.JElementFactory;
import navigationView.LabyrinthNavigationView;
import navigationView.Renderable;
import navigationView.ViewModel;

public class SplitScreenView
implements RenderableFrame,
Closable,
KeyListener,
Renderable {
    private LabyrinthNavigationView rightView;
    private LabyrinthNavigationView leftView;
    private BaseJFrameWrapper baseJFrameWrapper;
    private GameController gameController;
    private boolean isClosed = false;

    public SplitScreenView(LabyrinthNavigationView leftView, LabyrinthNavigationView rightView, GameController gameController) {
        this.baseJFrameWrapper = gameController.getBaseJFrameWrapper();
        this.rightView = rightView;
        this.leftView = leftView;
        this.gameController = gameController;
    }

    @Override
    public void render() {
        JSplitPane splitPane = JElementFactory.createJSplitPane(1);
        splitPane.setLeftComponent(this.leftView);
        splitPane.setRightComponent(this.rightView);
        this.rightView.setClosable(this);
        this.leftView.setClosable(this);
        this.baseJFrameWrapper.updateJFrameForGame(splitPane, this);
        this.rightView.shareSize(this.getBufferedImageWidth() / 2 - 2, this.getBufferedImageHeight());
        this.leftView.shareSize(this.getBufferedImageWidth() / 2 - 2, this.getBufferedImageHeight());
    }

    @Override
    public void updateLabyrinth() {
        ViewModel viewModel1 = this.leftView.getViewModel();
        ViewModel viewModel2 = this.rightView.getViewModel();
        if (viewModel1.needsRenderUpdate() || viewModel2.needsRenderUpdate()) {
            viewModel1.renderColoredImageSplitScreen(0, viewModel2.getCurrentPosition(), this.leftView);
            viewModel2.renderColoredImageSplitScreen(1, viewModel1.getCurrentPosition(), this.rightView);
            this.baseJFrameWrapper.repaint();
        }
    }

    @Override
    public void showMessageDialog(String message) {
        this.baseJFrameWrapper.showDialog(message);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.leftView.keyPressed(e);
        this.rightView.keyPressed(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.leftView.keyReleased(e);
        this.rightView.keyReleased(e);
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.gameController.goBackToPlayerModeSelect();
        }
        this.isClosed = true;
    }

    public void showDialog(String message) {
        this.baseJFrameWrapper.showDialog(message);
    }

    private int getBufferedImageWidth() {
        Dimension dimension = this.baseJFrameWrapper.getSize();
        if (this.gameController.getGameSettings().isUseFullScreen()) {
            return (int)dimension.getWidth();
        }
        return (int)dimension.getWidth() - 22;
    }

    private int getBufferedImageHeight() {
        Dimension dimension = this.baseJFrameWrapper.getSize();
        if (this.gameController.getGameSettings().isUseFullScreen()) {
            return (int)dimension.getHeight();
        }
        return (int)dimension.getHeight() - 40;
    }
}

