/*
 * Decompiled with CFR 0.152.
 */
package navigationView;

import game.utils.LabUtils;
import game.utils.LogHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Semaphore;
import labyrinthField.AngleDistanceCalculator;
import labyrinthField.Field;
import labyrinthField.Point;
import labyrinthField.Treasure;
import labyrinthField.TreasureType;
import labyrinthField.Way;
import menu.GameMode;
import menu.GameSettings;
import menu.PlayerMode;
import navigationView.Direction;
import navigationView.DirectionAssignment;
import navigationView.DirectionInput;
import navigationView.DirectionWay;
import navigationView.GameState;
import navigationView.LabyrinthNavigationView;
import navigationView.NavigationMode;
import navigationView.PlayerEffect;
import navigationView.ScoreRecord;
import navigationView.ViewModelProperties;
import network.LabyrinthFieldMetaData;
import network.Player;
import network.VictoryMetaData;
import network.WayVector;
import rendering.ImageRenderer;

public class ViewModel {
    public static final int DEFAULT_HEIGHT = 1080;
    public static final int DEFAULT_WIDTH = 1920;
    private Field labyrinthField;
    private Point currentPosition;
    private Way currentWay;
    private int currentWayPointIndex;
    private boolean goingBackwards;
    private DirectionInput currentMovingDirection;
    private DirectionInput directionInput;
    private NavigationMode navigationMode = NavigationMode.GUIDED;
    private long startTime;
    private int currentScore;
    private int windowHeight = 1080;
    private int windowWidth = 1920;
    private ArrayList<ScoreRecord> scoreRecordList = new ArrayList();
    private int distanceCounter;
    private GameState gameState = GameState.START_SCREEN;
    private int scaleFactor = 1;
    private ArrayList<ViewModel> listeningViewModels = new ArrayList();
    private boolean needsRenderUpdate = true;
    private boolean isBestOfThenMode = false;
    private boolean isEasyMode = false;
    private boolean isTreasureMode = false;
    private boolean hasChangedField = true;
    private long timeout = 0L;
    private ArrayList<String> playerNameList;
    private String labyrinthText;
    private int labyrinthWidth = 800;
    private int labyrinthHeight = 600;
    private int pointsPerSecond = 90;
    private int pointsPerSecondCached = 90;
    private long pointsPerSecondLastRefresh = 0L;
    private boolean invertControls = false;
    private boolean showWayToGoal = false;
    private long lastMeasuredSecond = 0L;
    static final int stepsPerSecond = 120;
    private int currentStepPerSecond = 0;
    private WayVector currentWayVector;
    private WayVector followWayVector;
    private boolean hasChangedFollowWayVector = false;
    private boolean hasChangedCurrentWayVector = false;
    private boolean needsToCommunicateGameStart = false;
    private ViewModelProperties viewModelProperties = new ViewModelProperties();
    private Player player;
    public static int numberOfRounds = 10;
    private int lastShownSeconds = 0;
    private boolean switchDirectionEnabled = true;
    private ArrayList<PlayerEffect> playerEffectList = new ArrayList();
    private ArrayList<Treasure> leftTreasuresList = new ArrayList();
    private Semaphore modifyPositionLock = new Semaphore(1);
    private Way deepWaySearchLastCurrentWayBackwards = null;
    private ArrayList<Way> lastDeepWaySearchBackwards = new ArrayList();
    private Way deepWaySearchLastCurrentWayForwards = null;
    private ArrayList<Way> lastDeepWaySearchForwards = new ArrayList();
    private long delayedPush = 0L;
    private int treasureCount = 0;

    public ViewModel() {
        this.reset();
    }

    public ViewModel(GameSettings gameSettings, int scaleFactor, boolean isSplitScreen, Player networkPlayer, boolean isNetwork) {
        this.viewModelProperties = new ViewModelProperties(isNetwork, isSplitScreen, isNetwork, false);
        this.player = networkPlayer;
        GameMode gameMode = gameSettings.getGameMode();
        this.scaleFactor = scaleFactor;
        this.isBestOfThenMode = gameMode.isBestOfTenMode();
        this.labyrinthText = gameMode.getText();
        if (this.labyrinthText != null && this.labyrinthText.length() > 1 && scaleFactor > 2 && gameSettings.getPlayerMode() == PlayerMode.SINGLE) {
            --this.scaleFactor;
        }
        this.navigationMode = gameSettings.isGuidedMode() ? NavigationMode.GUIDED : NavigationMode.FREE;
        this.isEasyMode = gameSettings.isEasyMode();
        this.isTreasureMode = gameSettings.isTreasureMode();
        this.labyrinthWidth = gameMode.getWidth();
        this.labyrinthHeight = gameMode.getHeight();
        if (!this.viewModelProperties.shouldResetFieldAfterVictory()) {
            this.reset();
        }
    }

    public ViewModel(ViewModel viewModel, boolean isSplitScreen, Player networkPlayer) {
        this.viewModelProperties = new ViewModelProperties(networkPlayer != null, isSplitScreen, networkPlayer != null, true);
        this.player = networkPlayer;
        viewModel.addListeningViewModel(this);
        Field field = viewModel.getField();
        this.scaleFactor = viewModel.getScaleFactor();
        this.labyrinthField = field;
        if (field != null) {
            this.leftTreasuresList = (ArrayList)field.getTreasureList().clone();
        }
        this.isBestOfThenMode = viewModel.isBestOfThenMode;
        this.navigationMode = viewModel.navigationMode;
        this.isEasyMode = viewModel.isEasyMode;
        this.needsRenderUpdate = true;
        this.resetWithoutField();
    }

    public ViewModel(Field field, NavigationMode navigationMode, int windowWidth, int windowHeight, boolean isSplitScreen, boolean isListeningViewModel, boolean isBestOfThenMode, Player player) {
        this.viewModelProperties = new ViewModelProperties(true, isSplitScreen, false, isListeningViewModel);
        this.player = player;
        this.windowWidth = windowWidth;
        this.windowHeight = windowHeight;
        this.scaleFactor = field.getScaleFactor();
        this.labyrinthField = field;
        this.leftTreasuresList = (ArrayList)field.getTreasureList().clone();
        this.isBestOfThenMode = isBestOfThenMode;
        this.navigationMode = navigationMode;
        this.needsRenderUpdate = true;
        this.resetWithoutField();
    }

    public void updateField(Field field) {
        this.labyrinthField = field;
        this.leftTreasuresList = (ArrayList)field.getTreasureList().clone();
        this.resetWithoutField();
    }

    public void addListeningViewModel(ViewModel viewModel) {
        this.listeningViewModels.add(viewModel);
    }

    public boolean isBestOfThenMode() {
        return this.isBestOfThenMode;
    }

    public void step() {
        long timeDiff;
        long currentTime = new Date().getTime();
        if (this.lastMeasuredSecond == 0L) {
            this.lastMeasuredSecond = currentTime;
        }
        if ((timeDiff = currentTime - this.lastMeasuredSecond) * 120L / 1000L >= (long)this.currentStepPerSecond) {
            this.stepDependingOnMode();
            currentTime = new Date().getTime();
            timeDiff = currentTime - this.lastMeasuredSecond;
            if (timeDiff * 120L / 1000L >= (long)this.currentStepPerSecond && this.currentStepPerSecond <= 120 && this.currentStepPerSecond > 1) {
                this.step();
            }
        }
    }

    private void stepDependingOnMode() {
        try {
            this.modifyPositionLock.acquire();
        }
        catch (InterruptedException e) {
            LogHandler.notifyException(e);
        }
        if (this.navigationMode == NavigationMode.FREE) {
            this.stepWithFreeNavigation();
        } else if (this.followWayVector != null) {
            this.stepWithFollowVector();
        } else {
            this.stepWithWayNavigation();
            this.updateCurrentWayVector();
        }
        this.modifyPositionLock.release();
        ++this.currentStepPerSecond;
    }

    public void updateDirectionInput(Direction direction, boolean pushed) {
        long currentTime = new Date().getTime();
        if (pushed && currentTime > this.delayedPush) {
            this.delayedPush = currentTime + 20L;
        }
        switch (direction) {
            case LEFT: {
                if (this.directionInput.isLeftPushed() != pushed) {
                    this.switchDirectionEnabled = true;
                }
                this.directionInput.setLeftPushed(pushed);
                break;
            }
            case RIGHT: {
                if (this.directionInput.isRightPushed() != pushed) {
                    this.switchDirectionEnabled = true;
                }
                this.directionInput.setRightPushed(pushed);
                break;
            }
            case UP: {
                if (this.directionInput.isUpPushed() != pushed) {
                    this.switchDirectionEnabled = true;
                }
                this.directionInput.setUpPushed(pushed);
                break;
            }
            case DOWN: {
                if (this.directionInput.isDownPushed() != pushed) {
                    this.switchDirectionEnabled = true;
                }
                this.directionInput.setDownPushed(pushed);
            }
        }
    }

    public void setWindowHeight(int windowHeight) {
        this.windowHeight = windowHeight;
    }

    public void setWindowWidth(int windowWidth) {
        this.windowWidth = windowWidth;
    }

    public boolean[][] getRawImage(int labyrinthNumber) {
        this.needsRenderUpdate = false;
        int width = this.windowWidth;
        int height = this.windowHeight;
        return ImageRenderer.getRawImage(this.buildLabyrinthMetaData(), width, height, this.currentPosition.getxPosition(), this.currentPosition.getyPosition(), labyrinthNumber, this.timeout);
    }

    public void renderLabyrinth(int labyrinthNumber, HashMap<Integer, Point> playerPositionMap, LabyrinthNavigationView labyrinthNavigationView) {
        this.needsRenderUpdate = false;
        labyrinthNavigationView.showColoredLabyrinth(this.buildLabyrinthMetaData(), this.windowWidth, this.windowHeight, playerPositionMap, labyrinthNumber, this.timeout, this.leftTreasuresList, this.getWayToGoalIfTreasureIsActive(), this.playerEffectList);
        labyrinthNavigationView.repaint();
    }

    public int[] getImage() {
        this.needsRenderUpdate = false;
        int width = this.windowWidth;
        int height = this.windowHeight;
        return ImageRenderer.matrixToImage(ImageRenderer.getRawImage(this.buildLabyrinthMetaData(), width, height, this.currentPosition.getxPosition(), this.currentPosition.getyPosition(), 0, this.timeout));
    }

    public void renderColoredImageSplitScreen(int playerNumber, Point otherPosition, LabyrinthNavigationView view) {
        this.needsRenderUpdate = false;
        HashMap<Integer, Point> hashMap = new HashMap<Integer, Point>();
        hashMap.put(playerNumber, this.currentPosition);
        hashMap.put((playerNumber + 1) % 2, otherPosition);
        view.showColoredLabyrinth(this.buildLabyrinthMetaData(), this.windowWidth, this.windowHeight, hashMap, playerNumber, this.timeout, this.leftTreasuresList, this.getWayToGoalIfTreasureIsActive(), this.playerEffectList);
    }

    public boolean isGoalReached() {
        boolean isGoalReached;
        int currentLastShownSeconds = (int)(this.timeout - new Date().getTime()) / 1000;
        if (currentLastShownSeconds <= 0 && this.timeout != 0L) {
            return true;
        }
        double distance = this.currentPosition.getDistance(this.labyrinthField.getGoal());
        boolean bl = isGoalReached = distance < 5.0 * (double)this.scaleFactor;
        if (isGoalReached) {
            this.currentPosition = this.labyrinthField.getGoal();
            this.needsRenderUpdate = true;
        }
        return isGoalReached;
    }

    public GameState getGameState() {
        if (this.player != null && this.player.isDisconnected()) {
            return GameState.DISCONNECTED;
        }
        return this.gameState;
    }

    public void setGameState(GameState gameState) {
        if (this.gameState == GameState.DISCONNECTED) {
            return;
        }
        if (gameState == GameState.PLAYING && this.gameState != GameState.PLAYING) {
            this.startTime = new Date().getTime();
            double diameter = Math.sqrt(this.labyrinthField.getHeightWithoutScaleFactor() * this.labyrinthField.getHeightWithoutScaleFactor() + this.labyrinthField.getWidthWithoutScaleFactor() * this.labyrinthField.getWidthWithoutScaleFactor()) * 3.0;
            double maxTime = this.getMaxTime(diameter) + 15000.0;
            long endTime = new Date().getTime() + (long)maxTime;
            this.setTimeout(endTime);
            this.lastShownSeconds = (int)maxTime / 1000;
        }
        this.gameState = gameState;
        if (this.getViewModelProperties().isNetwork() && this.getViewModelProperties().isHost() && !this.getViewModelProperties().isListeningViewModel() && (gameState == GameState.WAITING || gameState == GameState.PLAYING && this.getViewModelProperties().isSplitScreen())) {
            this.needsToCommunicateGameStart = true;
        }
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public void reset() {
        if (this.labyrinthField != null) {
            int growingValue = this.getGrowingValue(this.labyrinthField.getWidthWithoutScaleFactor(), this.labyrinthField.getHeightWithoutScaleFactor());
            this.reset(this.currentScore != 0 ? this.labyrinthField.getWidthWithoutScaleFactor() + growingValue : this.labyrinthField.getWidthWithoutScaleFactor(), this.currentScore != 0 ? this.labyrinthField.getHeightWithoutScaleFactor() + growingValue : this.labyrinthField.getHeightWithoutScaleFactor());
            return;
        }
        this.reset(this.labyrinthWidth, this.labyrinthHeight);
    }

    public boolean isResetable() {
        return (this.distanceCounter == 0 || this.currentScore != 0 && this.scoreRecordList.size() < numberOfRounds) && !this.viewModelProperties.isListeningViewModel() && this.areListenersReady();
    }

    public boolean needsRenderUpdate() {
        boolean needsUpdate;
        int currentLastShownSeconds = (int)(this.timeout - new Date().getTime()) / 1000;
        boolean bl = needsUpdate = (this.needsRenderUpdate || currentLastShownSeconds < this.lastShownSeconds) && this.gameState == GameState.PLAYING;
        if (this.gameState == GameState.PLAYING) {
            this.needsRenderUpdate = false;
        }
        if (needsUpdate) {
            this.lastShownSeconds = currentLastShownSeconds;
        }
        return needsUpdate;
    }

    public boolean areListenersReady() {
        for (ViewModel viewModel : this.listeningViewModels) {
            if (viewModel.getGameState() != GameState.PLAYING) continue;
            return false;
        }
        return true;
    }

    public void startGameCountdown() {
        this.setGameState(GameState.WAITING);
        for (ViewModel viewModel : this.listeningViewModels) {
            viewModel.setGameState(GameState.WAITING);
        }
    }

    public void startGame() {
        this.setGameState(GameState.PLAYING);
        for (ViewModel viewModel : this.listeningViewModels) {
            viewModel.setGameState(GameState.PLAYING);
        }
    }

    public void reset(int width, int height) {
        Field field = null;
        int tries = 0;
        while (field == null && tries < 5) {
            try {
                double numberOfTreasures = 0.0;
                if (this.isTreasureMode && (this.playerNameList != null && this.playerNameList.size() > 1 || this.viewModelProperties.isSplitScreen())) {
                    numberOfTreasures = (double)(width * height) / 40000.0;
                    if (this.labyrinthText != null) {
                        numberOfTreasures *= 0.67;
                    }
                    int numberOfPlayers = this.viewModelProperties.isSplitScreen() ? 2 : this.playerNameList.size();
                    numberOfTreasures *= 0.5 + (double)numberOfPlayers / 5.0;
                    numberOfTreasures += 2.0;
                }
                field = new Field(width, height, this.scaleFactor, this.labyrinthText, this.isEasyMode, (int)numberOfTreasures);
                this.leftTreasuresList = (ArrayList)field.getTreasureList().clone();
            }
            catch (IndexOutOfBoundsException e) {
                ++tries;
            }
        }
        if (field != null) {
            for (ViewModel viewModel : this.listeningViewModels) {
                viewModel.updateField(field);
            }
            this.labyrinthField = field;
            this.hasChangedField = true;
        }
        this.resetWithoutField();
    }

    public void resetWithoutField() {
        this.directionInput = new DirectionInput();
        this.currentWayPointIndex = 0;
        this.currentMovingDirection = null;
        this.currentStepPerSecond = 0;
        this.lastMeasuredSecond = 0L;
        this.goingBackwards = false;
        this.currentScore = 0;
        this.distanceCounter = 0;
        this.timeout = 0L;
        this.treasureCount = 0;
        this.startTime = new Date().getTime();
        this.hasChangedFollowWayVector = false;
        this.hasChangedCurrentWayVector = false;
        this.currentWayVector = null;
        this.followWayVector = null;
        this.playerEffectList = new ArrayList();
        if (this.labyrinthField != null) {
            this.currentPosition = this.labyrinthField.getStartPoint();
            this.currentWay = this.labyrinthField.getFirstWay();
        }
    }

    public int getScore() {
        if (this.currentScore == 0) {
            long timeDiff = new Date().getTime() - this.startTime;
            int timeInMilliseconds = (int)timeDiff;
            int fieldSize = this.labyrinthField.getHeightWithoutScaleFactor() * this.labyrinthField.getWidthWithoutScaleFactor();
            double distanceToGoal = (double)this.labyrinthField.getDistanceToGoal() / (double)this.scaleFactor;
            double diameter = Math.sqrt(this.labyrinthField.getHeightWithoutScaleFactor() * this.labyrinthField.getHeightWithoutScaleFactor() + this.labyrinthField.getWidthWithoutScaleFactor() * this.labyrinthField.getWidthWithoutScaleFactor()) * 3.0;
            double baseValue = (double)fieldSize * (distanceToGoal + 200.0) * 3.0 / diameter;
            double minTime = this.getMinTime(diameter);
            double maxTime = this.getMaxTime(diameter);
            int maxScore = (int)(Math.pow(Math.pow(baseValue, 1.05) / minTime * 6.7, 0.95) * 0.55);
            int minScore = (int)(Math.pow(Math.pow(baseValue, 1.05) / maxTime * 10.0, 0.95) * 0.55);
            maxTime += 15000.0;
            if (this.isEasyMode) {
                maxScore = (int)((double)maxScore * 0.8);
                minScore = (int)((double)minScore * 0.8);
            }
            if (this.scaleFactor > 2) {
                minScore = (int)((double)minScore * (1.0 + (double)(this.scaleFactor - 2) * 0.1));
                maxScore = (int)((double)maxScore * (1.0 + (double)(this.scaleFactor - 2) * 0.1));
            }
            int scoreDiff = maxScore - minScore;
            double timeDiff2 = maxTime - minTime;
            double relativeTime = 1.0 - Math.min(Math.max(((double)timeDiff - minTime) / timeDiff2, 0.0), 1.0);
            this.currentScore = minScore + (int)((double)scoreDiff * relativeTime) + this.treasureCount * 10;
            if (this.player != null && this.player.isDisconnected()) {
                this.currentScore = (int)((double)this.currentScore * 0.75);
            }
            this.scoreRecordList.add(new ScoreRecord(this.scoreRecordList.size() + 1, fieldSize, (int)distanceToGoal, this.distanceCounter / this.scaleFactor, timeInMilliseconds, this.currentScore, this.treasureCount));
        }
        return this.currentScore;
    }

    private double getMinTime(double diameter) {
        return Math.pow(diameter, 1.175) * 1.1;
    }

    private double getMaxTime(double diameter) {
        return Math.pow(diameter, 1.825) * 0.11;
    }

    public void createScoreByTimeout() {
        this.getScore();
    }

    public String[][] getScoreTableData() {
        String[][] scoreTableData = new String[this.scoreRecordList.size()][7];
        int counter = 0;
        for (ScoreRecord scoreRecord : this.scoreRecordList) {
            scoreTableData[counter][0] = "" + scoreRecord.getRoundNumber();
            scoreTableData[counter][1] = "" + scoreRecord.getScore();
            scoreTableData[counter][2] = "" + scoreRecord.getShortestDistance();
            scoreTableData[counter][3] = "" + scoreRecord.getDistanceNeeded();
            scoreTableData[counter][4] = "" + (double)scoreRecord.getTimeNeeded() / 1000.0;
            scoreTableData[counter][5] = "" + scoreRecord.getArea();
            scoreTableData[counter][6] = "" + scoreRecord.getTreasureCount();
            ++counter;
        }
        return scoreTableData;
    }

    public Field getField() {
        return this.labyrinthField;
    }

    private void stepWithFreeNavigation() {
        int nextSteps = this.getNextSteps();
        boolean[][] wayPointMatrix = this.labyrinthField.getFlatWayPointMatrix();
        int currentX = this.currentPosition.getxPosition();
        int currentY = this.currentPosition.getyPosition();
        if (this.getDirectionInput().isDownPushed() && currentY < this.labyrinthField.getHeight() - nextSteps) {
            if (wayPointMatrix[currentX][currentY + nextSteps]) {
                this.setCurrentPositionForManualStep(new Point(this.currentPosition.getxPosition(), this.currentPosition.getyPosition() + nextSteps));
                return;
            }
            if (!this.getDirectionInput().isLeftPushed() && currentX < this.labyrinthField.getWidth() - 1 && wayPointMatrix[currentX + nextSteps][currentY + nextSteps]) {
                this.setCurrentPositionForManualStep(new Point(this.currentPosition.getxPosition() + nextSteps, this.currentPosition.getyPosition() + nextSteps));
                return;
            }
            if (!this.getDirectionInput().isRightPushed() && currentX > nextSteps - 1 && wayPointMatrix[currentX - nextSteps][currentY + nextSteps]) {
                this.setCurrentPositionForManualStep(new Point(this.currentPosition.getxPosition() - nextSteps, this.currentPosition.getyPosition() + nextSteps));
                return;
            }
        }
        if (this.getDirectionInput().isUpPushed() && currentY > nextSteps - 1) {
            if (wayPointMatrix[currentX][currentY - nextSteps]) {
                this.setCurrentPositionForManualStep(new Point(this.currentPosition.getxPosition(), this.currentPosition.getyPosition() - nextSteps));
                return;
            }
            if (!this.getDirectionInput().isLeftPushed() && currentX < this.labyrinthField.getWidth() - nextSteps && wayPointMatrix[currentX + nextSteps][currentY - nextSteps]) {
                this.setCurrentPositionForManualStep(new Point(this.currentPosition.getxPosition() + nextSteps, this.currentPosition.getyPosition() - nextSteps));
                return;
            }
            if (!this.getDirectionInput().isRightPushed() && currentX > nextSteps - 1 && wayPointMatrix[currentX - nextSteps][currentY - nextSteps]) {
                this.setCurrentPositionForManualStep(new Point(this.currentPosition.getxPosition() - nextSteps, this.currentPosition.getyPosition() - nextSteps));
                return;
            }
        }
        if (this.getDirectionInput().isRightPushed() && currentX < this.labyrinthField.getWidth() - nextSteps) {
            if (wayPointMatrix[currentX + nextSteps][currentY]) {
                this.setCurrentPositionForManualStep(new Point(this.currentPosition.getxPosition() + nextSteps, this.currentPosition.getyPosition()));
                return;
            }
            if (!this.getDirectionInput().isUpPushed() && currentY < this.labyrinthField.getHeight() - nextSteps && wayPointMatrix[currentX + nextSteps][currentY + nextSteps]) {
                this.setCurrentPositionForManualStep(new Point(this.currentPosition.getxPosition() + nextSteps, this.currentPosition.getyPosition() + nextSteps));
                return;
            }
            if (!this.getDirectionInput().isDownPushed() && currentY > nextSteps - 1 && wayPointMatrix[currentX + nextSteps][currentY - nextSteps]) {
                this.setCurrentPositionForManualStep(new Point(this.currentPosition.getxPosition() + nextSteps, this.currentPosition.getyPosition() - nextSteps));
                return;
            }
        }
        if (this.getDirectionInput().isLeftPushed() && currentX > nextSteps - 1) {
            if (wayPointMatrix[currentX - nextSteps][currentY]) {
                this.setCurrentPositionForManualStep(new Point(this.currentPosition.getxPosition() - nextSteps, this.currentPosition.getyPosition()));
            } else if (!this.getDirectionInput().isUpPushed() && currentY < this.labyrinthField.getHeight() - nextSteps && wayPointMatrix[currentX - nextSteps][currentY + nextSteps]) {
                this.setCurrentPositionForManualStep(new Point(this.currentPosition.getxPosition() - nextSteps, this.currentPosition.getyPosition() + nextSteps));
            } else if (!this.getDirectionInput().isDownPushed() && currentY > nextSteps - 1 && wayPointMatrix[currentX - nextSteps][currentY - nextSteps]) {
                this.setCurrentPositionForManualStep(new Point(this.currentPosition.getxPosition() - nextSteps, this.currentPosition.getyPosition() - nextSteps));
            }
        }
    }

    private int getNextSteps() {
        int nextSteps = Math.round((float)(this.getPointsPerSecond() * (this.currentStepPerSecond + 1)) / 120.0f) - Math.round((float)(this.getPointsPerSecond() * this.currentStepPerSecond) / 120.0f);
        long currentTime = new Date().getTime();
        if (currentTime > this.lastMeasuredSecond + 1000L) {
            this.lastMeasuredSecond += 1000L;
            this.currentStepPerSecond = 0;
        }
        return nextSteps;
    }

    private int getPointsPerSecond() {
        long currentTime = new Date().getTime();
        if (currentTime <= this.pointsPerSecondLastRefresh + 250L) {
            return this.pointsPerSecondCached;
        }
        this.pointsPerSecondLastRefresh = currentTime;
        int pointsPerSecond = this.pointsPerSecond * this.scaleFactor;
        boolean localInvertControls = false;
        boolean localShowWayToGoal = false;
        for (PlayerEffect playerEffect : this.playerEffectList) {
            if (playerEffect.getElapsesOn() < new Date().getTime()) {
                this.playerEffectList.remove(playerEffect);
                break;
            }
            if (playerEffect.getTreasureType() == TreasureType.SPEED_SELF && playerEffect.getEffectedPlayerNumber() == this.getPlayerNumber()) {
                pointsPerSecond = (int)((double)pointsPerSecond * 1.25);
                continue;
            }
            if ((playerEffect.getTreasureType() == TreasureType.SLOW_SELF || playerEffect.getTreasureType() == TreasureType.SLOW_FIRST) && playerEffect.getEffectedPlayerNumber() == this.getPlayerNumber()) {
                pointsPerSecond = (int)((double)pointsPerSecond / 1.25);
                continue;
            }
            if (playerEffect.getTreasureType() == TreasureType.SLOW_OTHERS && playerEffect.getEffectedPlayerNumber() != this.getPlayerNumber()) {
                pointsPerSecond = (int)((double)pointsPerSecond / 1.25);
                continue;
            }
            if (playerEffect.getTreasureType() == TreasureType.INVERT && playerEffect.getEffectedPlayerNumber() == this.getPlayerNumber()) {
                localInvertControls = true;
                continue;
            }
            if (playerEffect.getTreasureType() != TreasureType.SHOW_WAY_TO_GOAL || playerEffect.getEffectedPlayerNumber() != this.getPlayerNumber()) continue;
            localShowWayToGoal = true;
        }
        this.invertControls = localInvertControls;
        this.showWayToGoal = localShowWayToGoal;
        this.pointsPerSecondCached = pointsPerSecond;
        return pointsPerSecond;
    }

    private void setCurrentPositionForManualStep(Point newCurrentPosition) {
        this.currentPosition = newCurrentPosition;
        this.distanceCounter += this.scaleFactor;
        this.needsRenderUpdate = true;
    }

    private void stepWithWayNavigation() {
        int pushedAngle;
        boolean isStartWay;
        int nextSteps = this.getNextSteps();
        ArrayList<Point> pointCollection = this.currentWay.getPointCollection();
        Way rootWayForCurrentCrossing = this.currentWay;
        if (this.goingBackwards && this.currentWay.getPreviousWay() != null) {
            rootWayForCurrentCrossing = this.currentWay.getPreviousWay();
        }
        ArrayList<Way> nextWayList = (ArrayList<Way>)rootWayForCurrentCrossing.getNextWayList().clone();
        boolean bl = isStartWay = this.goingBackwards && this.currentWay.getPreviousWay() == null;
        if (isStartWay) {
            nextWayList = new ArrayList<Way>();
        }
        if (this.currentMovingDirection != null && this.switchDirectionEnabled && this.currentMovingDirection.isOppositeKeyPushed(this.getDirectionInput()) && this.currentWayPointIndex < pointCollection.size() - 1 && (pointCollection.size() - this.currentWayPointIndex > 6 * this.scaleFactor || nextWayList.size() < 2 || this.goingBackwards && rootWayForCurrentCrossing.getNextWayList().size() < 2)) {
            this.goingBackwards = !this.goingBackwards;
            this.currentWayPointIndex = pointCollection.size() - 1 - this.currentWayPointIndex;
            this.currentMovingDirection = new DirectionInput(this.currentWay.getRadAngle(this.scaleFactor, this.currentWayPointIndex, this.goingBackwards));
            this.switchDirectionEnabled = false;
        }
        if (pointCollection.size() > this.currentWayPointIndex) {
            this.currentPosition = pointCollection.get(this.goingBackwards ? pointCollection.size() - 1 - this.currentWayPointIndex : this.currentWayPointIndex);
            this.needsRenderUpdate = true;
            this.currentWayPointIndex += nextSteps;
            this.distanceCounter += nextSteps;
            this.currentMovingDirection = new DirectionInput(this.currentWay.getRadAngle(this.scaleFactor, this.currentWayPointIndex, this.goingBackwards));
            return;
        }
        if (!(nextWayList.size() != 1 || this.currentMovingDirection != null && this.currentMovingDirection.isOppositeKeyPushed(this.getDirectionInput()) && this.switchDirectionEnabled)) {
            this.currentWay = this.goingBackwards ? rootWayForCurrentCrossing : (Way)nextWayList.get(0);
            this.currentWayPointIndex = 0;
            this.currentMovingDirection = new DirectionInput(this.currentWay.getRadAngle(this.scaleFactor, 0, this.goingBackwards));
            this.switchDirectionEnabled = false;
            return;
        }
        nextWayList.add(rootWayForCurrentCrossing);
        if (this.getDirectionInput().isUpPushed()) {
            pushedAngle = this.getDirectionInput().isLeftPushed() ? 225 : (this.getDirectionInput().isRightPushed() ? 315 : 270);
        } else if (this.getDirectionInput().isDownPushed()) {
            pushedAngle = this.getDirectionInput().isLeftPushed() ? 135 : (this.getDirectionInput().isRightPushed() ? 45 : 90);
        } else if (this.getDirectionInput().isLeftPushed()) {
            pushedAngle = 180;
        } else if (this.getDirectionInput().isRightPushed()) {
            pushedAngle = 0;
        } else {
            return;
        }
        double pushedRadAngle = (double)pushedAngle / 180.0 * Math.PI;
        Way selectedWay = this.getShortestWayToAngle(rootWayForCurrentCrossing, nextWayList, isStartWay, pushedRadAngle);
        if (pushedAngle % 90 == 0) {
            ArrayList<DirectionWay> allNextWays = new ArrayList<DirectionWay>();
            for (Way nextWay : nextWayList) {
                allNextWays.add(new DirectionWay(nextWay, nextWay.getRadAngle(this.scaleFactor, 0, nextWay == rootWayForCurrentCrossing && !isStartWay)));
            }
            HashSet<Way> selectableWays = new HashSet<Way>();
            Way topWay = this.getShortestWayToAngle(rootWayForCurrentCrossing, nextWayList, isStartWay, Direction.UP.getRadAngle());
            Way botWay = this.getShortestWayToAngle(rootWayForCurrentCrossing, nextWayList, isStartWay, Direction.DOWN.getRadAngle());
            Way leftWay = this.getShortestWayToAngle(rootWayForCurrentCrossing, nextWayList, isStartWay, Direction.LEFT.getRadAngle());
            Way rightWay = this.getShortestWayToAngle(rootWayForCurrentCrossing, nextWayList, isStartWay, Direction.RIGHT.getRadAngle());
            if (topWay != null) {
                selectableWays.add(topWay);
            }
            if (botWay != null) {
                selectableWays.add(botWay);
            }
            if (leftWay != null) {
                selectableWays.add(leftWay);
            }
            if (rightWay != null) {
                selectableWays.add(rightWay);
            }
            if (allNextWays.size() > selectableWays.size()) {
                Way newChosenDirection;
                ArrayList<Direction> leftDirections = new ArrayList<Direction>();
                leftDirections.add(Direction.UP);
                leftDirections.add(Direction.DOWN);
                leftDirections.add(Direction.LEFT);
                leftDirections.add(Direction.RIGHT);
                DirectionAssignment bestDirectionAssignment = this.getBestDirectionAssignment(allNextWays, leftDirections);
                if (bestDirectionAssignment != null && (newChosenDirection = bestDirectionAssignment.getDirectionByDegrees(pushedAngle)) != null) {
                    selectedWay = newChosenDirection;
                }
            }
        }
        if (selectedWay == null) {
            return;
        }
        this.goingBackwards = selectedWay == rootWayForCurrentCrossing && !isStartWay;
        this.currentWay = selectedWay;
        this.currentWayPointIndex = 0;
        this.currentMovingDirection = new DirectionInput(this.currentWay.getRadAngle(this.scaleFactor, 0, this.goingBackwards));
        this.switchDirectionEnabled = false;
    }

    private DirectionAssignment getBestDirectionAssignment(ArrayList<DirectionWay> leftWays, ArrayList<Direction> leftDirections) {
        DirectionAssignment bestDirectionAssignment = null;
        ArrayList<DirectionWay> leftWaysCopy = new ArrayList<DirectionWay>(leftWays);
        ArrayList<Direction> leftDirectionsCopy = new ArrayList<Direction>(leftDirections);
        for (DirectionWay leftWay : leftWaysCopy) {
            for (Direction leftDirection : leftDirectionsCopy) {
                DirectionAssignment nextDirectionAssignment;
                if (AngleDistanceCalculator.getDistanceBetweenRadAngles(leftWay.getCurrentRadAngle(), leftDirection.getRadAngle()) > 1.5707963267948966) continue;
                if (leftWays.size() == 1) {
                    nextDirectionAssignment = new DirectionAssignment();
                } else {
                    leftWays.remove(leftWay);
                    leftDirections.remove((Object)leftDirection);
                    nextDirectionAssignment = this.getBestDirectionAssignment(leftWays, leftDirections);
                    leftWays.add(leftWay);
                    leftDirections.add(leftDirection);
                }
                if (nextDirectionAssignment == null) continue;
                nextDirectionAssignment.addWay(leftDirection, leftWay);
                if (bestDirectionAssignment != null && !(nextDirectionAssignment.getDistance() < bestDirectionAssignment.getDistance())) continue;
                bestDirectionAssignment = nextDirectionAssignment;
            }
        }
        return bestDirectionAssignment;
    }

    private Way getShortestWayToAngle(Way rootWayForCurrentCrossing, ArrayList<Way> nextWayList, boolean isStartWay, double pushedRadAngle) {
        Way selectedWay = null;
        double distance = 1.5707963267948966;
        for (Way possibleWay : nextWayList) {
            boolean bl = possibleWay == rootWayForCurrentCrossing && !isStartWay;
            boolean directionSwitched = bl;
            double wayAngle = possibleWay.getRadAngle(this.scaleFactor, 0, directionSwitched);
            double currentDistance = AngleDistanceCalculator.getDistanceBetweenRadAngles(wayAngle, pushedRadAngle);
            if (!(currentDistance < distance)) continue;
            selectedWay = possibleWay;
            distance = currentDistance;
        }
        return selectedWay;
    }

    private DirectionInput getDirectionInput() {
        long currentTime = new Date().getTime();
        if (currentTime < this.delayedPush && (this.currentWayPointIndex < 2 || this.currentWayPointIndex > this.currentWay.getPointCollection().size() - 3)) {
            try {
                Thread.sleep(this.delayedPush - currentTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.invertControls) {
            return this.directionInput.getOpposite();
        }
        return this.directionInput;
    }

    private void stepWithFollowVector() {
        boolean isStartWay;
        boolean hasChangedDirection;
        int nextSteps = this.getNextSteps();
        ArrayList<Point> pointCollection = this.currentWay.getPointCollection();
        Way followVectorWay = this.getWayById(this.followWayVector.getWayId());
        boolean goingBackwardsBefore = this.goingBackwards;
        if (this.currentWay.getId() == this.followWayVector.getWayId()) {
            this.goingBackwards = this.followWayVector.isInvertDirection();
        } else if (followVectorWay != null) {
            this.goingBackwards = this.isWayBeforeOrEquals(followVectorWay, this.currentWay);
        }
        boolean bl = hasChangedDirection = this.goingBackwards != goingBackwardsBefore;
        if (pointCollection.size() > this.currentWayPointIndex) {
            Point nextCurrentPosition;
            if (hasChangedDirection && this.currentWayPointIndex < pointCollection.size() - 1 && this.currentWayPointIndex > 0) {
                this.currentWayPointIndex = pointCollection.size() - 1 - this.currentWayPointIndex;
            }
            if (this.currentPosition.getDistance(nextCurrentPosition = pointCollection.get(this.goingBackwards ? pointCollection.size() - 1 - this.currentWayPointIndex : this.currentWayPointIndex)) > (double)pointCollection.size() / 2.0) {
                this.currentWayPointIndex = pointCollection.size() - 1 - this.currentWayPointIndex;
                nextCurrentPosition = pointCollection.get(this.goingBackwards ? pointCollection.size() - 1 - this.currentWayPointIndex : this.currentWayPointIndex);
            }
            this.currentPosition = nextCurrentPosition;
            this.needsRenderUpdate = true;
            this.currentWayPointIndex += nextSteps;
            this.distanceCounter += nextSteps;
            return;
        }
        if (this.currentWay.getId() == this.followWayVector.getWayId() && this.followWayVector.isInvertDirection() == this.goingBackwards && !hasChangedDirection) {
            return;
        }
        Way rootWayForCurrentCrossing = this.currentWay;
        if (this.goingBackwards && this.currentWay.getPreviousWay() != null) {
            rootWayForCurrentCrossing = this.currentWay.getPreviousWay();
        }
        ArrayList<Way> nextWayList = (ArrayList<Way>)rootWayForCurrentCrossing.getNextWayList().clone();
        boolean bl2 = isStartWay = this.goingBackwards && this.currentWay.getPreviousWay() == null;
        if (isStartWay) {
            nextWayList = new ArrayList<Way>();
        }
        nextWayList.add(rootWayForCurrentCrossing);
        Way selectedWay = null;
        for (Way possibleWay : nextWayList) {
            if (possibleWay.getId() != this.followWayVector.getWayId()) continue;
            selectedWay = possibleWay;
            this.goingBackwards = selectedWay == rootWayForCurrentCrossing && !isStartWay;
            break;
        }
        if (selectedWay == null) {
            if (followVectorWay == null) {
                return;
            }
            for (Way possibleWay : nextWayList) {
                if (possibleWay.getId() == rootWayForCurrentCrossing.getId()) {
                    if (!this.isWayBeforeOrEquals(followVectorWay, possibleWay)) continue;
                    selectedWay = possibleWay;
                    this.goingBackwards = true;
                    break;
                }
                if (!this.isWayAfter(followVectorWay, possibleWay)) continue;
                selectedWay = possibleWay;
                this.goingBackwards = false;
                break;
            }
        }
        if (selectedWay == null) {
            return;
        }
        this.currentWay = selectedWay;
        this.currentWayPointIndex = 0;
    }

    private boolean isWayAfter(Way wayToFind, Way currentWay) {
        HashSet<Way> notFollowList = new HashSet<Way>();
        notFollowList.add(currentWay);
        if (currentWay.getNextWayList().size() == 0) {
            return false;
        }
        return this.canFindWayAfter(wayToFind, currentWay.getNextWayList(), notFollowList);
    }

    private boolean isWayBeforeOrEquals(Way wayToFind, Way currentWay) {
        if (wayToFind.getId() == currentWay.getId()) {
            return true;
        }
        HashSet<Way> notFollowList = new HashSet<Way>();
        notFollowList.add(currentWay);
        if (currentWay.getPreviousWay() == null) {
            return false;
        }
        ArrayList<Way> currentWayList = new ArrayList<Way>();
        currentWayList.add(currentWay.getPreviousWay());
        return this.canFindWayAfter(wayToFind, currentWayList, notFollowList);
    }

    private boolean canFindWayAfter(Way wayToFind, ArrayList<Way> currentWayList, HashSet<Way> notFollowList) {
        for (Way currentWay : currentWayList) {
            if (wayToFind.getId() != currentWay.getId()) continue;
            return true;
        }
        while (currentWayList.size() > 0) {
            ArrayList<Way> nextWayList = new ArrayList<Way>();
            for (Way wayFromList : currentWayList) {
                for (Way wayToFollow : wayFromList.getAllWaysCrossing()) {
                    if (notFollowList.contains(wayToFollow)) continue;
                    if (wayToFollow.getId() == wayToFind.getId()) {
                        return true;
                    }
                    notFollowList.add(wayToFollow);
                    nextWayList.add(wayToFollow);
                }
            }
            currentWayList = nextWayList;
        }
        return false;
    }

    private int getGrowingValue(int width, int height) {
        int growingArea = 35625;
        double abHalf = (double)(width + height) / 2.0;
        double x = Math.sqrt(abHalf * abHalf + (double)growingArea) - abHalf;
        return (int)x;
    }

    public VictoryMetaData buildVictoryMetaData() {
        return new VictoryMetaData(this.getScore(), this.getScoreTableData(), this.isBestOfThenMode, this.player == null ? 0 : this.player.getPlayerNumber());
    }

    public Point getCurrentPosition() {
        return this.currentPosition;
    }

    public LabyrinthFieldMetaData buildLabyrinthMetaData() {
        return new LabyrinthFieldMetaData(this.labyrinthField, this.navigationMode, this.playerNameList, this.windowWidth, this.windowHeight, this.isBestOfThenMode);
    }

    public boolean hasChangedField() {
        if (this.hasChangedField) {
            this.hasChangedField = false;
            return true;
        }
        return false;
    }

    public void markAsDisconnected() {
        if (this.player != null) {
            this.player.setDisconnected(true);
            this.setGameState(GameState.DISCONNECTED);
        }
    }

    public void setPlayerNameList(ArrayList<String> playerNameList) {
        this.playerNameList = playerNameList;
    }

    public ArrayList<String> getPlayerNameList() {
        return this.playerNameList;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public boolean hasLabyrinthData() {
        return this.labyrinthField != null;
    }

    private Way getWayById(int currentWayId) {
        for (Way currentWay : this.labyrinthField.getWayCollection()) {
            if (currentWayId != currentWay.getId()) continue;
            return currentWay;
        }
        return null;
    }

    public static long getMillisecondsForStep() {
        return 8L;
    }

    public boolean hasFollowWayVectorChanged() {
        return this.hasChangedFollowWayVector;
    }

    public boolean hasCurrentVectorChanged() {
        return this.hasChangedCurrentWayVector;
    }

    public WayVector getWayFollowVector() {
        this.hasChangedFollowWayVector = false;
        return this.followWayVector;
    }

    public WayVector getCurrentWayVector() {
        this.hasChangedCurrentWayVector = false;
        return this.currentWayVector;
    }

    public void followWayVector(WayVector wayVector) {
        this.followWayVector = wayVector;
        this.hasChangedFollowWayVector = true;
    }

    private void updateCurrentWayVector() {
        WayVector currentWayVector = new WayVector(this.currentWay.getId(), this.goingBackwards);
        if (this.currentWayVector == null || !currentWayVector.equals(this.currentWayVector)) {
            this.currentWayVector = currentWayVector;
            this.hasChangedCurrentWayVector = true;
        }
    }

    public boolean needsToCommunicateGameStart() {
        if (this.needsToCommunicateGameStart) {
            this.needsToCommunicateGameStart = false;
            return true;
        }
        return false;
    }

    public void triggerRenderUpdate() {
        this.needsRenderUpdate = true;
    }

    public boolean isWayPointMatrixLoaded() {
        return this.labyrinthField.getWayPointMatrix() != null;
    }

    public ViewModelProperties getViewModelProperties() {
        return this.viewModelProperties;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setCurrentScore() {
        this.currentScore = 1;
    }

    public void pickUpTreasure(int treasureId) {
        for (Treasure treasureFromLoop : this.leftTreasuresList) {
            if (treasureId != treasureFromLoop.getId()) continue;
            this.leftTreasuresList.remove(treasureFromLoop);
            return;
        }
    }

    public void addPlayerEffect(PlayerEffect playerEffect) {
        if (playerEffect.getPickUpPlayerNumber() == this.getPlayerNumber()) {
            ++this.treasureCount;
        }
        this.playerEffectList.add(playerEffect);
    }

    public void switchPositions(ViewModel otherViewModel) {
        WayVector followWayVector = null;
        if (this.followWayVector != null) {
            if (otherViewModel.followWayVector == null) {
                this.followWayVector = new WayVector(otherViewModel.currentWay.getId(), otherViewModel.goingBackwards);
                this.hasChangedFollowWayVector = true;
            } else {
                followWayVector = otherViewModel.followWayVector;
            }
        }
        if (otherViewModel.followWayVector != null) {
            if (this.followWayVector == null) {
                otherViewModel.followWayVector = new WayVector(this.currentWay.getId(), this.goingBackwards);
            } else {
                this.followWayVector = otherViewModel.followWayVector;
                this.hasChangedFollowWayVector = true;
                otherViewModel.followWayVector = followWayVector;
            }
            otherViewModel.hasChangedFollowWayVector = true;
        }
        Point currentPosition = otherViewModel.currentPosition;
        boolean goingBackwards = otherViewModel.goingBackwards;
        int currentWayPointIndex = otherViewModel.currentWayPointIndex;
        Way currentWay = null;
        for (Way way : this.getField().getWayCollection()) {
            if (way.getId() != otherViewModel.currentWay.getId()) continue;
            currentWay = way;
            break;
        }
        try {
            otherViewModel.modifyPositionLock.acquire();
        }
        catch (InterruptedException e) {
            LogHandler.notifyException(e);
        }
        otherViewModel.currentPosition = this.currentPosition;
        otherViewModel.goingBackwards = this.goingBackwards;
        otherViewModel.currentWayPointIndex = this.currentWayPointIndex;
        for (Way way : otherViewModel.getField().getWayCollection()) {
            if (way.getId() != this.currentWay.getId()) continue;
            otherViewModel.currentWay = way;
            break;
        }
        otherViewModel.modifyPositionLock.release();
        try {
            this.modifyPositionLock.acquire();
        }
        catch (InterruptedException e) {
            LogHandler.notifyException(e);
        }
        this.currentPosition = currentPosition;
        this.goingBackwards = goingBackwards;
        this.currentWayPointIndex = currentWayPointIndex;
        this.currentWay = currentWay;
        this.modifyPositionLock.release();
    }

    public ArrayList<Treasure> getLeftTreasuresList() {
        return this.leftTreasuresList;
    }

    public Treasure getTreasureById(int id) {
        for (Treasure treasure : this.leftTreasuresList) {
            if (treasure.getId() != id) continue;
            return treasure;
        }
        return null;
    }

    public int getPlayerNumber() {
        if (this.player != null) {
            return this.player.getPlayerNumber();
        }
        return this.viewModelProperties.isListeningViewModel() ? 1 : 0;
    }

    public ArrayList<Way> getShortestWayToGoal() {
        if (this.isGoalReached()) {
            return new ArrayList<Way>();
        }
        ArrayList<Way> searchBackwards = this.deepSearchWay(this.labyrinthField.getGoalWay(), this.currentWay, new ArrayList<Way>(), new ArrayList<Way>(), true);
        if (searchBackwards != null) {
            this.lastDeepWaySearchBackwards = searchBackwards;
            this.deepWaySearchLastCurrentWayBackwards = this.currentWay;
            return searchBackwards;
        }
        ArrayList<Way> searchForward = this.deepSearchWay(this.labyrinthField.getGoalWay(), this.currentWay, new ArrayList<Way>(), new ArrayList<Way>(), false);
        this.lastDeepWaySearchForwards = searchForward;
        this.deepWaySearchLastCurrentWayForwards = this.currentWay;
        return searchForward;
    }

    public int getDistanceToGoal() {
        ArrayList<Way> wayToGoal = this.getShortestWayToGoal();
        int distance = 0;
        for (Way way : wayToGoal) {
            distance += way.getPointCollection().size() - 1;
        }
        return distance;
    }

    private ArrayList<Way> deepSearchWay(Way wayToFind, Way currentWay, ArrayList<Way> notFollowList, ArrayList<Way> currentPath, boolean goBack) {
        if (currentPath.isEmpty()) {
            boolean movingToGoal = this.isWayAfter(wayToFind, currentWay);
            Way shortenedWay = new Way(currentWay, LabUtils.limitInt(this.goingBackwards == movingToGoal ? this.currentWayPointIndex : currentWay.getPointCollection().size() - 1 - this.currentWayPointIndex, 0, currentWay.getPointCollection().size() - 1), !movingToGoal);
            currentPath.add(shortenedWay);
            if (goBack) {
                if (currentWay.equals(this.deepWaySearchLastCurrentWayBackwards)) {
                    this.lastDeepWaySearchBackwards.set(0, shortenedWay);
                    return this.lastDeepWaySearchBackwards;
                }
            } else if (currentWay.equals(this.deepWaySearchLastCurrentWayForwards)) {
                this.lastDeepWaySearchForwards.set(0, shortenedWay);
                return this.lastDeepWaySearchForwards;
            }
        }
        if (currentWay.equals(wayToFind)) {
            return currentPath;
        }
        notFollowList.add(currentWay);
        ArrayList<Way> nextWayList = goBack ? currentWay.getAllWaysBackwards() : currentWay.getNextWayList();
        for (Way nextWay : nextWayList) {
            if (notFollowList.contains(nextWay)) continue;
            currentPath.add(nextWay);
            ArrayList<Way> foundWays = this.deepSearchWay(wayToFind, nextWay, notFollowList, currentPath, nextWay.equals(currentWay.getPreviousWay()));
            if (foundWays != null) {
                return foundWays;
            }
            currentPath.remove(nextWay);
        }
        return null;
    }

    public ArrayList<Way> getWayToGoalIfTreasureIsActive() {
        if (this.showWayToGoal) {
            return this.getShortestWayToGoal();
        }
        return null;
    }

    public ArrayList<PlayerEffect> getPlayerEffectList() {
        return this.playerEffectList;
    }

    public void applyPlayerName(String playerName) {
        if (this.player == null) {
            int playerNumber = this.getPlayerNumber();
            this.player = new Player();
            this.player.setPlayerNumber(playerNumber);
        }
        this.player.setName(playerName);
    }
}

