/*
 * Decompiled with CFR 0.152.
 */
package network;

import game.utils.LogHandler;
import gameServer.ClientSide.GameCoordinatorConnection;
import java.io.IOException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessControlException;
import network.LobbyListener;
import network.Player;
import network.ReadWriteHelper;
import network.thread.ClientLobbyListenerThread;

public class ClientConnection {
    private LobbyListener joinListener;
    private Player player;
    private ClientLobbyListenerThread clientLobbyListenerThread;
    private int numberOfPlayers;
    private boolean isActive = true;
    private boolean isHost = false;

    public ClientConnection(String ip, int port, LobbyListener joinListener, String playerName) throws IOException {
        Socket client = new Socket(ip, port);
        client.setSoTimeout(600000);
        this.player = new Player(client);
        this.player.setName(playerName);
        if (!ip.equals("127.0.0.1") && this.player.getDatagramClient() == null) {
            try {
                DatagramSocket datagramSocket = new DatagramSocket(port);
                this.player.setDatagramClient(datagramSocket);
            }
            catch (BindException | AccessControlException exception) {
                // empty catch block
            }
        }
        this.joinListener = joinListener;
        this.clientLobbyListenerThread = new ClientLobbyListenerThread(this, joinListener);
        this.clientLobbyListenerThread.start();
        ReadWriteHelper.writeSocketMessage(client, "shareName;" + playerName);
    }

    public ClientConnection(GameCoordinatorConnection gameCoordinatorConnection, String playerName, boolean isHost) throws IOException {
        Socket client = gameCoordinatorConnection.getClientSocket();
        this.player = new Player(client);
        this.player.setName(playerName);
        this.isHost = isHost;
        if (!gameCoordinatorConnection.getClientSocket().getInetAddress().getHostAddress().equals("127.0.0.1") && this.player.getDatagramClient() == null) {
            try {
                DatagramSocket datagramSocket = new DatagramSocket(1357);
                this.player.setDatagramClient(datagramSocket);
            }
            catch (BindException | AccessControlException exception) {
                // empty catch block
            }
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public void disconnect() {
        if (!this.isActive) {
            return;
        }
        try {
            ReadWriteHelper.writeSocketMessage(this.player.getClient(), "disconnect;");
        }
        catch (SocketException e) {
            if (!this.player.getClient().isConnected()) {
                this.player.setDisconnected(true);
            }
        }
        catch (IOException e) {
            LogHandler.notifyException(e);
        }
        this.disconnectPlayer(false);
    }

    public void disconnectPlayer(boolean notifyListener) {
        this.isActive = false;
        try {
            if (this.clientLobbyListenerThread != null) {
                this.clientLobbyListenerThread.stopThread();
                this.player.getClient().close();
            }
            if (notifyListener) {
                this.joinListener.showMessageDialog("You disconnected from the server.");
                this.joinListener.disconnect();
            }
            if (this.player.getDatagramClient() != null) {
                this.player.getDatagramClient().close();
            }
        }
        catch (IOException e) {
            LogHandler.notifyException(e);
        }
    }

    public void updatePlayers(String[] playerNames, int selfIndex) {
        this.joinListener.playerNameUpdate(playerNames);
        this.numberOfPlayers = playerNames.length;
        this.player.setPlayerNumber(selfIndex);
        if (this.player.getDatagramClient() == null && this.player.getClient().getInetAddress().getHostAddress().equals("127.0.0.1")) {
            int datagramSocketPort = this.player.getClient().getPort() + this.numberOfPlayers - 1;
            if (this.isHost) {
                --datagramSocketPort;
            }
            try {
                DatagramSocket datagramSocket = new DatagramSocket(datagramSocketPort);
                this.player.setDatagramClient(datagramSocket);
            }
            catch (SocketException e) {
                this.disconnect();
            }
        }
    }

    public int getNumberOfPlayers() {
        return this.numberOfPlayers;
    }

    public void startGame(boolean preferSplitscreen) {
        if (this.clientLobbyListenerThread != null) {
            this.clientLobbyListenerThread.stopThread();
            try {
                ReadWriteHelper.writeSocketMessage(this.player.getClient(), "startGame;");
            }
            catch (IOException e) {
                this.joinListener.showMessageDialog("Connection lost.");
                this.disconnect();
                LogHandler.notifyException(e);
            }
        }
        this.joinListener.start(preferSplitscreen);
    }

    public void setLobbyListener(LobbyListener lobbyListener) {
        this.joinListener = lobbyListener;
    }
}

