/*
 * Decompiled with CFR 0.152.
 */
package network;

import game.ShutdownGameCoordinator;
import game.utils.LogHandler;
import gameServer.Client;
import gameServer.ClientState;
import java.io.IOException;
import java.net.BindException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import menu.GameCoordinatorApplicationState;
import network.ClientConnection;
import network.CreateServerException;
import network.LobbyListener;
import network.ServerConnection;

public class Connection {
    private int port = 1357;
    private boolean isHost;
    private String ip;
    private ServerConnection serverLobbyConnection;
    private ClientConnection clientConnection;

    public Connection() {
        this.isHost = true;
    }

    public Connection(String ip) {
        this.ip = ip;
        this.isHost = false;
    }

    public Connection(GameCoordinatorApplicationState gameCoordinatorApplicationState, boolean isHost, String playerName) throws IOException {
        this.isHost = isHost;
        this.clientConnection = new ClientConnection(gameCoordinatorApplicationState.getGameCoordinatorConnection(), playerName, isHost);
        if (isHost) {
            gameCoordinatorApplicationState.setClientState(ClientState.LOBBY_HOST);
        } else {
            gameCoordinatorApplicationState.setClientState(ClientState.LOBBY_CLIENT);
        }
        gameCoordinatorApplicationState.getGameCoordinatorConnection().setClientConnection(this.clientConnection);
    }

    public Connection(ArrayList<Client> gameServerClients, Client host, ShutdownGameCoordinator shutdownGameCoordinator) throws SocketException {
        this.serverLobbyConnection = new ServerConnection(gameServerClients, host, shutdownGameCoordinator);
    }

    public void addLobbyListenerToClientConnection(LobbyListener lobbyListener) {
        this.clientConnection.setLobbyListener(lobbyListener);
    }

    public boolean isHost() {
        return this.isHost;
    }

    public ServerConnection getServerLobbyConnection() {
        return this.serverLobbyConnection;
    }

    public ClientConnection getClientConnection() {
        return this.clientConnection;
    }

    public boolean startClientConnection(LobbyListener joinListener, String playerName) {
        if (this.isHost) {
            return false;
        }
        try {
            this.clientConnection = new ClientConnection(this.ip, this.port, joinListener, playerName);
        }
        catch (SocketException | UnknownHostException e) {
            joinListener.showMessageDialog("connection failed.");
            return false;
        }
        catch (IOException e) {
            LogHandler.notifyException(e);
            return false;
        }
        return true;
    }

    public void startServerLobbyConnection(LobbyListener joinListener, String playerName) {
        if (this.isHost) {
            try {
                this.serverLobbyConnection = new ServerConnection(this.port, joinListener, playerName);
            }
            catch (BindException e) {
                throw new CreateServerException();
            }
            catch (IOException e) {
                joinListener.showMessageDialog("Starting server failed.");
                LogHandler.notifyException(e);
                joinListener.disconnect();
            }
        }
    }

    public void stop() {
        if (this.isHost) {
            if (this.serverLobbyConnection != null) {
                this.serverLobbyConnection.disconnect();
            }
        } else {
            this.clientConnection.disconnect();
        }
    }
}

