/*
 * Decompiled with CFR 0.152.
 */
package network;

import java.io.Serializable;
import java.util.ArrayList;
import labyrinthField.Field;
import navigationView.NavigationMode;

public class LabyrinthFieldMetaData
implements Serializable {
    private static final long serialVersionUID = -8487555976519424413L;
    private Field labyrinthField;
    private NavigationMode navigationMode;
    private ArrayList<String> playerNameList;
    private int windowWidth;
    private int windowHeight;
    private boolean isBestOfTenMode;

    public LabyrinthFieldMetaData(Field labyrinthField, NavigationMode navigationMode, ArrayList<String> playerNameList, int windowWidth, int windowHeight, boolean isBestOfTenMode) {
        this.navigationMode = navigationMode;
        this.labyrinthField = labyrinthField;
        this.playerNameList = playerNameList;
        this.windowWidth = windowWidth;
        this.windowHeight = windowHeight;
        this.isBestOfTenMode = isBestOfTenMode;
    }

    public boolean[][] getWayPointMatrix() {
        return this.labyrinthField.getFlatWayPointMatrix();
    }

    public boolean[][] getWayPointMatrixNonFlat() {
        return this.labyrinthField.getWayPointMatrix();
    }

    public int getWidth() {
        return this.labyrinthField.getWidth();
    }

    public int getHeight() {
        return this.labyrinthField.getHeight();
    }

    public int getGoalX() {
        return this.labyrinthField.getGoal().getxPosition();
    }

    public int getGoalY() {
        return this.labyrinthField.getGoal().getyPosition();
    }

    public int getScaleFactor() {
        return this.labyrinthField.getScaleFactor();
    }

    public ArrayList<String> getPlayerNameList() {
        return this.playerNameList;
    }

    public NavigationMode getNavigationMode() {
        return this.navigationMode;
    }

    public Field getLabyrinthField() {
        return this.labyrinthField;
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public boolean isBestOfTenMode() {
        return this.isBestOfTenMode;
    }
}

