/*
 * Decompiled with CFR 0.152.
 */
package network;

import game.utils.LogHandler;
import java.net.DatagramSocket;
import java.net.Socket;

public class Player {
    private Socket client;
    private DatagramSocket datagramClient;
    private String name = "unknown";
    private boolean isDisconnected = false;
    private int isUdpWorking = 0;
    private int playerPort;
    private int playerNumber = -1;
    private boolean isHost;

    public Player() {
    }

    public Player(Socket client) {
        this.client = client;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDatagramClient(DatagramSocket datagramClient) {
        this.datagramClient = datagramClient;
    }

    public Socket getClient() {
        return this.client;
    }

    public String getName() {
        return this.name;
    }

    public void setDisconnected(boolean isDisconnected) {
        if (!this.isDisconnected && isDisconnected) {
            LogHandler.notifyDebugMessage("Player " + this.getName() + " disconnected.");
        }
        this.isDisconnected = isDisconnected;
    }

    public boolean isDisconnected() {
        return this.isDisconnected;
    }

    public DatagramSocket getDatagramClient() {
        return this.datagramClient;
    }

    public int getPlayerPort() {
        return this.playerPort;
    }

    public void setPlayerPort(int playerPort) {
        this.playerPort = playerPort;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public void setPlayerNumber(int playerNumber) {
        this.playerNumber = playerNumber;
    }

    public void setUdpWorking(boolean b) {
        this.isUdpWorking = b ? 1 : -1;
    }

    public boolean isUdpWorking() {
        return this.isUdpWorking == 1;
    }

    public boolean hasSetUdpWorking() {
        return this.isUdpWorking != 0;
    }

    public boolean isHost() {
        return this.isHost;
    }

    public void setHost(boolean host) {
        this.isHost = host;
    }
}

