/*
 * Decompiled with CFR 0.152.
 */
package network;

import game.utils.LogHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.concurrent.Semaphore;
import network.SerializableNetworkObject;

public class ReadWriteHelper {
    private static HashMap<Socket, ObjectOutputStream> oosMap = new HashMap();
    private static HashMap<Socket, ObjectInputStream> oisMap = new HashMap();
    private static HashMap<Socket, Semaphore> lock = new HashMap();
    public static boolean debugTraffic = false;

    public static void writeSocketMessage(Socket socket, String nachricht) throws IOException {
        ReadWriteHelper.writeSocketObject(socket, new SerializableNetworkObject(nachricht));
    }

    public static String readSocketMessage(Socket socket) throws IOException {
        try {
            return ReadWriteHelper.readSocketObject(socket).getCommand();
        }
        catch (ClassNotFoundException e) {
            return "";
        }
    }

    public static void writeSocketObject(Socket socket, SerializableNetworkObject object) throws IOException {
        if (debugTraffic) {
            if (object.getCommand() != null) {
                if (!object.getCommand().contains("sendScore")) {
                    LogHandler.notifyDebugMessage("write " + object.getCommand());
                }
            } else {
                String subObjectName = object.getSubObjectName();
                if (!subObjectName.equals("updateRecordList") && !subObjectName.equals("wayVector")) {
                    LogHandler.notifyDebugMessage("write " + subObjectName);
                }
            }
        }
        if (!lock.containsKey(socket)) {
            lock.put(socket, new Semaphore(1));
        }
        try {
            lock.get(socket).acquire();
        }
        catch (InterruptedException e) {
            LogHandler.notifyException(e);
        }
        if (!oosMap.containsKey(socket)) {
            oosMap.put(socket, new ObjectOutputStream(socket.getOutputStream()));
        }
        try {
            oosMap.get(socket).writeObject(object);
            oosMap.get(socket).flush();
        }
        catch (IOException e) {
            lock.get(socket).release();
            throw e;
        }
        lock.get(socket).release();
    }

    public static SerializableNetworkObject readSocketObject(Socket socket) throws IOException, ClassNotFoundException {
        if (!oisMap.containsKey(socket)) {
            oisMap.put(socket, new ObjectInputStream(socket.getInputStream()));
        }
        SerializableNetworkObject serializableNetworkObject = (SerializableNetworkObject)oisMap.get(socket).readObject();
        if (debugTraffic) {
            if (serializableNetworkObject.getCommand() != null) {
                if (serializableNetworkObject.getCommand().contains("sendScore")) {
                    return serializableNetworkObject;
                }
                LogHandler.notifyDebugMessage("read " + serializableNetworkObject.getCommand());
            } else {
                String subObjectName = serializableNetworkObject.getSubObjectName();
                if (!subObjectName.equals("updateRecordList") && !subObjectName.equals("wayVector")) {
                    LogHandler.notifyDebugMessage("read " + subObjectName);
                }
            }
        }
        return serializableNetworkObject;
    }

    public static SerializableNetworkObject readDatagramSocketObject(DatagramSocket client) throws IOException, ClassNotFoundException {
        byte[] receiveBuffer = new byte[8192];
        DatagramPacket packet = new DatagramPacket(receiveBuffer, receiveBuffer.length);
        client.receive(packet);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(receiveBuffer);
        ObjectInputStream inputStream = new ObjectInputStream(new BufferedInputStream(byteArrayInputStream));
        return (SerializableNetworkObject)inputStream.readObject();
    }

    public static void writeDatagramSocketObject(DatagramSocket socket, SerializableNetworkObject object, InetAddress inetAdress, int port) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(8192);
        ObjectOutputStream outputStream = new ObjectOutputStream(new BufferedOutputStream(byteStream));
        outputStream.flush();
        outputStream.writeObject(object);
        outputStream.flush();
        byte[] sendBuffer = byteStream.toByteArray();
        DatagramPacket packet = new DatagramPacket(sendBuffer, sendBuffer.length, inetAdress, port);
        socket.send(packet);
    }
}

