/*
 * Decompiled with CFR 0.152.
 */
package network;

import game.ShutdownGameCoordinator;
import game.utils.LogHandler;
import gameServer.Client;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import navigationView.PickupTreasureEvent;
import network.LobbyListener;
import network.Player;
import network.ReadWriteHelper;
import network.SerializableNetworkObject;
import network.UpdateRecord;
import network.VictoryMetaData;
import network.thread.ServerClientRegisterThread;
import network.thread.ServerLobbyListenerThread;

public class ServerConnection {
    private ServerSocket serverSocket;
    private LobbyListener joinListener;
    private ArrayList<Player> playerList = new ArrayList();
    private ServerClientRegisterThread serverClientRegisterThread;
    private ArrayList<ServerLobbyListenerThread> serverLobbyListenerThreadList = new ArrayList();
    private HashMap<Player, ServerLobbyListenerThread> playerThreadMap = new HashMap();
    private boolean lobbyMode = true;
    private boolean lastSharedTimeoutEnabled = false;
    private boolean serverMode;
    private ShutdownGameCoordinator shutdownGameCoordinator;

    public ServerConnection(int port, LobbyListener joinListener, String playerName) throws IOException {
        this.serverSocket = new ServerSocket(port);
        this.joinListener = joinListener;
        Player player = new Player();
        player.setName(playerName);
        this.playerList.add(player);
        player.setPlayerPort(port);
        player.setPlayerNumber(0);
        this.serverMode = false;
        this.serverClientRegisterThread = new ServerClientRegisterThread(this.serverSocket, this, joinListener);
        this.serverClientRegisterThread.start();
    }

    public ServerConnection(ArrayList<Client> gameServerClients, Client host, ShutdownGameCoordinator shutdownGameCoordinator) throws SocketException {
        int playerNumber = 0;
        for (Client client : gameServerClients) {
            Socket socket = client.getSocket();
            Player player = new Player(socket);
            player.setHost(host.equals(client));
            player.setName(client.getPlayerName());
            this.playerList.add(player);
            player.setPlayerPort(socket.getLocalPort());
            if (socket.getInetAddress().getHostAddress().equals("127.0.0.1")) {
                player.setPlayerPort(socket.getLocalPort() + this.playerList.size() - 1);
            }
            player.setPlayerNumber(playerNumber++);
            player.setDatagramClient(new DatagramSocket());
        }
        this.serverMode = true;
        this.shutdownGameCoordinator = shutdownGameCoordinator;
    }

    public void addClient(Socket client) throws SocketException {
        if (this.playerList.size() > 11) {
            try {
                ReadWriteHelper.writeSocketMessage(client, "disconnect;");
            }
            catch (IOException e) {
                LogHandler.notifyException(e);
            }
            return;
        }
        Player player = new Player(client);
        player.setDatagramClient(new DatagramSocket());
        player.setPlayerNumber(this.playerList.size());
        if (client.getInetAddress().getHostAddress().equals("127.0.0.1")) {
            player.setPlayerPort(client.getLocalPort() + this.playerList.size());
        } else {
            for (Player currentPlayer : this.playerList) {
                if (currentPlayer.getClient() == null || !currentPlayer.getClient().getInetAddress().getHostAddress().contentEquals(client.getInetAddress().getHostAddress())) continue;
                try {
                    ReadWriteHelper.writeSocketMessage(client, "disconnect;");
                }
                catch (IOException e) {
                    LogHandler.notifyException(e);
                }
                return;
            }
            player.setPlayerPort(client.getLocalPort());
        }
        this.playerList.add(player);
        ServerLobbyListenerThread serverLobbyListenerThread = new ServerLobbyListenerThread(player, this, this.joinListener);
        serverLobbyListenerThread.start();
        this.serverLobbyListenerThreadList.add(serverLobbyListenerThread);
        this.playerThreadMap.put(player, serverLobbyListenerThread);
        this.checkConnectedPlayers();
    }

    public ArrayList<Player> getPlayerList() {
        return this.playerList;
    }

    public void disconnectPlayer(Player player) {
        if (this.lobbyMode && !this.serverMode) {
            this.playerList.remove(player);
            this.sharePlayers(false);
            this.playerThreadMap.get(player).stopThread();
        }
        player.setDisconnected(true);
        if (!player.getClient().isClosed()) {
            try {
                player.getClient().close();
            }
            catch (IOException e) {
                LogHandler.notifyException(e);
            }
        }
        if (player.getDatagramClient() != null && !player.getDatagramClient().isClosed()) {
            player.getDatagramClient().close();
        }
        if (this.getNumberOfConnectedPlayers() == 0 && this.shutdownGameCoordinator != null) {
            this.shutdownGameCoordinator.stopThreads();
        }
    }

    public void disconnect() {
        for (Player player : this.playerList) {
            Socket client = player.getClient();
            if (client == null || player.isDisconnected()) continue;
            try {
                ReadWriteHelper.writeSocketMessage(client, "disconnect;");
            }
            catch (SocketException e) {
                if (!player.getClient().isConnected()) {
                    player.setDisconnected(true);
                }
            }
            catch (IOException e) {
                LogHandler.notifyException(e);
            }
            this.disconnectPlayer(player);
        }
        if (this.serverClientRegisterThread != null) {
            this.serverClientRegisterThread.stopThread();
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            LogHandler.notifyException(e);
        }
    }

    public int getNumberOfConnectedPlayers() {
        int counter = 0;
        for (Player player : this.playerList) {
            if (player.isDisconnected()) continue;
            ++counter;
        }
        return counter;
    }

    public void startGame(boolean preferNetworkSplitscreen) {
        this.checkConnectedPlayers();
        for (Player player : this.playerList) {
            Socket client = player.getClient();
            if (client == null) continue;
            String addition = "";
            if (preferNetworkSplitscreen) {
                addition = "preferSplitscreen";
            }
            try {
                ReadWriteHelper.writeSocketMessage(client, "startGame;" + addition);
            }
            catch (IOException e) {
                LogHandler.notifyException(e);
                this.handleClientNotRespondingInLobby(player);
            }
        }
        this.lobbyMode = false;
        this.serverClientRegisterThread.stopThread();
    }

    private void handleClientNotRespondingInLobby(Player player) {
        if (this.joinListener != null) {
            this.joinListener.showMessageDialog(player.getName() + " disconnected.");
        }
        this.disconnectPlayer(player);
    }

    public void sharePlayers(boolean checkDisconnect) {
        if (checkDisconnect) {
            this.checkConnectedPlayers();
        }
        if (this.joinListener != null) {
            this.joinListener.playerNameUpdate(this.getPlayerNamesFromPlayerList());
        }
        String playerNamesAsString = this.getPlayerNamesAsString();
        int i = -1;
        for (Player player : this.playerList) {
            Socket client = player.getClient();
            ++i;
            if (client == null) continue;
            try {
                ReadWriteHelper.writeSocketMessage(client, "playerUpdate;" + playerNamesAsString + ";" + i);
            }
            catch (IOException e) {
                LogHandler.notifyException(e);
                this.handleClientNotRespondingInLobby(player);
            }
        }
    }

    private String getPlayerNamesAsString() {
        return String.join((CharSequence)";", this.getPlayerNamesFromPlayerList());
    }

    private String[] getPlayerNamesFromPlayerList() {
        String[] playerNameArray = new String[this.playerList.size()];
        int i = 0;
        for (Player player : this.playerList) {
            if (player.isDisconnected()) continue;
            playerNameArray[i++] = player.getName();
        }
        return playerNameArray;
    }

    public void shareName(Socket client, String name) {
        for (Player player : this.playerList) {
            if (player.getClient() != client) continue;
            player.setName(name);
        }
        this.sharePlayers(true);
    }

    public void updateClientsWithLabyrinths(ArrayList<UpdateRecord> updateRecordList) {
        if (updateRecordList.isEmpty()) {
            return;
        }
        for (Player player : this.playerList) {
            Socket client = player.getClient();
            DatagramSocket datagramClient = player.getDatagramClient();
            if (client == null || player == this.playerList.get(0) && !this.serverMode || player.isDisconnected()) continue;
            if (player.hasSetUdpWorking() && !player.isUdpWorking() || datagramClient == null || datagramClient.isClosed()) {
                try {
                    ReadWriteHelper.writeSocketObject(client, new SerializableNetworkObject(updateRecordList));
                }
                catch (IOException e) {
                    player.setDisconnected(true);
                }
                continue;
            }
            try {
                if (!player.hasSetUdpWorking()) {
                    player.setUdpWorking(false);
                }
                ReadWriteHelper.writeDatagramSocketObject(datagramClient, new SerializableNetworkObject(updateRecordList), client.getInetAddress(), player.getPlayerPort());
            }
            catch (IOException e) {
                datagramClient.close();
            }
        }
    }

    public void showVictory(HashMap<Integer, VictoryMetaData> victoryMetaDataMap) {
        ArrayList<VictoryMetaData> victoryMetaDataList = new ArrayList<VictoryMetaData>();
        for (int i = 0; i < this.playerList.size(); ++i) {
            victoryMetaDataList.add(victoryMetaDataMap.getOrDefault(i, null));
        }
        for (Player player : this.playerList) {
            Socket client = player.getClient();
            if (client == null || player == this.playerList.get(0) && !this.serverMode || player.isDisconnected()) continue;
            try {
                ReadWriteHelper.writeSocketObject(client, SerializableNetworkObject.fromVictoryMetaDataList(victoryMetaDataList));
            }
            catch (IOException e) {
                player.setDisconnected(true);
            }
        }
    }

    private void checkConnectedPlayers() {
        for (Player player : this.playerList) {
            Socket client = player.getClient();
            if (client == null || !client.isClosed()) continue;
            this.disconnectPlayer(player);
        }
    }

    public void waitForAllLobbies() {
        boolean isOneRunning = true;
        while (isOneRunning) {
            isOneRunning = false;
            for (ServerLobbyListenerThread serverLobbyListenerThread : this.serverLobbyListenerThreadList) {
                if (!serverLobbyListenerThread.isRunning()) continue;
                isOneRunning = true;
                break;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                LogHandler.notifyException(e);
            }
        }
    }

    public void updateClientsWithGameStart() {
        for (Player player : this.playerList) {
            Socket client = player.getClient();
            if (client == null || player == this.playerList.get(0) && !this.serverMode || player.isDisconnected()) continue;
            try {
                ReadWriteHelper.writeSocketObject(client, new SerializableNetworkObject("startRound;"));
            }
            catch (IOException e) {
                player.setDisconnected(true);
            }
        }
    }

    public void markUdpAsWorking(int playerNumber) {
        for (Player player : this.playerList) {
            if (player.getPlayerNumber() != playerNumber) continue;
            player.setUdpWorking(true);
        }
    }

    public void distributeTreasurePickup(PickupTreasureEvent pickupTreasureEvent) {
        for (Player player : this.playerList) {
            Socket client = player.getClient();
            if (client == null || player == this.playerList.get(0) && !this.serverMode || player.isDisconnected()) continue;
            try {
                ReadWriteHelper.writeSocketObject(client, new SerializableNetworkObject(pickupTreasureEvent));
            }
            catch (IOException e) {
                player.setDisconnected(true);
            }
        }
    }
}

