/*
 * Decompiled with CFR 0.152.
 */
package network.thread;

import game.utils.LogHandler;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import network.ClientConnection;
import network.LobbyListener;
import network.ReadWriteHelper;

public class ClientLobbyListenerThread
extends Thread {
    private ClientConnection clientLobbyConnection;
    private boolean running = true;
    private LobbyListener lobbyListener;

    public ClientLobbyListenerThread(ClientConnection clientLobbyConnection, LobbyListener lobbyListener) {
        this.clientLobbyConnection = clientLobbyConnection;
        this.lobbyListener = lobbyListener;
    }

    public void stopThread() {
        this.running = false;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                String action;
                String[] split;
                Socket client = this.clientLobbyConnection.getPlayer().getClient();
                String message = ReadWriteHelper.readSocketMessage(client);
                if (message == null || (split = message.split(";")).length <= 0) continue;
                switch (action = split[0]) {
                    case "disconnect": {
                        this.clientLobbyConnection.disconnectPlayer(true);
                        break;
                    }
                    case "playerUpdate": {
                        String[] namesArray = Arrays.copyOfRange(split, 1, split.length - 1);
                        this.clientLobbyConnection.updatePlayers(namesArray, Integer.parseInt(split[split.length - 1]));
                        break;
                    }
                    case "startGame": {
                        boolean preferSplitScreen = split.length > 1 && split[1].equals("preferSplitscreen");
                        this.stopThread();
                        this.clientLobbyConnection.startGame(preferSplitScreen);
                        break;
                    }
                }
            }
            catch (SocketException e) {
                this.stopThread();
                this.lobbyListener.showMessageDialog("Connection error. Please connect again");
                return;
            }
            catch (Exception e) {
                LogHandler.notifyException(e);
                this.stopThread();
                this.lobbyListener.showMessageDialog("An unknown network error occurred.");
                this.lobbyListener.disconnect();
            }
        }
    }
}

