/*
 * Decompiled with CFR 0.152.
 */
package network.thread;

import game.utils.LogHandler;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import network.LobbyListener;
import network.ServerConnection;

public class ServerClientRegisterThread
extends Thread {
    private ServerSocket serverSocket;
    private ServerConnection serverLobbyConnection;
    private boolean running = true;
    private LobbyListener lobbyListener;

    public ServerClientRegisterThread(ServerSocket serverSocket, ServerConnection serverLobbyConnection, LobbyListener lobbyListener) {
        this.serverSocket = serverSocket;
        this.serverLobbyConnection = serverLobbyConnection;
        this.lobbyListener = lobbyListener;
    }

    public void stopThread() {
        this.running = false;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Socket client = this.serverSocket.accept();
                this.serverLobbyConnection.addClient(client);
            }
            catch (SocketException client) {
            }
            catch (IOException e) {
                LogHandler.notifyException(e);
            }
            catch (Exception e) {
                LogHandler.notifyException(e);
                this.stopThread();
                this.lobbyListener.showMessageDialog("An unknown error occurred.");
                this.lobbyListener.disconnect();
            }
        }
    }
}

