/*
 * Decompiled with CFR 0.152.
 */
package network.thread;

import game.utils.LogHandler;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import network.LobbyListener;
import network.Player;
import network.ReadWriteHelper;
import network.ServerConnection;

public class ServerLobbyListenerThread
extends Thread {
    private Player player;
    private ServerConnection serverLobbyConnection;
    private boolean running = true;
    private LobbyListener lobbyListener;

    public ServerLobbyListenerThread(Player player, ServerConnection serverLobbyConnection, LobbyListener lobbyListener) {
        this.player = player;
        this.serverLobbyConnection = serverLobbyConnection;
        this.lobbyListener = lobbyListener;
    }

    public void stopThread() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                String action;
                String[] split;
                String message;
                Socket client = this.player.getClient();
                try {
                    message = ReadWriteHelper.readSocketMessage(client);
                }
                catch (ClassCastException e) {
                    continue;
                }
                if (message == null || (split = message.split(";")).length <= 0) continue;
                switch (action = split[0]) {
                    case "disconnect": {
                        this.serverLobbyConnection.disconnectPlayer(this.player);
                        break;
                    }
                    case "shareName": {
                        this.serverLobbyConnection.shareName(client, split[1]);
                        break;
                    }
                    case "startGame": {
                        this.stopThread();
                        break;
                    }
                }
            }
            catch (SocketException e) {
                if (this.player.getClient().isConnected()) continue;
                this.player.setDisconnected(true);
                this.stopThread();
            }
            catch (IOException e) {
                LogHandler.notifyException(e);
                if (this.player.getClient().isConnected()) continue;
                this.player.setDisconnected(true);
                this.stopThread();
            }
            catch (Exception e) {
                LogHandler.notifyException(e);
                this.stopThread();
                this.lobbyListener.showMessageDialog("An unknown error occurred.");
                this.lobbyListener.disconnect();
            }
        }
    }
}

