/*
 * Decompiled with CFR 0.152.
 */
package rendering;

import game.utils.LabUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JLabel;
import labyrinthField.Point;
import labyrinthField.Treasure;
import labyrinthField.TreasureType;
import labyrinthField.Way;
import navigationView.PlayerEffect;
import network.LabyrinthFieldMetaData;
import rendering.ImageRenderer;

public class ColoredLabyrinthComponent
extends JComponent {
    private LabyrinthFieldMetaData labyrinthFieldMetaData;
    private int sharedWindowWidth = 0;
    private int sharedWindowHeight = 0;
    private final int osScaleFactor;
    private HashMap<Integer, Point> playerPositionMap;
    private int currentPlayerNumber;
    private long timeout;
    private ArrayList<Treasure> treasureList;
    private ArrayList<Way> wayToGoal;
    private ArrayList<PlayerEffect> activePlayerEffectList;
    private HashMap<Object, BufferedImage> bufferedImageMap = new HashMap();
    private BufferedImage treasureImage;
    private BufferedImage bufferedImage;
    private boolean useScaleFactor = false;

    public ColoredLabyrinthComponent() {
        this.osScaleFactor = ImageRenderer.getOsScaleFactor();
    }

    public void setRenderData(LabyrinthFieldMetaData labyrinthFieldMetaData, int sharedWindowWidth, int sharedWindowHeight, HashMap<Integer, Point> playerPositionMap, int currentPlayerNumber, long timeout, ArrayList<Treasure> treasureList, ArrayList<Way> wayToGoal, ArrayList<PlayerEffect> activePlayerEffectList) {
        this.labyrinthFieldMetaData = labyrinthFieldMetaData;
        this.sharedWindowWidth = sharedWindowWidth;
        this.sharedWindowHeight = sharedWindowHeight;
        this.playerPositionMap = playerPositionMap;
        this.currentPlayerNumber = currentPlayerNumber;
        this.timeout = timeout;
        this.treasureList = treasureList;
        this.wayToGoal = wayToGoal;
        this.activePlayerEffectList = activePlayerEffectList;
        this.useScaleFactor = true;
        if (this.bufferedImage == null || this.bufferedImage.getWidth() != sharedWindowWidth || this.bufferedImage.getHeight() != sharedWindowHeight) {
            this.bufferedImage = new BufferedImage(sharedWindowWidth, sharedWindowHeight, 2);
        }
    }

    public void setRenderData(LabyrinthFieldMetaData labyrinthFieldMetaData, HashMap<Integer, Point> playerPositionMap, int currentPlayerNumber, long timeout, ArrayList<Treasure> treasureList, ArrayList<Way> wayToGoal, ArrayList<PlayerEffect> activePlayerEffectList) {
        this.labyrinthFieldMetaData = labyrinthFieldMetaData;
        this.playerPositionMap = playerPositionMap;
        this.currentPlayerNumber = currentPlayerNumber;
        this.timeout = timeout;
        this.treasureList = treasureList;
        this.wayToGoal = wayToGoal;
        this.activePlayerEffectList = activePlayerEffectList;
        this.useScaleFactor = false;
        this.ensureSizeIsSet();
    }

    @Override
    protected void paintComponent(Graphics g) {
        boolean scale;
        String activeTreasureText;
        super.paintComponent(g);
        this.ensureSizeIsSet();
        Graphics2D graphics2D = this.bufferedImage.createGraphics();
        graphics2D.setColor(Color.BLACK);
        graphics2D.fillRect(0, 0, this.sharedWindowWidth, this.sharedWindowHeight);
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHints(rh);
        BufferedImage labyrinthImage = this.getLabyrinthImage(this.labyrinthFieldMetaData);
        int widthHalf = this.sharedWindowWidth / 2;
        int heightHalf = this.sharedWindowHeight / 2;
        int currentX = this.playerPositionMap.get(this.currentPlayerNumber).getxPosition();
        int currentY = this.playerPositionMap.get(this.currentPlayerNumber).getyPosition();
        int leftStart = currentX - widthHalf;
        int topStart = currentY - heightHalf;
        int labyrinthPartWidthStart = 0;
        int labyrinthPartHeightStart = 0;
        if (leftStart > 0 || topStart > 0) {
            labyrinthPartWidthStart = Math.max(0, leftStart);
            labyrinthPartHeightStart = Math.max(0, topStart);
            labyrinthImage = labyrinthImage.getSubimage(labyrinthPartWidthStart, labyrinthPartHeightStart, Math.min(this.sharedWindowWidth, labyrinthImage.getWidth() - labyrinthPartWidthStart), Math.min(this.sharedWindowHeight, labyrinthImage.getHeight() - labyrinthPartHeightStart));
        }
        int startX = labyrinthPartWidthStart > 0 ? 0 : -leftStart;
        int startY = labyrinthPartHeightStart > 0 ? 0 : -topStart;
        graphics2D.drawImage((Image)labyrinthImage, startX, startY, null);
        int scaleFactor = this.labyrinthFieldMetaData.getScaleFactor();
        int sizeOfOuterCircle = 8 * scaleFactor;
        int sizeOfInnerCircle = 3 * scaleFactor;
        int scaleFactorPlusOne = scaleFactor + 1;
        if (this.wayToGoal != null) {
            graphics2D.setColor(Color.red);
            int diffX = widthHalf - currentX - scaleFactorPlusOne;
            int diffY = heightHalf - currentY - scaleFactorPlusOne;
            for (Way way : this.wayToGoal) {
                int counter = 0;
                for (Point point : way.getPointCollection()) {
                    if (counter % 2 == 0) {
                        int pointX = point.getxPosition() + diffX;
                        int pointY = point.getyPosition() + diffY;
                        graphics2D.fillOval(pointX, pointY, scaleFactorPlusOne * 2 + 1, scaleFactorPlusOne * 2 + 1);
                    }
                    ++counter;
                }
            }
        }
        if (this.treasureList.size() > 0) {
            this.loadTreasureImage(sizeOfOuterCircle * 2);
            for (Treasure treasure : (ArrayList)this.treasureList.clone()) {
                Point point = treasure.getPoint();
                int pointX = widthHalf + point.getxPosition() - currentX - sizeOfOuterCircle;
                int pointY = heightHalf + point.getyPosition() - currentY - sizeOfOuterCircle;
                this.addPartialImage(graphics2D, this.treasureImage, pointX, pointY, sizeOfOuterCircle * 2, sizeOfOuterCircle * 2);
            }
        }
        for (Map.Entry<Integer, Point> integerPointEntry : this.getEntriesWithCurrentPlayerLast(this.playerPositionMap, this.currentPlayerNumber)) {
            int currentSize;
            Color circleColor;
            int playerNumber = integerPointEntry.getKey();
            Point point = integerPointEntry.getValue();
            int pointX = widthHalf + point.getxPosition() - currentX - sizeOfOuterCircle;
            int pointY = heightHalf + point.getyPosition() - currentY - sizeOfOuterCircle;
            int fullCircleRadius = sizeOfOuterCircle * 2 + 1;
            graphics2D.setColor(ImageRenderer.getColorByPlayerNumber(playerNumber));
            graphics2D.fillOval(pointX, pointY, fullCircleRadius, fullCircleRadius);
            if (pointX < 0) {
                graphics2D.setColor(ImageRenderer.getColorByPlayerNumber(playerNumber));
                graphics2D.fillOval(-sizeOfOuterCircle, LabUtils.limitInt(pointY, 0, this.sharedWindowHeight - 1), fullCircleRadius, fullCircleRadius);
            } else if (pointX > this.sharedWindowWidth - 1) {
                graphics2D.setColor(ImageRenderer.getColorByPlayerNumber(playerNumber));
                graphics2D.fillOval(this.sharedWindowWidth - 1 - sizeOfOuterCircle, LabUtils.limitInt(pointY, 0, this.sharedWindowHeight - 1), fullCircleRadius, fullCircleRadius);
            } else if (pointY < 0) {
                graphics2D.setColor(ImageRenderer.getColorByPlayerNumber(playerNumber));
                graphics2D.fillOval(LabUtils.limitInt(pointX, 0, this.sharedWindowWidth - 1), -sizeOfOuterCircle, fullCircleRadius, fullCircleRadius);
            } else if (pointY > this.sharedWindowHeight - 1) {
                graphics2D.setColor(ImageRenderer.getColorByPlayerNumber(playerNumber));
                graphics2D.fillOval(LabUtils.limitInt(pointX, 0, this.sharedWindowWidth - 1), this.sharedWindowHeight - 1 - sizeOfOuterCircle, fullCircleRadius, fullCircleRadius);
            }
            int speedChange = this.getSpeedChange(this.activePlayerEffectList, playerNumber);
            int circleGrowSize = Math.min(Math.abs(speedChange), 3) * scaleFactor;
            Color color = circleColor = speedChange > 0 ? Color.green : Color.red;
            if (circleGrowSize != 0) {
                currentSize = sizeOfInnerCircle + circleGrowSize;
                pointX = widthHalf + point.getxPosition() - currentX - currentSize;
                pointY = heightHalf + point.getyPosition() - currentY - currentSize;
                graphics2D.setColor(circleColor);
                graphics2D.fillOval(pointX, pointY, currentSize * 2 + 1, currentSize * 2 + 1);
            }
            currentSize = sizeOfInnerCircle - circleGrowSize;
            Color innerPointColor = this.isInvertedControl(this.activePlayerEffectList, playerNumber) ? Color.yellow : Color.black;
            pointX = widthHalf + point.getxPosition() - currentX - currentSize;
            pointY = heightHalf + point.getyPosition() - currentY - currentSize;
            graphics2D.setColor(innerPointColor);
            graphics2D.fillOval(pointX, pointY, currentSize * 2 + 1, currentSize * 2 + 1);
        }
        int goalX = this.labyrinthFieldMetaData.getGoalX();
        int goalY = this.labyrinthFieldMetaData.getGoalY();
        if (Math.abs(goalX - currentX) < widthHalf + sizeOfOuterCircle && Math.abs(goalY - currentY) < heightHalf + sizeOfOuterCircle) {
            int pointX = widthHalf + goalX - currentX - sizeOfOuterCircle;
            int pointY = heightHalf + goalY - currentY - sizeOfOuterCircle;
            graphics2D.setColor(ImageRenderer.getColorByPlayerNumber(this.currentPlayerNumber));
            graphics2D.fillOval(pointX, pointY, sizeOfOuterCircle * 2 + 1, sizeOfOuterCircle * 2 + 1);
            pointX = widthHalf + goalX - currentX - sizeOfInnerCircle;
            pointY = heightHalf + goalY - currentY - sizeOfInnerCircle;
            graphics2D.setColor(Color.black);
            graphics2D.fillOval(pointX, pointY, sizeOfInnerCircle * 2 + 1, sizeOfInnerCircle * 2 + 1);
        }
        if (this.labyrinthFieldMetaData.getPlayerNameList() != null) {
            int counter = 0;
            for (String playerName : this.labyrinthFieldMetaData.getPlayerNameList()) {
                int textNameWidth;
                BufferedImage bufferedImage;
                int textNameHeight = 24;
                if (this.bufferedImageMap.containsKey(playerName + counter)) {
                    bufferedImage = this.bufferedImageMap.get(playerName + counter);
                    textNameWidth = bufferedImage.getWidth();
                } else {
                    JLabel playerNameLabel = new JLabel(playerName);
                    playerNameLabel.setFont(new Font("Serif", 0, textNameHeight));
                    playerNameLabel.setForeground(ImageRenderer.getColorByPlayerNumber(counter));
                    textNameWidth = (int)playerNameLabel.getPreferredSize().getWidth();
                    playerNameLabel.setBounds(0, 0, textNameWidth, textNameHeight);
                    bufferedImage = new BufferedImage(textNameWidth, textNameHeight, 2);
                    Graphics2D g2D = (Graphics2D)bufferedImage.getGraphics();
                    g2D.setColor(Color.BLACK);
                    g2D.fillRect(0, 0, textNameWidth, textNameHeight);
                    playerNameLabel.paint(g2D);
                    this.bufferedImageMap.put(playerName + counter, bufferedImage);
                }
                this.addPartialImage(graphics2D, bufferedImage, 0, (textNameHeight + 8) * counter, textNameWidth, textNameHeight);
                ++counter;
            }
        }
        if (this.timeout != 0L) {
            int textNameWidth;
            BufferedImage bufferedImage;
            int secondsLeft = (int)((this.timeout - new Date().getTime()) / 1000L);
            int textNameHeight = 24;
            String text = "Time left: " + secondsLeft;
            if (this.bufferedImageMap.containsKey(text)) {
                bufferedImage = this.bufferedImageMap.get(text);
                textNameWidth = bufferedImage.getWidth();
            } else {
                JLabel playerNameLabel = new JLabel(text);
                playerNameLabel.setFont(new Font("Serif", 0, textNameHeight));
                playerNameLabel.setForeground(Color.LIGHT_GRAY);
                textNameWidth = (int)playerNameLabel.getPreferredSize().getWidth();
                playerNameLabel.setBounds(0, 0, textNameWidth, textNameHeight);
                bufferedImage = new BufferedImage(textNameWidth, textNameHeight, 2);
                Graphics2D g2D = (Graphics2D)bufferedImage.getGraphics();
                g2D.setColor(Color.BLACK);
                g2D.fillRect(0, 0, textNameWidth, textNameHeight);
                playerNameLabel.paint(g2D);
                this.bufferedImageMap.put(text, bufferedImage);
            }
            this.addPartialImage(graphics2D, bufferedImage, this.sharedWindowWidth - textNameWidth - 1, 0, textNameWidth, textNameHeight);
        }
        if ((activeTreasureText = this.getActiveTreasureText(this.activePlayerEffectList, this.currentPlayerNumber)) != null) {
            int textNameWidth;
            BufferedImage bufferedImage;
            int textNameHeight = 32;
            if (this.bufferedImageMap.containsKey(activeTreasureText)) {
                bufferedImage = this.bufferedImageMap.get(activeTreasureText);
                textNameWidth = bufferedImage.getWidth();
            } else {
                JLabel playerNameLabel = new JLabel(activeTreasureText);
                playerNameLabel.setFont(new Font("Serif", 0, textNameHeight));
                playerNameLabel.setForeground(Color.orange);
                textNameWidth = (int)playerNameLabel.getPreferredSize().getWidth();
                playerNameLabel.setBounds(0, 0, textNameWidth, textNameHeight);
                bufferedImage = new BufferedImage(textNameWidth, textNameHeight, 2);
                Graphics2D g2D = (Graphics2D)bufferedImage.getGraphics();
                g2D.setColor(Color.BLACK);
                g2D.fillRect(0, 0, textNameWidth, textNameHeight);
                playerNameLabel.paint(g2D);
                this.bufferedImageMap.put(activeTreasureText, bufferedImage);
            }
            if (textNameWidth < this.sharedWindowWidth) {
                this.addPartialImage(graphics2D, bufferedImage, (this.sharedWindowWidth - textNameWidth) / 2, 0, textNameWidth, textNameHeight);
            }
        }
        Graphics2D graphicsDisplayLayer = (Graphics2D)g;
        int realWindowWidth = this.getWidth();
        int realWindowHeight = this.getHeight();
        if (this.useScaleFactor) {
            realWindowWidth *= this.osScaleFactor;
            realWindowHeight *= this.osScaleFactor;
        }
        boolean bl = scale = this.sharedWindowWidth != realWindowWidth || this.sharedWindowHeight != realWindowHeight;
        if (scale) {
            AffineTransform at = new AffineTransform();
            at.scale((double)realWindowWidth / (double)this.sharedWindowWidth, (double)realWindowHeight / (double)this.sharedWindowHeight);
            graphicsDisplayLayer.setTransform(at);
        }
        graphicsDisplayLayer.drawImage((Image)this.bufferedImage, 0, 0, null);
    }

    private void addPartialImage(Graphics2D graphics2D, BufferedImage outerPoint, int pointX, int pointY, int width, int height) {
        if (pointX < 0 || pointY < 0) {
            int widthStart = Math.max(0, -pointX);
            int heightStart = Math.max(0, -pointY);
            if (width - widthStart <= 0 || height - heightStart <= 0) {
                return;
            }
            outerPoint.getSubimage(widthStart, heightStart, width - widthStart, height - heightStart);
        }
        graphics2D.drawImage((Image)outerPoint, pointX, pointY, null);
    }

    private BufferedImage getLabyrinthImage(LabyrinthFieldMetaData labyrinthFieldMetaData) {
        if (this.bufferedImageMap.containsKey(labyrinthFieldMetaData.getLabyrinthField())) {
            return this.bufferedImageMap.get(labyrinthFieldMetaData.getLabyrinthField());
        }
        boolean[][] wayPointMatrix = labyrinthFieldMetaData.getWayPointMatrixNonFlat();
        int width = wayPointMatrix.length;
        int height = wayPointMatrix[0].length;
        BufferedImage labyrinthImage = new BufferedImage(labyrinthFieldMetaData.getWidth(), labyrinthFieldMetaData.getHeight(), 2);
        Graphics2D graphics2D = (Graphics2D)labyrinthImage.getGraphics();
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHints(rh);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setColor(Color.white);
        int scaleFactor = labyrinthFieldMetaData.getScaleFactor();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (!wayPointMatrix[x][y]) continue;
                graphics2D.fillOval(x - scaleFactor, y - scaleFactor, scaleFactor * 2 + 1, scaleFactor * 2 + 1);
            }
        }
        this.bufferedImageMap.put(labyrinthFieldMetaData.getLabyrinthField(), labyrinthImage);
        return labyrinthImage;
    }

    private int getSpeedChange(ArrayList<PlayerEffect> activePlayerEffectList, int currentPlayerNumber) {
        int speedChange = 0;
        for (PlayerEffect playerEffect : activePlayerEffectList) {
            if (playerEffect.getEffectedPlayerNumber() == currentPlayerNumber) {
                if (playerEffect.getTreasureType() == TreasureType.SPEED_SELF) {
                    ++speedChange;
                }
                if (playerEffect.getTreasureType() != TreasureType.SLOW_SELF && playerEffect.getTreasureType() != TreasureType.SLOW_FIRST) continue;
                --speedChange;
                continue;
            }
            if (playerEffect.getTreasureType() != TreasureType.SLOW_OTHERS) continue;
            --speedChange;
        }
        return speedChange;
    }

    private void ensureSizeIsSet() {
        if (this.sharedWindowWidth == 0) {
            this.sharedWindowWidth = this.getWidth();
        }
        if (this.sharedWindowHeight == 0) {
            this.sharedWindowHeight = this.getHeight();
        }
        if (this.sharedWindowHeight == 0 || this.sharedWindowWidth == 0) {
            return;
        }
        if (this.bufferedImage == null || this.bufferedImage.getWidth() != this.sharedWindowWidth || this.bufferedImage.getHeight() != this.sharedWindowHeight) {
            this.bufferedImage = new BufferedImage(this.sharedWindowWidth, this.sharedWindowHeight, 2);
        }
    }

    private String getActiveTreasureText(ArrayList<PlayerEffect> activePlayerEffectList, int currentPlayerNumber) {
        String latestActiveTreasureText = null;
        long latestTimestamp = 0L;
        long currentTime = new Date().getTime();
        for (PlayerEffect playerEffect : activePlayerEffectList) {
            if (playerEffect.getPickUpPlayerNumber() != currentPlayerNumber || playerEffect.getShowUntilTime() <= currentTime || playerEffect.getShowUntilTime() <= latestTimestamp) continue;
            latestTimestamp = playerEffect.getShowUntilTime();
            switch (playerEffect.getTreasureType()) {
                case SLOW_SELF: {
                    latestActiveTreasureText = "Slow yourself for 30 seconds";
                    break;
                }
                case SLOW_OTHERS: {
                    latestActiveTreasureText = "Slow others for 15 seconds";
                    break;
                }
                case SLOW_FIRST: {
                    latestActiveTreasureText = "Slow player that's nearest to goal for 30 seconds";
                    break;
                }
                case SHOW_WAY_TO_GOAL: {
                    latestActiveTreasureText = "See way to goal for 5 seconds";
                    break;
                }
                case CHANGE: {
                    latestActiveTreasureText = "Switch position with other player";
                    break;
                }
                case INVERT: {
                    latestActiveTreasureText = "Inverted directions for 10 seconds";
                    break;
                }
                case SPEED_SELF: {
                    latestActiveTreasureText = "Speed up yourself for 30 seconds";
                }
            }
        }
        return latestActiveTreasureText;
    }

    private boolean isInvertedControl(ArrayList<PlayerEffect> activePlayerEffectList, int currentPlayerNumber) {
        for (PlayerEffect playerEffect : activePlayerEffectList) {
            if (playerEffect.getEffectedPlayerNumber() != currentPlayerNumber || playerEffect.getTreasureType() != TreasureType.INVERT) continue;
            return true;
        }
        return false;
    }

    private void loadTreasureImage(int sizeOfOuterCircle) {
        if (this.treasureImage == null) {
            URL treasureUrl = ImageRenderer.class.getResource("/resources/treasure.png");
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ImageIO.read(treasureUrl);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (bufferedImage != null) {
                AffineTransform at = new AffineTransform();
                at.scale((double)sizeOfOuterCircle / (double)bufferedImage.getWidth(), (double)sizeOfOuterCircle / (double)bufferedImage.getHeight());
                AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
                this.treasureImage = scaleOp.filter(bufferedImage, this.treasureImage);
            }
        }
    }

    private ArrayList<Map.Entry<Integer, Point>> getEntriesWithCurrentPlayerLast(HashMap<Integer, Point> playerPositionMap, int currentPlayerNumber) {
        ArrayList<Map.Entry<Integer, Point>> mapList = new ArrayList<Map.Entry<Integer, Point>>();
        Map.Entry<Integer, Point> lastAdded = null;
        for (Map.Entry<Integer, Point> integerPointEntry : playerPositionMap.entrySet()) {
            int playerNumber = integerPointEntry.getKey();
            if (currentPlayerNumber != playerNumber) {
                mapList.add(integerPointEntry);
                continue;
            }
            lastAdded = integerPointEntry;
        }
        if (lastAdded != null) {
            mapList.add(lastAdded);
        }
        return mapList;
    }
}

