/*
 * Decompiled with CFR 0.152.
 */
package rendering;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import navigationView.ViewModel;
import network.LabyrinthFieldMetaData;
import network.VictoryMetaData;

public class ImageRenderer {
    private static final int blackRgb = Color.black.getRGB();
    private static final int whiteRgb = Color.white.getRGB();
    private static HashMap<Integer, BufferedImage> tempBufferedImageMap = new HashMap();

    public static int[] matrixToImage(boolean[][] matrix) {
        int breite = matrix.length;
        int hoehe = matrix[0].length;
        int[] pixelFeld = new int[breite * hoehe];
        for (int x = 0; x < breite; ++x) {
            for (int y = 0; y < hoehe; ++y) {
                pixelFeld[y * breite + x] = matrix[x][y] ? whiteRgb : blackRgb;
            }
        }
        return pixelFeld;
    }

    public static boolean[][] getRawImage(LabyrinthFieldMetaData labyrinthFieldMetaData, int width, int height, int posX, int posY, int labyrinthNumber, long timeout) {
        int y;
        int x;
        Graphics2D g2D;
        BufferedImage bufferedImage;
        int textNameWidth;
        int textNameHeight;
        int newY;
        int newX;
        int yAround;
        int xAround;
        int widthHalf = width / 2;
        int heightHalf = height / 2;
        boolean[][] currentDisplay = new boolean[width][height];
        boolean[][] wayPointMatrix = labyrinthFieldMetaData.getWayPointMatrix();
        for (int x2 = posX - widthHalf; x2 < posX + widthHalf; ++x2) {
            if (x2 < 0 || x2 > labyrinthFieldMetaData.getWidth() - 1) continue;
            for (int y2 = posY - heightHalf; y2 < posY + heightHalf; ++y2) {
                if (y2 < 0 || y2 > labyrinthFieldMetaData.getHeight() - 1) continue;
                currentDisplay[x2 - posX + widthHalf][y2 - posY + heightHalf] = wayPointMatrix[x2][y2];
            }
        }
        int scaleFactor = labyrinthFieldMetaData.getScaleFactor();
        int sizeOfOuterCircle = 8 * scaleFactor;
        int sizeOfInnerCircle = 3 * scaleFactor;
        for (xAround = -sizeOfOuterCircle; xAround <= sizeOfOuterCircle; ++xAround) {
            for (yAround = -sizeOfOuterCircle; yAround <= sizeOfOuterCircle; ++yAround) {
                if (xAround * xAround + yAround * yAround > sizeOfOuterCircle * sizeOfOuterCircle) continue;
                newX = widthHalf + xAround;
                newY = heightHalf + yAround;
                currentDisplay[newX][newY] = true;
            }
        }
        for (xAround = -sizeOfInnerCircle; xAround <= sizeOfInnerCircle; ++xAround) {
            for (yAround = -sizeOfInnerCircle; yAround <= sizeOfInnerCircle; ++yAround) {
                if (xAround * xAround + yAround * yAround > sizeOfInnerCircle * sizeOfInnerCircle) continue;
                newX = widthHalf + xAround;
                newY = heightHalf + yAround;
                currentDisplay[newX][newY] = false;
            }
        }
        int goalX = labyrinthFieldMetaData.getGoalX();
        int goalY = labyrinthFieldMetaData.getGoalY();
        if (Math.abs(goalX - posX) < widthHalf + sizeOfOuterCircle && Math.abs(goalY - posY) < heightHalf + sizeOfOuterCircle) {
            int newY2;
            int newX2;
            int yAround2;
            int xAround2;
            for (xAround2 = -sizeOfOuterCircle; xAround2 <= sizeOfOuterCircle; ++xAround2) {
                for (yAround2 = -sizeOfOuterCircle; yAround2 <= sizeOfOuterCircle; ++yAround2) {
                    if (xAround2 * xAround2 + yAround2 * yAround2 > sizeOfOuterCircle * sizeOfOuterCircle) continue;
                    newX2 = goalX - posX + widthHalf + xAround2;
                    newY2 = goalY - posY + heightHalf + yAround2;
                    if (newX2 < 0 || newX2 > width - 1 || newY2 < 0 || newY2 > height - 1) continue;
                    currentDisplay[newX2][newY2] = true;
                }
            }
            for (xAround2 = -sizeOfInnerCircle; xAround2 <= sizeOfInnerCircle; ++xAround2) {
                for (yAround2 = -sizeOfInnerCircle; yAround2 <= sizeOfInnerCircle; ++yAround2) {
                    if (xAround2 * xAround2 + yAround2 * yAround2 > sizeOfInnerCircle * sizeOfInnerCircle) continue;
                    newX2 = goalX - posX + widthHalf + xAround2;
                    newY2 = goalY - posY + heightHalf + yAround2;
                    if (newX2 < 0 || newX2 > width - 1 || newY2 < 0 || newY2 > height - 1) continue;
                    currentDisplay[newX2][newY2] = false;
                }
            }
        }
        if (labyrinthFieldMetaData.getPlayerNameList() != null) {
            String playerName = labyrinthFieldMetaData.getPlayerNameList().get(labyrinthNumber);
            textNameHeight = 12 * scaleFactor;
            JLabel playerNameLabel = new JLabel(playerName);
            playerNameLabel.setFont(new Font("Serif", 0, textNameHeight));
            textNameWidth = (int)playerNameLabel.getPreferredSize().getWidth();
            playerNameLabel.setBounds(0, 0, textNameWidth, textNameHeight);
            bufferedImage = ImageRenderer.getCachedBufferedImageBySize(textNameWidth, textNameHeight);
            g2D = (Graphics2D)bufferedImage.getGraphics();
            g2D.setColor(Color.GRAY);
            g2D.fillRect(0, 0, textNameWidth, textNameHeight);
            playerNameLabel.paint(g2D);
            for (x = 0; x < textNameWidth; ++x) {
                for (y = 0; y < textNameHeight; ++y) {
                    currentDisplay[x][y] = bufferedImage.getRGB(x, y) < -11000000;
                }
            }
        }
        if (timeout != 0L) {
            int secondsLeft = (int)((timeout - new Date().getTime()) / 1000L);
            textNameHeight = 12 * scaleFactor;
            JLabel playerNameLabel = new JLabel("Time left: " + secondsLeft);
            playerNameLabel.setFont(new Font("Serif", 0, textNameHeight));
            textNameWidth = (int)playerNameLabel.getPreferredSize().getWidth();
            playerNameLabel.setBounds(0, 0, textNameWidth, textNameHeight);
            bufferedImage = ImageRenderer.getCachedBufferedImageBySize(textNameWidth, textNameHeight);
            g2D = (Graphics2D)bufferedImage.getGraphics();
            g2D.setColor(Color.GRAY);
            g2D.fillRect(0, 0, textNameWidth, textNameHeight);
            playerNameLabel.paint(g2D);
            for (x = 0; x < textNameWidth; ++x) {
                for (y = 0; y < textNameHeight; ++y) {
                    currentDisplay[width - textNameWidth - 1 + x][y] = bufferedImage.getRGB(x, y) < -11000000;
                }
            }
        }
        return currentDisplay;
    }

    public static Color getColorByPlayerNumber(int playerNumber) {
        switch (playerNumber) {
            case 0: {
                return Color.GREEN;
            }
            case 1: {
                return Color.YELLOW;
            }
            case 2: {
                return Color.CYAN;
            }
            case 3: {
                return Color.BLUE;
            }
            case 4: {
                return Color.RED;
            }
            case 5: {
                return Color.PINK;
            }
            case 6: {
                return Color.ORANGE;
            }
            case 7: {
                return Color.LIGHT_GRAY;
            }
            case 8: {
                return Color.MAGENTA;
            }
            case 9: {
                return Color.DARK_GRAY;
            }
            case 10: {
                return Color.GRAY;
            }
        }
        return Color.WHITE;
    }

    private static Color getColorContrastByPlayerNumber(int playerNumber) {
        switch (playerNumber) {
            case 0: {
                return Color.BLACK;
            }
            case 1: {
                return Color.BLACK;
            }
            case 2: {
                return Color.BLACK;
            }
            case 3: {
                return Color.WHITE;
            }
            case 4: {
                return Color.WHITE;
            }
            case 5: {
                return Color.BLACK;
            }
            case 6: {
                return Color.BLACK;
            }
            case 7: {
                return Color.BLACK;
            }
            case 8: {
                return Color.WHITE;
            }
            case 9: {
                return Color.WHITE;
            }
            case 10: {
                return Color.WHITE;
            }
        }
        return Color.BLACK;
    }

    public static void renderVictory(JLabel view, VictoryMetaData victoryMetaData, double scaleFactor) {
        int score = victoryMetaData.getScore();
        String[][] scoreTableData = victoryMetaData.getScoreTableMetaData();
        int overallScore = 0;
        for (String[] scoreTableDatum : scoreTableData) {
            overallScore += Integer.parseInt(scoreTableDatum[1]);
        }
        view.setVerticalTextPosition(1);
        view.setFont(view.getFont().deriveFont(12.0f * (float)scaleFactor));
        if (!victoryMetaData.isBestOfTenMode()) {
            view.setText("Congratulations! You received " + overallScore + " points!");
        } else if (scoreTableData.length > ViewModel.numberOfRounds - 1) {
            view.setText("Congratulations! You finished all " + ViewModel.numberOfRounds + " rounds and got a score of " + overallScore + " points!");
        } else if (scoreTableData.length == 1) {
            view.setText("      Victory! You received " + score + " points this round. Continue with Enter!");
        } else {
            view.setText("Victory! You received " + score + " points this round and " + overallScore + " points in all rounds. Press Enter!");
        }
        boolean showTreasures = ImageRenderer.shouldShowTreasures(victoryMetaData);
        Object[][] scoreTableDataFiltered = new String[scoreTableData.length][scoreTableData[0].length - 2];
        int counter = 0;
        for (String string : scoreTableData) {
            System.arraycopy(string, 0, scoreTableDataFiltered[counter], 0, 5);
            if (showTreasures) {
                scoreTableDataFiltered[counter][2] = string[6];
            }
            ++counter;
        }
        Object[] columnNames = showTreasures ? new String[]{"round number", "score", "treasures", "needed distance", "needed time"} : new String[]{"round number", "score", "shortest distance", "needed distance", "needed time"};
        int additionalYDistanceForTable = (int)(50.0 * scaleFactor);
        int rowHight = 16;
        int n = 500;
        int fontSize = 12;
        int headerHight = 30;
        JTable jTable = new JTable(scoreTableDataFiltered, columnNames);
        jTable.setFont(new Font("Serif", 0, (int)((double)fontSize * scaleFactor)));
        jTable.setBounds(0, additionalYDistanceForTable, (int)((double)n * scaleFactor), (int)((double)(rowHight * scoreTableData.length) * scaleFactor));
        jTable.setRowHeight((int)((double)rowHight * scaleFactor));
        TableColumnModel columnModel = jTable.getColumnModel();
        columnModel.getColumn(0).setWidth((int)(100.0 * scaleFactor));
        columnModel.getColumn(1).setWidth((int)(60.0 * scaleFactor));
        columnModel.getColumn(2).setWidth((int)(120.0 * scaleFactor));
        columnModel.getColumn(3).setWidth((int)(120.0 * scaleFactor));
        columnModel.getColumn(4).setWidth((int)(100.0 * scaleFactor));
        JTableHeader tableHeaderComp = jTable.getTableHeader();
        tableHeaderComp.setFont(new Font("Serif", 0, (int)((double)fontSize * scaleFactor)));
        tableHeaderComp.setBounds(0, additionalYDistanceForTable, (int)((double)n * scaleFactor), (int)((double)headerHight * scaleFactor));
        int totalWidth = (int)((double)n * scaleFactor);
        int totalHeight = tableHeaderComp.getHeight() + jTable.getHeight();
        BufferedImage tableImage = new BufferedImage(totalWidth, totalHeight + additionalYDistanceForTable, 2);
        Graphics2D g2D = (Graphics2D)tableImage.getGraphics();
        g2D.setColor(view.getBackground());
        g2D.fillRect(0, 0, totalWidth, totalHeight + additionalYDistanceForTable);
        g2D.translate(0, additionalYDistanceForTable);
        tableHeaderComp.paint(g2D);
        g2D.translate(0, tableHeaderComp.getHeight());
        jTable.paint(g2D);
        view.setIcon(new ImageIcon(tableImage));
        view.getParent().revalidate();
        view.revalidate();
        view.getParent().repaint();
        view.repaint();
    }

    private static boolean shouldShowTreasures(VictoryMetaData victoryMetaData) {
        for (String[] records : victoryMetaData.getScoreTableMetaData()) {
            if (records.length <= 6 || records[6].equals("0")) continue;
            return true;
        }
        return false;
    }

    public static void renderVictoryColored(JLabel view, HashMap<Integer, VictoryMetaData> victoryMetaDataMap, ArrayList<String> playerNameList, int currentPlayerNumber, double scaleFactor, boolean isHost) {
        VictoryMetaData victoryMetaData = victoryMetaDataMap.get(currentPlayerNumber);
        int numberOfPlayers = victoryMetaDataMap.size();
        if (numberOfPlayers == 1) {
            ImageRenderer.renderVictory(view, victoryMetaData, scaleFactor);
            return;
        }
        Integer[] playerPositions = new Integer[numberOfPlayers];
        final Integer[] playerPositionsReverse = new Integer[numberOfPlayers];
        Integer[] playerScore = new Integer[numberOfPlayers];
        int numberOfRounds = 0;
        for (int i = 0; i < numberOfPlayers; ++i) {
            if (!victoryMetaDataMap.containsKey(i)) continue;
            VictoryMetaData currentVictoryMetaData = victoryMetaDataMap.get(i);
            String[][] scoreTableData = currentVictoryMetaData.getScoreTableMetaData();
            int overallScore = 0;
            int counter = 0;
            for (String[] scoreTableDatum : scoreTableData) {
                overallScore += Integer.parseInt(scoreTableDatum[1]);
                if (++counter <= numberOfRounds) continue;
                numberOfRounds = counter;
            }
            playerScore[i] = overallScore;
        }
        HashSet<Integer> alreadySortedPlayers = new HashSet<Integer>();
        for (int i = 0; i < numberOfPlayers; ++i) {
            int bestScore = 0;
            int bestPlayerIndex = 0;
            for (int j = 0; j < numberOfPlayers; ++j) {
                if (!victoryMetaDataMap.containsKey(j) || playerScore[j] <= bestScore || alreadySortedPlayers.contains(j)) continue;
                bestScore = playerScore[j];
                bestPlayerIndex = j;
            }
            playerPositions[bestPlayerIndex] = i;
            playerPositionsReverse[i] = bestPlayerIndex;
            alreadySortedPlayers.add(bestPlayerIndex);
        }
        boolean isBestOfTenMode = victoryMetaData.isBestOfTenMode();
        boolean isTreasureMode = false;
        for (VictoryMetaData victoryMetaDataFromLoop : victoryMetaDataMap.values()) {
            if (!ImageRenderer.shouldShowTreasures(victoryMetaDataFromLoop)) continue;
            isTreasureMode = true;
            break;
        }
        ArrayList<String> columnList = new ArrayList<String>();
        int bestOfTenIndexAddition = 0;
        columnList.add("player name");
        columnList.add("round score");
        if (isBestOfTenMode) {
            columnList.add("total score");
            bestOfTenIndexAddition = 1;
        }
        columnList.add("needed time");
        if (isTreasureMode) {
            columnList.add("treasures");
        }
        Object[][] mappedScoreTableData = new String[numberOfPlayers][columnList.size()];
        for (int i = 0; i < numberOfPlayers; ++i) {
            if (!victoryMetaDataMap.containsKey(i)) continue;
            VictoryMetaData currentVictoryMetaData = victoryMetaDataMap.get(i);
            int score = currentVictoryMetaData.getScore();
            String[][] scoreTableData = currentVictoryMetaData.getScoreTableMetaData();
            int playerPosition = playerPositions[i];
            mappedScoreTableData[playerPosition][0] = playerNameList.get(i);
            if (victoryMetaData.isBestOfTenMode()) {
                mappedScoreTableData[playerPosition][2] = "" + playerScore[i];
            }
            if (scoreTableData.length < numberOfRounds) {
                mappedScoreTableData[playerPosition][1] = "-";
                mappedScoreTableData[playerPosition][2 + bestOfTenIndexAddition] = "-";
                if (!isTreasureMode) continue;
                mappedScoreTableData[playerPosition][3 + bestOfTenIndexAddition] = "-";
                continue;
            }
            mappedScoreTableData[playerPosition][1] = "" + score;
            mappedScoreTableData[playerPosition][2 + bestOfTenIndexAddition] = scoreTableData[scoreTableData.length - 1][4];
            if (!isTreasureMode) continue;
            mappedScoreTableData[playerPosition][3 + bestOfTenIndexAddition] = scoreTableData[scoreTableData.length - 1][6];
        }
        int score = victoryMetaData.getScore();
        String[][] scoreTableData = victoryMetaData.getScoreTableMetaData();
        int overallScore = playerScore[currentPlayerNumber];
        view.setVerticalTextPosition(1);
        view.setFont(view.getFont().deriveFont(12.0f * (float)scaleFactor));
        String textAdditionEnter = "Start round " + (numberOfRounds + 1) + " with Enter!";
        if (!victoryMetaData.isBestOfTenMode()) {
            view.setText("Congratulations! You received " + overallScore + " points!");
        } else if (scoreTableData.length > ViewModel.numberOfRounds - 1) {
            view.setText("Congratulations! You finished all " + ViewModel.numberOfRounds + " rounds and got a score of " + overallScore + " points!");
        } else if (scoreTableData.length == 1) {
            view.setText("      Victory! You received " + score + " points this round. " + textAdditionEnter);
        } else {
            view.setText("Victory! You received " + score + " points this round and " + overallScore + " points in all rounds. " + textAdditionEnter);
        }
        Object[] columnNames = new String[columnList.size()];
        int counter = 0;
        for (String columnName : columnList) {
            columnNames[counter++] = columnName;
        }
        int additionalYDistanceForTable = (int)(50.0 * scaleFactor);
        int rowHight = 16;
        int tableWidth = 385;
        int fontSize = 12;
        int headerHight = 30;
        JTable jTable = new JTable(mappedScoreTableData, columnNames){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                int playerNumber = playerPositionsReverse[row];
                comp.setBackground(ImageRenderer.getColorByPlayerNumber(playerNumber));
                comp.setForeground(ImageRenderer.getColorContrastByPlayerNumber(playerNumber));
                return comp;
            }
        };
        TableColumnModel columnModel = jTable.getColumnModel();
        columnModel.getColumn(0).setWidth((int)(220.0 * scaleFactor));
        columnModel.getColumn(1).setWidth((int)(70.0 * scaleFactor));
        if (isBestOfTenMode) {
            columnModel.getColumn(2).setWidth((int)(70.0 * scaleFactor));
            tableWidth += 71;
        }
        columnModel.getColumn(2 + bestOfTenIndexAddition).setWidth((int)(100.0 * scaleFactor));
        if (isTreasureMode) {
            columnModel.getColumn(3 + bestOfTenIndexAddition).setWidth((int)(70.0 * scaleFactor));
            tableWidth += 71;
        }
        jTable.setFont(new Font("Serif", 0, (int)((double)fontSize * scaleFactor)));
        jTable.setBounds(0, additionalYDistanceForTable, (int)((double)tableWidth * scaleFactor), (int)((double)(rowHight * mappedScoreTableData.length) * scaleFactor));
        jTable.setRowHeight((int)((double)rowHight * scaleFactor));
        JTableHeader tableHeaderComp = jTable.getTableHeader();
        tableHeaderComp.setFont(new Font("Serif", 0, (int)((double)fontSize * scaleFactor)));
        tableHeaderComp.setBounds(0, additionalYDistanceForTable, (int)((double)tableWidth * scaleFactor), (int)((double)headerHight * scaleFactor));
        int totalWidth = (int)((double)tableWidth * scaleFactor);
        int totalHeight = tableHeaderComp.getHeight() + jTable.getHeight();
        BufferedImage tableImage = new BufferedImage(totalWidth, totalHeight + additionalYDistanceForTable, 2);
        Graphics2D g2D = (Graphics2D)tableImage.getGraphics();
        g2D.setColor(view.getBackground());
        g2D.fillRect(0, 0, totalWidth, totalHeight + additionalYDistanceForTable);
        g2D.translate(0, additionalYDistanceForTable);
        tableHeaderComp.paint(g2D);
        g2D.translate(0, tableHeaderComp.getHeight());
        jTable.paint(g2D);
        view.setIcon(new ImageIcon(tableImage));
    }

    public static int getOsScaleFactor() {
        try {
            Object screen = Class.forName("sun.awt.CGraphicsDevice").cast(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
            Method getScaleFactor = screen.getClass().getDeclaredMethod("getScaleFactor", new Class[0]);
            Object obj = getScaleFactor.invoke(screen, new Object[0]);
            if (obj instanceof Integer) {
                return (Integer)obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    private static BufferedImage getCachedBufferedImageBySize(int width, int height) {
        int index = width + height * 10000;
        if (tempBufferedImageMap.containsKey(index)) {
            return tempBufferedImageMap.get(index);
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        tempBufferedImageMap.put(index, bufferedImage);
        return bufferedImage;
    }
}

