/*
 * Decompiled with CFR 0.152.
 */
package rendering;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import network.LabyrinthFieldMetaData;

public class SimpleLabyrinthComponent
extends JComponent {
    private LabyrinthFieldMetaData labyrinthFieldMetaData;
    private int width;
    private int height;
    private int posX;
    private int posY;
    private long timeout;
    private HashMap<Object, BufferedImage> bufferedImageMap = new HashMap();
    private BufferedImage bufferedImage;

    public void setRenderData(LabyrinthFieldMetaData labyrinthFieldMetaData, int width, int height, int posX, int posY, long timeout) {
        this.labyrinthFieldMetaData = labyrinthFieldMetaData;
        this.width = width;
        this.height = height;
        this.posX = posX;
        this.posY = posY;
        this.timeout = timeout;
        if (this.bufferedImage == null || this.bufferedImage.getWidth() != width || this.bufferedImage.getHeight() != height) {
            this.bufferedImage = new BufferedImage(width, height, 2);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.bufferedImage == null) {
            return;
        }
        Graphics2D graphics2D = this.bufferedImage.createGraphics();
        graphics2D.setColor(Color.BLACK);
        graphics2D.fillRect(0, 0, this.width, this.height);
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHints(rh);
        BufferedImage labyrinthImage = this.getLabyrinthImage(this.labyrinthFieldMetaData);
        int widthHalf = this.width / 2;
        int heightHalf = this.height / 2;
        int leftStart = this.posX - widthHalf;
        int topStart = this.posY - heightHalf;
        int labyrinthPartWidthStart = 0;
        int labyrinthPartHeightStart = 0;
        if (leftStart > 0 || topStart > 0) {
            labyrinthPartWidthStart = Math.max(0, leftStart);
            labyrinthPartHeightStart = Math.max(0, topStart);
            labyrinthImage = labyrinthImage.getSubimage(labyrinthPartWidthStart, labyrinthPartHeightStart, Math.min(this.width, labyrinthImage.getWidth() - labyrinthPartWidthStart), Math.min(this.height, labyrinthImage.getHeight() - labyrinthPartHeightStart));
        }
        int startX = labyrinthPartWidthStart > 0 ? 0 : -leftStart;
        int startY = labyrinthPartHeightStart > 0 ? 0 : -topStart;
        graphics2D.drawImage((Image)labyrinthImage, startX, startY, null);
        int scaleFactor = this.labyrinthFieldMetaData.getScaleFactor();
        int sizeOfOuterCircle = 8 * scaleFactor;
        int sizeOfInnerCircle = 3 * scaleFactor;
        graphics2D.setColor(Color.white);
        graphics2D.fillOval(widthHalf - sizeOfOuterCircle, heightHalf - sizeOfOuterCircle, sizeOfOuterCircle * 2 + 1, sizeOfOuterCircle * 2 + 1);
        graphics2D.setColor(Color.black);
        graphics2D.fillOval(widthHalf - sizeOfInnerCircle, heightHalf - sizeOfInnerCircle, sizeOfInnerCircle * 2 + 1, sizeOfInnerCircle * 2 + 1);
        int goalX = this.labyrinthFieldMetaData.getGoalX();
        int goalY = this.labyrinthFieldMetaData.getGoalY();
        if (Math.abs(goalX - this.posX) < widthHalf + sizeOfOuterCircle && Math.abs(goalY - this.posY) < heightHalf + sizeOfOuterCircle) {
            graphics2D.setColor(Color.white);
            graphics2D.fillOval(goalX - this.posX + widthHalf - sizeOfOuterCircle, goalY - this.posY + heightHalf - sizeOfOuterCircle, sizeOfOuterCircle * 2 + 1, sizeOfOuterCircle * 2 + 1);
            graphics2D.setColor(Color.black);
            graphics2D.fillOval(goalX - this.posX + widthHalf - sizeOfInnerCircle, goalY - this.posY + heightHalf - sizeOfInnerCircle, sizeOfInnerCircle * 2 + 1, sizeOfInnerCircle * 2 + 1);
        }
        if (this.timeout != 0L) {
            int textNameWidth;
            BufferedImage bufferedImage;
            int secondsLeft = (int)((this.timeout - new Date().getTime()) / 1000L);
            int textNameHeight = 12 * scaleFactor;
            String text = "Time left: " + secondsLeft;
            if (this.bufferedImageMap.containsKey(text)) {
                bufferedImage = this.bufferedImageMap.get(text);
                textNameWidth = bufferedImage.getWidth();
            } else {
                JLabel playerNameLabel = new JLabel(text);
                playerNameLabel.setFont(new Font("Serif", 0, textNameHeight));
                playerNameLabel.setForeground(Color.LIGHT_GRAY);
                textNameWidth = (int)playerNameLabel.getPreferredSize().getWidth();
                playerNameLabel.setBounds(0, 0, textNameWidth, textNameHeight);
                bufferedImage = new BufferedImage(textNameWidth, textNameHeight, 2);
                Graphics2D g2D = (Graphics2D)bufferedImage.getGraphics();
                g2D.setColor(Color.BLACK);
                g2D.fillRect(0, 0, textNameWidth, textNameHeight);
                playerNameLabel.paint(g2D);
                this.bufferedImageMap.put(text, bufferedImage);
            }
            this.addPartialImage(graphics2D, bufferedImage, this.width - textNameWidth - 1, 0, textNameWidth, textNameHeight);
        }
        Graphics2D graphicsDisplayLayer = (Graphics2D)g;
        graphicsDisplayLayer.drawImage((Image)this.bufferedImage, 0, 0, null);
    }

    private void addPartialImage(Graphics2D graphics2D, BufferedImage outerPoint, int pointX, int pointY, int width, int height) {
        if (pointX < 0 || pointY < 0) {
            int widthStart = Math.max(0, -pointX);
            int heightStart = Math.max(0, -pointY);
            if (width - widthStart <= 0 || height - heightStart <= 0) {
                return;
            }
            outerPoint.getSubimage(widthStart, heightStart, width - widthStart, height - heightStart);
        }
        graphics2D.drawImage((Image)outerPoint, pointX, pointY, null);
    }

    private BufferedImage getLabyrinthImage(LabyrinthFieldMetaData labyrinthFieldMetaData) {
        if (this.bufferedImageMap.containsKey(labyrinthFieldMetaData.getLabyrinthField())) {
            return this.bufferedImageMap.get(labyrinthFieldMetaData.getLabyrinthField());
        }
        boolean[][] wayPointMatrix = labyrinthFieldMetaData.getWayPointMatrixNonFlat();
        int width = wayPointMatrix.length;
        int height = wayPointMatrix[0].length;
        BufferedImage labyrinthImage = new BufferedImage(labyrinthFieldMetaData.getWidth(), labyrinthFieldMetaData.getHeight(), 2);
        Graphics2D graphics2D = (Graphics2D)labyrinthImage.getGraphics();
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHints(rh);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setColor(Color.white);
        int scaleFactor = labyrinthFieldMetaData.getScaleFactor();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (!wayPointMatrix[x][y]) continue;
                graphics2D.fillOval(x - scaleFactor, y - scaleFactor, scaleFactor * 2 + 1, scaleFactor * 2 + 1);
            }
        }
        this.bufferedImageMap.put(labyrinthFieldMetaData.getLabyrinthField(), labyrinthImage);
        return labyrinthImage;
    }
}

